/*
 * Decompiled with CFR 0.152.
 */
package egan.graphics;

import java.applet.Applet;
import java.awt.Color;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.RGBImageFilter;

public class BgFilter
extends RGBImageFilter {
    byte[] TILEpix;
    int[] redFILTER;
    int[] greenFILTER;
    int[] blueFILTER;
    int[] TILErgb;
    int TILEwidth;
    int TILEheight;
    int TILEmapSize;
    int TILEpixelSize;
    int TILEtransp;
    int xo;
    int yo;
    int ntc;
    int[] tc;

    public BgFilter(Applet applet, int n, int n2) {
        this.canFilterIndexColorModel = false;
        this.TILEpix = null;
        this.xo = 0;
        this.yo = 0;
        try {
            PixelGrabber pixelGrabber;
            String string = applet.getParameter("tile");
            if (string != null && (pixelGrabber = new PixelGrabber(applet.getImage(applet.getCodeBase(), string), 0, 0, -1, -1, false)).grabPixels()) {
                this.TILEwidth = pixelGrabber.getWidth();
                this.TILEheight = pixelGrabber.getHeight();
                this.TILEpix = (byte[])pixelGrabber.getPixels();
                IndexColorModel indexColorModel = (IndexColorModel)pixelGrabber.getColorModel();
                this.TILEmapSize = indexColorModel.getMapSize();
                this.TILEpixelSize = indexColorModel.getPixelSize();
                byte[] byArray = new byte[this.TILEmapSize];
                indexColorModel.getReds(byArray);
                byte[] byArray2 = new byte[this.TILEmapSize];
                indexColorModel.getGreens(byArray2);
                byte[] byArray3 = new byte[this.TILEmapSize];
                indexColorModel.getBlues(byArray3);
                this.TILEtransp = indexColorModel.getTransparentPixel();
                this.TILErgb = new int[this.TILEmapSize];
                this.redFILTER = new int[this.TILEmapSize];
                this.greenFILTER = new int[this.TILEmapSize];
                this.blueFILTER = new int[this.TILEmapSize];
                for (int i = 0; i < this.TILEmapSize; ++i) {
                    int n3 = (256 + byArray[i]) % 256;
                    int n4 = (256 + byArray2[i]) % 256;
                    int n5 = (256 + byArray3[i]) % 256;
                    this.TILErgb[i] = new Color(n3, n4, n5).getRGB();
                    this.redFILTER[i] = n3 - 255;
                    this.greenFILTER[i] = n4 - 255;
                    this.blueFILTER[i] = n5 - 255;
                }
            }
        }
        catch (Exception exception) {
            this.TILEpix = null;
        }
        try {
            this.xo = Integer.parseInt(applet.getParameter("xoffset"));
            this.yo = Integer.parseInt(applet.getParameter("yoffset"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setTranslucentColours(int n, int[] nArray) {
        this.tc = new int[n];
        this.ntc = n;
        for (int i = 0; i < n; ++i) {
            this.tc[i] = nArray[i];
        }
    }

    public boolean ok() {
        return this.TILEpix != null;
    }

    @Override
    public int filterRGB(int n, int n2, int n3) {
        int n4;
        boolean bl;
        boolean bl2 = bl = this.tc == null;
        if (!bl) {
            for (n4 = 0; n4 < this.ntc; ++n4) {
                if (n3 != this.tc[n4]) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            int n5;
            int n6;
            n4 = (n + this.xo) % this.TILEwidth;
            int n7 = (n2 + this.yo) % this.TILEheight;
            byte by = this.TILEpix[n7 * this.TILEwidth + n4];
            if (n3 == -1) {
                return this.TILErgb[by];
            }
            int n8 = this.redFILTER[by] + (0xFF & n3 >> 16);
            if (n8 < 0) {
                n8 = 0;
            }
            if ((n6 = this.greenFILTER[by] + (0xFF & n3 >> 8)) < 0) {
                n6 = 0;
            }
            if ((n5 = this.blueFILTER[by] + (0xFF & n3)) < 0) {
                n5 = 0;
            }
            int n9 = n3 & 0xFF000000;
            return n9 | n8 << 16 | n6 << 8 | n5;
        }
        return n3;
    }
}

