/*
 * Decompiled with CFR 0.152.
 */
package egan.graphics;

import java.awt.image.IndexColorModel;
import java.util.Random;

public class FractalMoon {
    public static final int FaultSpec = 5;
    public static final int CraterSpec = 5;
    public int moonWidth;
    public short[] dh;
    public short[] height;

    public FractalMoon(int n, int n2, int n3, Random random) {
        this.moonWidth = n;
        this.dh = new short[n * n];
        this.height = new short[n];
        if (n3 > 0) {
            double d = n2 == 0 ? 5.0 : Math.sqrt((double)n2 / 80.0);
            double[][] dArray = new double[n3][5];
            for (int i = 0; i < n3; ++i) {
                FractalMoon.randomCrater(random, dArray[i], d);
            }
            this.makeCraters(dArray, 0, n3);
        }
        if (n2 > 0) {
            double[][] dArray = new double[n2][5];
            for (int i = 0; i < n2; ++i) {
                FractalMoon.randomFault(random, dArray[i]);
            }
            this.addFaults(dArray, 0, n2, 1);
        }
    }

    public static void randomFault(Random random, double[] dArray) {
        for (int i = 0; i < 3; ++i) {
            dArray[i] = random.nextDouble() - 0.5;
        }
        dArray[3] = 1.0;
        FractalMoon.computeFault(dArray);
    }

    public static void computeFault(double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[2];
        dArray[4] = d * d + d2 * d2;
    }

    public static void randomCrater(Random random, double[] dArray, double d) {
        int n;
        double d2 = 0.0;
        for (n = 0; n < 3; ++n) {
            dArray[n] = random.nextDouble() - 0.5;
            d2 += dArray[n] * dArray[n];
        }
        d2 = Math.sqrt(d2);
        n = 0;
        while (n < 3) {
            int n2 = n++;
            dArray[n2] = dArray[n2] / d2;
        }
        dArray[2] = Math.abs(dArray[2]);
        dArray[3] = d * (1.0 + random.nextDouble());
        double d3 = 5.0E-4;
        double d4 = 0.01;
        dArray[4] = 0.6366197723675814 * d3 / (1.0 - random.nextDouble() * (1.0 - d3 / d4));
    }

    public void addFaults(double[][] dArray, int n, int n2, int n3) {
        int n4 = this.moonWidth / 2;
        int n5 = this.moonWidth - 1;
        double d = 2.0 / (double)n5;
        double d2 = 1.0 + d * 0.5;
        boolean bl = false;
        for (int i = 0; i < n4; ++i) {
            int n6 = i * this.moonWidth;
            int n7 = n5 - i;
            int n8 = n7 * this.moonWidth;
            double d3 = d * (double)i - d2;
            double d4 = 1.0 - d3 * d3;
            double d5 = Math.sqrt(d4);
            for (int j = 0; j < n2; ++j) {
                double d6;
                double[] dArray2 = dArray[n + j];
                short s = (short)((double)n3 * dArray2[3]);
                double d7 = dArray2[4];
                double d8 = dArray2[1];
                double d9 = d8 * d3;
                double d10 = d7 * d4 - d9 * d9;
                if (d6 >= 0.0) {
                    double d11;
                    double d12 = dArray2[0];
                    double d13 = d12 * d5;
                    bl = d9 - d11 < 0.0;
                    if (bl) {
                        int n9 = i;
                        this.height[n9] = (short)(this.height[n9] + s);
                    }
                    if (-d9 - d13 < 0.0) {
                        int n10 = n7;
                        this.height[n10] = (short)(this.height[n10] + s);
                    }
                    boolean bl2 = !bl;
                    double d14 = -d9 * d12;
                    double d15 = dArray2[2];
                    d10 = Math.abs(d15) * Math.sqrt(d10);
                    for (int k = -1; k <= 1; k += 2) {
                        int n11;
                        double d16;
                        double d17 = (d14 + (double)k * d10) / d7;
                        if ((d12 * d16 + d9) / d15 < 0.0) {
                            n11 = n6 + (int)((d2 + d17) / d);
                            if (bl = !bl) {
                                int n12 = n11;
                                this.dh[n12] = (short)(this.dh[n12] + s);
                                continue;
                            }
                            int n13 = n11;
                            this.dh[n13] = (short)(this.dh[n13] - s);
                            continue;
                        }
                        n11 = n8 + (int)((d2 - d17) / d);
                        if (bl2 = !bl2) {
                            int n14 = n11;
                            this.dh[n14] = (short)(this.dh[n14] - s);
                            continue;
                        }
                        int n15 = n11;
                        this.dh[n15] = (short)(this.dh[n15] + s);
                    }
                    continue;
                }
                if (d8 > 0.0) {
                    int n16 = i;
                    this.height[n16] = (short)(this.height[n16] + s);
                    continue;
                }
                int n17 = n7;
                this.height[n17] = (short)(this.height[n17] + s);
            }
        }
    }

    public void makeCraters(double[][] dArray, int n, int n2) {
        int n3;
        int n4;
        int n5 = this.moonWidth - 1;
        int n6 = 0;
        int n7 = 0;
        double d = 2.0 / (double)n5;
        double d2 = 1.0 + d * 0.5;
        double d3 = 0.0;
        double[] dArray2 = new double[]{1.25, 1.0, 0.05};
        int[] nArray = new int[]{1, -1, 0};
        for (int i = 0; i < n2; ++i) {
            double[] dArray3 = dArray[n + i];
            double d4 = dArray3[0];
            double d5 = dArray3[1];
            double d6 = dArray3[2];
            int n8 = (int)dArray3[3];
            double d7 = dArray3[4];
            d3 = 1.0 - d5 * d5;
            for (int j = 0; j < 3; ++j) {
                short s = (short)(n8 * nArray[j]);
                double d8 = 1.0 - dArray2[j] * d7;
                double d9 = Math.sqrt(d3 * (1.0 - d8 * d8));
                double d10 = d5 * d8;
                double d11 = d10 - d9;
                double d12 = d10 + d9;
                int n9 = (int)((d2 + d11) / d);
                int n10 = (int)((d2 + d12) / d);
                for (n4 = n9; n4 <= n10; ++n4) {
                    int n11;
                    n3 = n4 * this.moonWidth;
                    double d13 = d * (double)n4 - d2;
                    double d14 = (d13 - d11) * (d12 - d13);
                    if (!(d14 >= 0.0)) continue;
                    d14 = Math.abs(d6) * Math.sqrt(d14);
                    double d15 = d8 - d5 * d13;
                    for (int k = -1; k <= 1; k += 2) {
                        double d16;
                        double d17 = (d15 * d4 + (double)k * d14) / d3;
                        n11 = (d15 - d4 * d16) / d6 <= 0.0 ? (d17 < 0.0 ? n3 : n3 + n5) : n3 + (int)((d2 + d17) / d);
                        if (k < 0) {
                            n6 = n11;
                            continue;
                        }
                        n7 = n11;
                    }
                    for (n11 = n6; n11 <= n7; ++n11) {
                        this.dh[n11] = s;
                    }
                }
            }
        }
        for (n4 = 0; n4 < this.moonWidth; ++n4) {
            n3 = n4 * this.moonWidth;
            short s = 0;
            for (int i = 0; i < this.moonWidth; ++i) {
                short s2 = this.dh[n3];
                this.dh[n3++] = (short)(s2 - s);
                s = s2;
            }
        }
    }

    public static IndexColorModel greyScale(int n) {
        byte[] byArray = new byte[3 * n];
        int n2 = 255 / (n - 1);
        for (int i = 0; i < n; ++i) {
            byte by;
            int n3 = 3 * i;
            byArray[n3] = by = (byte)(n2 * i);
            byArray[n3 + 1] = by;
            byArray[n3 + 2] = by;
        }
        return new IndexColorModel(8, n, byArray, 0, false, -1);
    }

    public byte[] render(int n, int n2) {
        byte[] byArray = new byte[this.moonWidth * this.moonWidth];
        int n3 = n / 2;
        int n4 = (int)Math.sqrt(n) / 4;
        int n5 = n3 - 3 * n4;
        int n6 = n3 + 3 * n4;
        int n7 = n6 - n5;
        int n8 = n2 - 1;
        int n9 = this.moonWidth - 1;
        double d = 2.0 / (double)n9;
        double d2 = 1.0 + d * 0.5;
        int n10 = 0;
        boolean bl = true;
        for (int i = 0; i < this.moonWidth; ++i) {
            double d3 = d * (double)i - d2;
            double d4 = d3 * d3;
            int n11 = this.height[i] - n5;
            for (int j = 0; j < this.moonWidth; ++j) {
                double d5 = d * (double)j - d2;
                byArray[n10++] = (byte)(d5 * d5 + d4 <= 1.0 ? n8 * (n11 < 0 ? 0 : (n11 > n7 ? n7 : (n11 += this.dh[n10]))) / n7 : 0);
            }
        }
        return byArray;
    }
}

