/*
 * Decompiled with CFR 0.152.
 */
package egan.graphics;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.util.Random;

public class GraphicsUtils {
    public static final Color[] spectrum = new Color[]{Color.red, new Color(1.0f, 0.6f, 0.0f), Color.yellow, Color.green, Color.blue, new Color(0.2f, 0.4f, 0.6f), new Color(0.8f, 0.6f, 1.0f)};
    static Color[] ct = null;
    static IndexColorModel HTMLicm = null;
    static ColorModel dcm = null;
    static String fontName = null;
    static Font fnt = null;
    static FontMetrics fm;
    static int fa;
    static int fd;
    static int fh;
    static final RenderingHints aaON;
    static final Color statusCol;
    static double[] a1;
    static double[] a2;

    public static Color[][] randomPalette(int n, int n2, int n3) {
        Color[][] colorArray = new Color[n][n2];
        float f = (float)Math.random();
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = (f + (float)i * 1.0f / (float)n) % 1.0f;
        }
        double[][] dArray = new double[n][3];
        for (int i = 0; i < n; ++i) {
            int n4;
            int n5 = Color.HSBtoRGB(fArray[i], 1.0f, 1.0f);
            for (n4 = 0; n4 < 3; ++n4) {
                double d = (double)(n5 >> n4 * 8 & 0xFF) / 255.0;
                if (i > 0) {
                    if (n3 == 1) {
                        if (i % 2 == 0) {
                            d = dArray[0][n4] * dArray[i - 1][n4];
                        }
                    } else if (n3 == 2) {
                        d = (2.0 + dArray[0][n4]) / 3.0 * d;
                    }
                }
                dArray[i][n4] = d;
            }
            for (n4 = 0; n4 < n2; ++n4) {
                int n6 = 255 - (n2 - 1 - n4) * 51;
                n5 = 0;
                for (int j = 0; j < 3; ++j) {
                    int n7 = (int)(dArray[i][j] * (double)n6);
                    n5 |= n7 << j * 8;
                }
                colorArray[i][n4] = new Color(n5);
            }
        }
        return colorArray;
    }

    public static Color HTMLcolour(int n) {
        if (ct == null) {
            ct = new Color[216];
        }
        if (ct[n] == null) {
            GraphicsUtils.ct[n] = new Color(51 * (n / 36), 51 * (n / 6 % 6), 51 * (n % 6));
        }
        return ct[n];
    }

    public static Color randomHTMLcolour(Random random) {
        return GraphicsUtils.HTMLcolour((int)(216.0 * random.nextDouble()));
    }

    public static void drawPix(Component component, Graphics graphics, byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        if (HTMLicm == null) {
            byte[] byArray2 = new byte[651];
            for (int i = 0; i < 216; ++i) {
                int n6 = 3 * i;
                byArray2[n6] = (byte)(51 * (i / 36));
                byArray2[n6 + 1] = (byte)(51 * (i / 6 % 6));
                byArray2[n6 + 2] = (byte)(51 * (i % 6));
            }
            HTMLicm = new IndexColorModel(8, 217, byArray2, 0, false, 216);
        }
        graphics.drawImage(component.createImage(new MemoryImageSource(n, n2, (ColorModel)HTMLicm, byArray, 0, n3)), n4, n5, null);
    }

    public static void drawPixDCM(Component component, Graphics graphics, int[] nArray, int n, int n2, int n3, int n4, int n5) {
        if (dcm == null) {
            dcm = ColorModel.getRGBdefault();
        }
        graphics.drawImage(component.createImage(new MemoryImageSource(n, n2, dcm, nArray, 0, n3)), n4, n5, null);
    }

    public static void drawPixDCM(Component component, Graphics graphics, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        if (dcm == null) {
            dcm = ColorModel.getRGBdefault();
        }
        graphics.drawImage(component.createImage(new MemoryImageSource(n, n2, dcm, nArray, n3, n4)), n5, n6, null);
    }

    public static String getNiceFont(Component component) {
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        String[] stringArray2 = new String[]{"Serif", "TimesRoman", "SansSerif", "Helvetica", "Monospaced", "Courier", component.getFont().getName()};
        block0: for (int i = 0; i < stringArray2.length; ++i) {
            for (int j = 0; j < stringArray.length; ++j) {
                if (!stringArray2[i].equals(stringArray[j])) continue;
                fontName = stringArray[j];
                break block0;
            }
        }
        return fontName;
    }

    public static void showStatus(String string, Graphics graphics, Component component) {
        GraphicsUtils.showStatus(string, graphics, component, 0);
    }

    public static void showStatus(String string, Graphics graphics, Component component, int n) {
        if (fm == null) {
            fontName = GraphicsUtils.getNiceFont(component);
            fnt = new Font(fontName, 0, 12);
            fm = component.getFontMetrics(fnt);
            fa = fm.getAscent();
            fd = fm.getDescent();
            fh = fm.getHeight();
        }
        int n2 = component.getSize().width;
        int n3 = component.getSize().height;
        int n4 = 2;
        int n5 = fm.stringWidth(string);
        if (4 * n4 + n5 <= n2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHints(aaON);
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            GlyphVector glyphVector = fnt.createGlyphVector(fontRenderContext, string);
            graphics.setColor(statusCol);
            int n6 = n3 - 1 - n4 + (n - 1) * (fh + 2 * n4);
            graphics.fillRect(n4, n6, 2 * n4 + n5, fh + 2 * n4);
            graphics2D.setPaint(Color.black);
            graphics2D.drawGlyphVector(glyphVector, 2 * n4, n6 + fa + n4);
        } else {
            int n7 = string.length();
            int n8 = string.lastIndexOf(32, n7 / 2);
            GraphicsUtils.showStatus(string.substring(0, n8), graphics, component, n - 1);
            GraphicsUtils.showStatus(string.substring(n8 + 1, n7), graphics, component, n);
        }
    }

    public static void fillSmallCircle(Graphics graphics, int n, int n2, int n3) {
        if (n3 <= 3) {
            graphics.fillRect(n, n2, n3, n3);
        } else {
            int n4 = n + n3 - 1;
            int n5 = n2 + n3 - 1;
            graphics.fillRect(n + 1, n2 + 1, n3 - 2, n3 - 2);
            graphics.drawLine(n + 1, n2, n + n3 - 2, n2);
            graphics.drawLine(n + 1, n5, n + n3 - 2, n5);
            graphics.drawLine(n, n2 + 1, n, n2 + n3 - 2);
            graphics.drawLine(n4, n2 + 1, n4, n2 + n3 - 2);
        }
    }

    public static double approximateGaussianIntegral(double d) {
        if (d <= -1.0) {
            return 0.0;
        }
        if (d >= 1.0) {
            return 1.0;
        }
        double d2 = d * d;
        return 0.5 + (945.0 - d2 * (840.0 - d2 * (504.0 - d2 * (180.0 - 35.0 * d2)))) * d / 928.0;
    }

    public static int pixellatedGaussian(double d, double d2, double[] dArray) {
        int n = (int)Math.floor(d - d2);
        int n2 = (int)Math.floor(d + d2);
        int n3 = n2 - n + 1;
        double d3 = 0.0;
        double d4 = GraphicsUtils.approximateGaussianIntegral(0.5 / d2) - GraphicsUtils.approximateGaussianIntegral(-0.5 / d2);
        for (int i = n; i <= n2; ++i) {
            double d5 = ((double)(i + 1) - d) / d2;
            double d6 = GraphicsUtils.approximateGaussianIntegral(d5);
            dArray[i - n] = (d6 - d3) / d4;
            d3 = d6;
        }
        return n3;
    }

    public static void gaussianDisk(Graphics graphics, double d, double d2, double d3, float f, float f2, float f3) {
        int n = (int)Math.ceil(2.0 * d3 + 1.0);
        if (a1 == null || a1.length < n) {
            a1 = new double[n];
        }
        if (a2 == null || a2.length < n) {
            a2 = new double[n];
        }
        int n2 = GraphicsUtils.pixellatedGaussian(d, d3, a1);
        int n3 = GraphicsUtils.pixellatedGaussian(d2, d3, a2);
        int n4 = (int)Math.floor(d - d3);
        int n5 = (int)Math.floor(d2 - d3);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                float f4 = f3 * (float)(a1[i] * a2[j]);
                if (!(f4 > 0.1f)) continue;
                graphics.setColor(new Color(Color.HSBtoRGB(f, f2, f4)));
                graphics.drawLine(n4 + i, n5 + j, n4 + i, n5 + j);
            }
        }
    }

    public static void gaussianDisk(int[][][] nArray, double d, double d2, double d3, float f, float f2, float f3) {
        int n = (int)Math.ceil(2.0 * d3 + 1.0);
        int n2 = nArray.length;
        int n3 = nArray[0].length;
        if (a1 == null || a1.length < n) {
            a1 = new double[n];
        }
        if (a2 == null || a2.length < n) {
            a2 = new double[n];
        }
        int n4 = GraphicsUtils.pixellatedGaussian(d, d3, a1);
        int n5 = GraphicsUtils.pixellatedGaussian(d2, d3, a2);
        int n6 = (int)Math.floor(d - d3);
        int n7 = (int)Math.floor(d2 - d3);
        for (int i = 0; i < n4; ++i) {
            int n8 = n6 + i;
            if (n8 < 0 || n8 >= n2) continue;
            for (int j = 0; j < n5; ++j) {
                int n9 = n7 + j;
                if (n9 < 0 || n9 >= n3) continue;
                float f4 = f3 * (float)(a1[i] * a2[j]);
                Color color = new Color(Color.HSBtoRGB(f, f2, f4));
                int[] nArray2 = nArray[n8][n9];
                if (nArray2 == null) {
                    int[] nArray3 = new int[3];
                    nArray[n8][n9] = nArray3;
                    nArray2 = nArray3;
                }
                nArray2[0] = nArray2[0] + color.getRed();
                nArray2[1] = nArray2[1] + color.getGreen();
                nArray2[2] = nArray2[2] + color.getBlue();
            }
        }
    }

    public static void uniformDisk(Graphics graphics, double d, double d2, double d3, float f, float f2, float f3, int n) {
        int n2 = (int)Math.floor(d - d3);
        int n3 = (int)Math.floor(d2 - d3);
        int n4 = (int)Math.floor(d + d3);
        int n5 = (int)Math.floor(d2 + d3);
        boolean bl = n2 == n4 && n3 == n5;
        double d4 = d3 * d3;
        double d5 = 1.0 / (double)(n + 1);
        double d6 = 1.0 / (double)(n * n);
        for (int i = n2; i <= n4; ++i) {
            for (int j = n3; j <= n5; ++j) {
                double d7;
                if (bl) {
                    d7 = 1.0;
                } else {
                    d7 = 0.0;
                    double d8 = (double)i + d5 - d;
                    int n6 = 0;
                    while (n6 < n) {
                        double d9 = (double)j + d5 - d2;
                        double d10 = d8 * d8;
                        int n7 = 0;
                        while (n7 < n) {
                            if (d10 + d9 * d9 < d4) {
                                d7 += d6;
                            }
                            ++n7;
                            d9 += d5;
                        }
                        ++n6;
                        d8 += d5;
                    }
                }
                float f4 = f3 * (float)d7;
                if (!(f4 > 0.1f)) continue;
                graphics.setColor(new Color(Color.HSBtoRGB(f, f2, f4)));
                graphics.drawLine(i, j, i, j);
            }
        }
    }

    public static void uniformDisk(int[][][] nArray, double d, double d2, double d3, float f, float f2, float f3, int n) {
        int n2 = nArray.length;
        int n3 = nArray[0].length;
        int n4 = (int)Math.floor(d - d3);
        int n5 = (int)Math.floor(d2 - d3);
        int n6 = (int)Math.floor(d + d3);
        int n7 = (int)Math.floor(d2 + d3);
        boolean bl = n4 == n6 && n5 == n7;
        double d4 = d3 * d3;
        double d5 = 1.0 / (double)(n + 1);
        double d6 = 1.0 / (double)(n * n);
        for (int i = n4; i <= n6; ++i) {
            if (i < 0 || i >= n2) continue;
            for (int j = n5; j <= n7; ++j) {
                double d7;
                if (j < 0 || j >= n3) continue;
                if (bl) {
                    d7 = 1.0;
                } else {
                    d7 = 0.0;
                    double d8 = (double)i + d5 - d;
                    int n8 = 0;
                    while (n8 < n) {
                        double d9 = (double)j + d5 - d2;
                        double d10 = d8 * d8;
                        int n9 = 0;
                        while (n9 < n) {
                            if (d10 + d9 * d9 < d4) {
                                d7 += d6;
                            }
                            ++n9;
                            d9 += d5;
                        }
                        ++n8;
                        d8 += d5;
                    }
                }
                float f4 = f3 * (float)d7;
                Color color = new Color(Color.HSBtoRGB(f, f2, f4));
                int[] nArray2 = nArray[i][j];
                if (nArray2 == null) {
                    int[] nArray3 = new int[3];
                    nArray[i][j] = nArray3;
                    nArray2 = nArray3;
                }
                nArray2[0] = nArray2[0] + color.getRed();
                nArray2[1] = nArray2[1] + color.getGreen();
                nArray2[2] = nArray2[2] + color.getBlue();
            }
        }
    }

    public static void setAA(Graphics graphics) {
        if (graphics != null) {
            ((Graphics2D)graphics).setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        }
    }

    static {
        aaON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        statusCol = new Color(255, 255, 200);
        a1 = null;
        a2 = null;
    }
}

