/*
 * Decompiled with CFR 0.152.
 */
package egan.maths;

public class Polynomial {
    public int order;
    public double[] coeffs;

    public Polynomial(double[] dArray, int n) {
        this.coeffs = dArray;
        this.order = n;
    }

    public double evaluate(double d) {
        double d2 = this.coeffs[this.order];
        for (int i = this.order - 1; i >= 0; --i) {
            d2 = d2 * d + this.coeffs[i];
        }
        return d2;
    }

    public Polynomial product(Polynomial polynomial) {
        int n = polynomial.order;
        int n2 = this.order + n;
        double[] dArray = polynomial.coeffs;
        double[] dArray2 = new double[n2 + 1];
        for (int i = 0; i <= this.order; ++i) {
            double d = this.coeffs[i];
            if (d == 0.0) continue;
            for (int j = 0; j <= n; ++j) {
                int n3 = i + j;
                dArray2[n3] = dArray2[n3] + d * dArray[j];
            }
        }
        return new Polynomial(dArray2, n2);
    }

    public Polynomial derivative() {
        return this.derivative(1);
    }

    public Polynomial derivative(int n) {
        if (n == 0) {
            return new Polynomial(this.coeffs, this.order);
        }
        if (this.order < n) {
            double[] dArray = new double[]{0.0};
            return new Polynomial(dArray, 0);
        }
        double[] dArray = new double[this.order - n + 1];
        for (int i = n; i <= this.order; ++i) {
            double d = i;
            for (int j = 1; j < n; ++j) {
                d *= (double)(i - j);
            }
            dArray[i - n] = d * this.coeffs[i];
        }
        return new Polynomial(dArray, this.order - n);
    }

    public int zeroes(double[] dArray, double d, double d2, double d3) {
        int n;
        int n2;
        block11: {
            block12: {
                double d4;
                block10: {
                    n2 = 0;
                    dArray[n2++] = d;
                    n = this.order;
                    while (this.order >= 0 && this.coeffs[this.order] == 0.0) {
                        --this.order;
                    }
                    if (this.order != 1) break block10;
                    double d5 = -this.coeffs[0] / this.coeffs[1];
                    if (d5 > d && d5 < d2) {
                        dArray[n2++] = d5;
                    }
                    break block11;
                }
                if (this.order != 2) break block12;
                double d6 = this.coeffs[2];
                double d7 = 2.0 * d6;
                double d8 = this.coeffs[1];
                double d9 = this.coeffs[0];
                double d10 = d8 * d8 - 4.0 * d6 * d9;
                if (!(d10 >= 0.0)) break block11;
                double d11 = (-d8 - (d10 = Math.sqrt(d10))) / d7;
                if (d11 > d && d11 < d2) {
                    dArray[n2++] = d11;
                }
                if (!(d10 > 0.0)) break block11;
                d11 = (-d8 + d10) / d7;
                if (!(d4 > d) || !(d11 < d2)) break block11;
                dArray[n2++] = d11;
                break block11;
            }
            if (this.order >= 3) {
                int n3;
                double[] dArray2 = new double[this.order + 2];
                double[] dArray3 = new double[this.order + 2];
                Polynomial polynomial = this.derivative();
                int n4 = polynomial.zeroes(dArray2, d, d2, d3);
                for (n3 = 0; n3 < n4; ++n3) {
                    dArray3[n3] = this.evaluate(dArray2[n3]);
                }
                for (n3 = 0; n3 < n4 - 1; ++n3) {
                    double d12;
                    double d13;
                    double d14;
                    if (dArray3[n3] == 0.0) {
                        if (n3 <= 0) continue;
                        dArray[n2++] = dArray2[n3];
                        continue;
                    }
                    if (!(dArray3[n3] * dArray3[n3 + 1] < 0.0)) continue;
                    double d15 = dArray2[n3];
                    double d16 = dArray2[n3 + 1];
                    double d17 = dArray3[n3];
                    double d18 = dArray3[n3 + 1];
                    double d19 = (d16 * d17 - d15 * d18) / (d17 - d18);
                    while (!(Math.abs(d14 = this.evaluate(d19)) < d3) && !(Math.abs(d13 = -d14 / (d12 = polynomial.evaluate(d19))) < d3)) {
                        double d20 = d19 + d13;
                        if (d20 < d15) {
                            d19 = (d19 + d15) / 2.0;
                            continue;
                        }
                        if (d20 > d16) {
                            d19 = (d19 + d16) / 2.0;
                            continue;
                        }
                        d19 = d20;
                    }
                    dArray[n2++] = d19;
                }
            }
        }
        dArray[n2++] = d2;
        this.order = n;
        return n2;
    }
}

