/*
 * Decompiled with CFR 0.152.
 */
package egan.maths;

import egan.maths.Polynomial;

public class SphericalHarmonic {
    double[] lpc;
    double[] binc;

    public SphericalHarmonic(int n, int n2, int n3) {
        int n4;
        double[] dArray = new double[2 * n + 1];
        double d = 1.0;
        for (n4 = 0; n4 <= n; ++n4) {
            dArray[2 * (n - n4)] = d;
            d = d * (double)(n4 - n) / (double)(n4 + 1);
        }
        Polynomial polynomial = new Polynomial(dArray, 2 * n).derivative(n + n2);
        double d2 = 1.0;
        if (n3 == 0) {
            for (n4 = 0; n4 < n; ++n4) {
                d2 *= 2.0 * (double)(n4 + 1);
            }
        }
        if (n3 == 1) {
            int n5;
            int n6 = n2 / 2;
            int n7 = 2 * n6;
            boolean bl = n7 != n2;
            d = 1.0;
            double[] dArray2 = new double[n7 + 1];
            for (n4 = 0; n4 <= n6; ++n4) {
                dArray2[2 * n4] = d;
                d = d * (double)(n4 - n6) / (double)(n4 + 1);
            }
            Polynomial polynomial2 = polynomial.product(new Polynomial(dArray2, n7));
            Polynomial polynomial3 = polynomial2.derivative();
            if (bl) {
                int n8 = polynomial2.order;
                n5 = polynomial3.order;
                int n9 = n5 + 2;
                double[] dArray3 = polynomial2.coeffs;
                double[] dArray4 = polynomial3.coeffs;
                double[] dArray5 = new double[n9 + 1];
                for (int i = 0; i <= n9; ++i) {
                    int n10 = i - 1;
                    int n11 = i - 2;
                    dArray5[i] = (i <= n5 ? dArray4[i] : 0.0) - (n11 >= 0 && n11 <= n5 ? dArray4[n11] : 0.0) - (n10 >= 0 && n10 <= n8 ? dArray3[n10] : 0.0);
                }
                polynomial3 = new Polynomial(dArray5, n9);
            }
            double[] dArray6 = new double[polynomial3.order + 4];
            n5 = polynomial3.zeroes(dArray6, 0.0, 1.0, 1.0E-6);
            double d3 = 0.0;
            for (n4 = 0; n4 < n5; ++n4) {
                double d4 = dArray6[n4];
                double d5 = polynomial2.evaluate(d4);
                if (bl) {
                    d5 *= Math.sqrt(1.0 - d4 * d4);
                }
                d3 = Math.max(Math.abs(d5), d3);
            }
            d2 = d3;
        }
        this.lpc = new double[n - n2 + 1];
        for (n4 = 0; n4 <= n - n2; ++n4) {
            this.lpc[n4] = polynomial.coeffs[n4] / d2;
        }
        this.binc = new double[n2 + 1];
        d = 1.0;
        for (n4 = 0; n4 <= n2; ++n4) {
            this.binc[n4] = d;
            d = d * (double)(n2 - n4) / (double)(n4 + 1);
        }
    }

    public double value(double d, double d2, double d3) {
        double d4;
        int n;
        double d5 = d3 * d3;
        int n2 = this.lpc.length - 1;
        double d6 = this.lpc[n2];
        for (n = n2 - 2; n >= 0; n -= 2) {
            d6 = d6 * d5 + this.lpc[n];
        }
        if (n2 % 2 == 1) {
            d6 *= d3;
        }
        int n3 = this.binc.length - 1;
        int n4 = n3 / 2;
        if (d == 0.0) {
            if (n3 % 2 == 1) {
                d4 = 0.0;
            } else {
                double d7 = 1.0;
                n = 0;
                while (n < n3) {
                    if (n > 0 && n <= n4) {
                        d7 *= d7;
                        n *= 2;
                        continue;
                    }
                    d7 *= d2;
                    ++n;
                }
                d4 = (double)(1 - 2 * (n3 / 2 % 2)) * d7;
            }
        } else {
            double d8 = 1.0;
            n = 0;
            while (n < n3) {
                if (n > 0 && n <= n4) {
                    d8 *= d8;
                    n *= 2;
                    continue;
                }
                d8 *= d;
                ++n;
            }
            d4 = d8;
            double d9 = -(d2 * d2) / (d * d);
            for (n = 2; n <= n3; n += 2) {
                d4 += this.binc[n] * (d8 *= d9);
            }
        }
        return d6 *= d4;
    }
}

