/*
 * Decompiled with CFR 0.152.
 */
package egan.util;

import java.util.Random;

public class Utils {
    static final Random ran = new Random();
    static double[] temp = null;
    static int tempD = -1;

    public static void qs(int n, double[][] dArray, int n2, int n3) {
        double d = dArray[n2][n];
        double d2 = dArray[n3][n];
        for (int i = n2; i <= n3; ++i) {
            double d3 = dArray[i][n];
            if (d3 < d) {
                d = d3;
            }
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        Utils.qs(n, dArray, n2, n3, d, d2);
    }

    public static void qs(int n, double[][] dArray, int n2, int n3, double d, double d2) {
        double d3 = (d + d2) / 2.0;
        if (n3 > n2 && d3 > d && d3 < d2) {
            double d4 = d;
            double d5 = d2;
            int n4 = n2;
            int n5 = n3;
            while (true) {
                double d6;
                if (n4 <= n3) {
                    double d7;
                    d6 = dArray[n4][n];
                    if (d7 < d3) {
                        if (d6 > d4) {
                            d4 = d6;
                        }
                        ++n4;
                        continue;
                    }
                }
                while (n5 >= n2) {
                    double d8;
                    d6 = dArray[n5][n];
                    if (!(d8 >= d3)) break;
                    if (d6 < d5) {
                        d5 = d6;
                    }
                    --n5;
                }
                if (n4 >= n5) break;
                double[] dArray2 = dArray[n4];
                dArray[n4] = dArray[n5];
                dArray[n5] = dArray2;
            }
            if (n4 - n2 > n3 - n5) {
                Utils.qs(n, dArray, n2, n4 - 1, d, d4);
                Utils.qs(n, dArray, n5 + 1, n3, d5, d2);
            } else {
                Utils.qs(n, dArray, n5 + 1, n3, d5, d2);
                Utils.qs(n, dArray, n2, n4 - 1, d, d4);
            }
        }
    }

    public static double[] randomUnitVec(Random random, boolean bl) {
        if (random == null) {
            random = ran;
        }
        double d = Math.acos(1.0 - 2.0 * random.nextDouble());
        double d2 = Math.PI * 2 * random.nextDouble();
        double d3 = Math.sin(d);
        double d4 = Math.cos(d);
        double[] dArray = new double[]{d3 * Math.cos(d2), d3 * Math.sin(d2), bl ? Math.abs(d4) : d4};
        return dArray;
    }

    public static void setRotation(double[][] dArray, double d, double[] dArray2, double d2) {
        double d3 = Math.sin(d);
        double d4 = Math.cos(d);
        double d5 = d2 * d2;
        boolean bl = d2 <= 0.0 || d == 0.0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                dArray[i][j] = bl ? (double)(i == j ? 1 : 0) : (1.0 - d4) * dArray2[i] * dArray2[j] / d5 + (i == j ? d4 : (double)(1 - (i + 4 - j) % 3) * d3 * dArray2[3 - i - j] / d2);
            }
        }
    }

    public static void transform(double[][] dArray, double[] dArray2) {
        int n;
        int n2 = dArray.length;
        if (n2 != tempD) {
            temp = new double[n2];
            tempD = n2;
        }
        double[] dArray3 = temp;
        for (n = 0; n < n2; ++n) {
            dArray3[n] = 0.0;
            double[] dArray4 = dArray[n];
            for (int i = 0; i < n2; ++i) {
                int n3 = n;
                dArray3[n3] = dArray3[n3] + dArray4[i] * dArray2[i];
            }
        }
        for (n = 0; n < n2; ++n) {
            dArray2[n] = dArray3[n];
        }
    }

    public static void transform(double[][] dArray, double[] dArray2, double[] dArray3) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray3[i] = 0.0;
            double[] dArray4 = dArray[i];
            for (int j = 0; j < n; ++j) {
                int n2 = i;
                dArray3[n2] = dArray3[n2] + dArray4[j] * dArray2[j];
            }
        }
    }

    public static double normalise(double[] dArray) {
        return Utils.normalise(dArray, dArray.length);
    }

    public static double normalise(double[] dArray, int n) {
        int n2;
        double d = 0.0;
        for (n2 = 0; n2 < n; ++n2) {
            double d2 = dArray[n2];
            d += d2 * d2;
        }
        if (d > 0.0) {
            d = Math.sqrt(d);
            n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                dArray[n3] = dArray[n3] / d;
            }
        }
        return d;
    }

    public static double dot(double[] dArray, double[] dArray2) {
        return Utils.dot(dArray, dArray2, Math.min(dArray.length, dArray2.length));
    }

    public static double dot(double[] dArray, double[] dArray2, int n) {
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return d;
    }

    public static double[] cross(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[3];
        return Utils.cross(dArray, dArray2, dArray3);
    }

    public static double[] cross(double[] dArray, double[] dArray2, double[] dArray3) {
        for (int i = 0; i < 3; ++i) {
            int n = (i + 1) % 3;
            int n2 = (i + 2) % 3;
            dArray3[i] = dArray[n] * dArray2[n2] - dArray[n2] * dArray2[n];
        }
        return dArray3;
    }

    public static int[][] permutations(int n) {
        int n2 = 1;
        for (int i = 2; i <= n; ++i) {
            n2 *= i;
        }
        int[][] nArray = new int[n2][n + 1];
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4;
            int n5;
            int[] nArray2 = nArray[i];
            long l = 0L;
            int n6 = n;
            int n7 = n2;
            for (n5 = 0; n5 < n; ++n5) {
                n4 = i % n7 / (n7 / n6);
                for (n3 = 0; n3 < n; ++n3) {
                    if ((l & (long)(1 << n3)) != 0L) continue;
                    if (n4 == 0) break;
                    --n4;
                }
                nArray2[n5] = n3;
                l |= (long)(1 << n3);
                n7 /= n6;
                --n6;
            }
            n5 = 1;
            for (n4 = 0; n4 < n; ++n4) {
                for (n3 = n4 + 1; n3 < n; ++n3) {
                    if (nArray2[n4] <= nArray2[n3]) continue;
                    n5 *= -1;
                }
            }
            nArray2[n] = n5;
        }
        return nArray;
    }
}

