/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.applets.ScrollingApplet;
import egan.applets.deBruijn;
import java.awt.Color;
import java.awt.Graphics2D;

public class Escher
extends deBruijn {
    private static final long serialVersionUID = 1L;
    float[][][][][] insetsX;
    float[][][][][] insetsY;

    public void init() {
        super.init();
        this.minD = 3;
        this.coordWidth = 10.0;
        this.bfac0 = 0.5f;
    }

    ScrollingApplet getNewApplet() {
        return new Escher();
    }

    public void setup(long rseed, int dim) {
        super.setup(rseed, dim);
        int ng = this.mainParameter;
        this.insetsX = new float[ng][ng][2][2][4];
        this.insetsY = new float[ng][ng][2][2][4];
        for (int eD = 0; eD < ng; ++eD) {
            for (int fD = 0; fD < ng; ++fD) {
                int sf;
                int se;
                int os;
                if (eD == fD) continue;
                double xf = this.Gx[fD] / 2.0;
                double xe = this.Gx[eD] / 2.0;
                double yf = this.Gy[fD] / 2.0;
                double ye = this.Gy[eD] / 2.0;
                double dp = (xf * xe + yf * ye) / Math.sqrt((xf * xf + yf * yf) * (xe * xe + ye * ye));
                if (dp > 0.0) {
                    os = -1;
                    se = -1;
                    sf = 1;
                } else {
                    os = 1;
                    se = -1;
                    sf = -1;
                }
                double xx = (double)se * xe + (double)sf * xf;
                double yy = (double)se * ye + (double)sf * yf;
                double XX = 0.0;
                double YY = 0.0;
                double max = 0.0;
                for (int i = 0; i < ng; ++i) {
                    double dd;
                    double add;
                    if (i == eD || i == fD || !((add = Math.abs(dd = this.Gx[i] * xx + this.Gy[i] * yy)) > max)) continue;
                    max = add;
                    int s = dd < 0.0 ? -1 : 1;
                    XX = (double)s * this.Gx[i];
                    YY = (double)s * this.Gy[i];
                }
                double alpha = (double)(Math.abs(dp) < 0.48 ? 0.333f : 0.5f) * Math.sqrt((xx * xx + yy * yy) / (XX * XX + YY * YY));
                XX *= alpha;
                YY *= alpha;
                for (int ip = 0; ip < 2; ++ip) {
                    int ips = 1 - 2 * ip;
                    float[] ix = this.insetsX[eD][fD][0][ip];
                    float[] iy = this.insetsY[eD][fD][0][ip];
                    ix[0] = (float)(xe + (double)os * xf) / 2.0f;
                    iy[0] = (float)(ye + (double)os * yf) / 2.0f;
                    ix[1] = ix[0] + (float)XX;
                    iy[1] = iy[0] + (float)YY;
                    ix[3] = (float)((double)ips * ((double)(-os) * xe + xf) / 2.0);
                    iy[3] = (float)((double)ips * ((double)(-os) * ye + yf) / 2.0);
                    double Fx = ix[3] - ix[0];
                    double Fy = iy[3] - iy[0];
                    double Ex = -ix[3] - ix[0];
                    double Ey = -iy[3] - iy[0];
                    double p = (Fy * XX - Fx * YY) / (Ex * Fy - Ey * Fx);
                    ix[2] = ix[3] + (float)(p * Ex);
                    iy[2] = iy[3] + (float)(p * Ey);
                    float[] fix = this.insetsX[eD][fD][1][ip];
                    float[] fiy = this.insetsY[eD][fD][1][ip];
                    for (int j = 0; j < 4; ++j) {
                        int n = j;
                        ix[n] = (float)((double)ix[n] / this.inc);
                        int n2 = j;
                        iy[n2] = (float)((double)iy[n2] / this.inc);
                        fix[j] = -ix[j];
                        fiy[j] = -iy[j];
                    }
                }
            }
        }
    }

    public void drawTile(Graphics2D g2, float[] xp, float[] yp, Color col, int eD, int fD, int eV, int fV) {
        int m;
        float xcen = 0.0f;
        float ycen = 0.0f;
        this.rhomb.reset();
        for (m = 0; m < 4; ++m) {
            xcen += xp[m];
            ycen += yp[m];
            if (m == 0) {
                this.rhomb.moveTo(xp[m], yp[m]);
                continue;
            }
            this.rhomb.lineTo(xp[m], yp[m]);
        }
        xcen /= 4.0f;
        ycen /= 4.0f;
        this.rhomb.closePath();
        g2.setPaint(col);
        g2.fill(this.rhomb);
        g2.setPaint(Color.black);
        g2.draw(this.rhomb);
        this.rhomb.reset();
        for (m = 0; m < 4; ++m) {
            float xc = (xcen + xp[m]) / 2.0f;
            float yc = (ycen + yp[m]) / 2.0f;
            if (m == 0) {
                this.rhomb.moveTo(xc, yc);
                continue;
            }
            this.rhomb.lineTo(xc, yc);
        }
        this.rhomb.closePath();
        g2.fill(this.rhomb);
        int flip = 0;
        flip = (eD + fD) % this.mainParameter == 0 ? (10000000 + eV + (10000000 + eV + fV) / 2) % 2 : ((eD + fD) % this.mainParameter == 1 ? (10000000 + eV) % 4 / 2 : (10000002 + eV) % 4 / 2);
        for (int i = 0; i < 2; ++i) {
            float[] ix = this.insetsX[eD][fD][flip][i];
            float[] iy = this.insetsY[eD][fD][flip][i];
            this.rhomb.reset();
            this.rhomb.moveTo(xcen + ix[0], ycen + iy[0]);
            this.rhomb.lineTo(xcen + ix[1], ycen + iy[1]);
            this.rhomb.lineTo(xcen + ix[2], ycen + iy[2]);
            this.rhomb.lineTo(xcen + ix[3], ycen + iy[3]);
            this.rhomb.closePath();
            g2.setPaint(Color.white);
            g2.fill(this.rhomb);
            g2.setPaint(Color.black);
            g2.draw(this.rhomb);
        }
    }
}

