/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.applets.ScrollingApplet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.Random;

public class Gummelt
extends ScrollingApplet {
    private static final long serialVersionUID = 1L;
    float bfac0 = 0.2f;
    double[] Gx;
    double[] Gy;
    double[] Gd;
    double[][] Dets;
    double[] n2gonX;
    double[] n2gonY;
    double[][][] dartsX;
    double[][][] dartsY;
    double span0;
    double marg;
    float cfac;
    float[] dcf = new float[]{0.0f, 0.333f};
    float pcf = 0.666f;
    Color gonCol;
    static final BasicStroke str = new BasicStroke(1.5f, 0, 2);
    static final BasicStroke strThin = new BasicStroke(0.5f, 0, 2);
    static final RenderingHints alias = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

    ScrollingApplet getNewApplet() {
        return new Gummelt();
    }

    public void setup(long rseed, int dim) {
        int l;
        int ng = 5;
        int ng2 = 10;
        int ngM = 100 * ng2;
        Random r = new Random(rseed);
        this.span0 = 2.0 * (2.0 + r.nextDouble());
        double phase = r.nextDouble();
        this.cfac = r.nextFloat();
        this.gonCol = r.nextDouble() < 0.5 ? Color.black : Color.white;
        this.Gx = new double[ng];
        this.Gy = new double[ng];
        this.Gd = new double[ng];
        this.n2gonX = new double[ng2];
        this.n2gonY = new double[ng2];
        double sA = Math.PI / (double)ng;
        double hA = sA / 2.0;
        double norm = Math.sqrt(2.0 / (double)ng);
        for (int k = 0; k < ng; ++k) {
            double theta = (double)k * ((double)(ng % 2 + 1) * sA) + phase;
            double x = norm * Math.cos(theta);
            double y = norm * Math.sin(theta);
            this.Gx[k] = x;
            this.Gy[k] = y;
            this.Gd[k] = r.nextDouble();
            l = 2 * k;
            this.n2gonX[l] = x;
            this.n2gonY[l] = y;
            l = (ng + l) % ng2;
            this.n2gonX[l] = -x;
            this.n2gonY[l] = -y;
        }
        this.Gd[4] = -(this.Gd[0] + this.Gd[1] + this.Gd[2] + this.Gd[3] + 2.5);
        this.marg = norm * (1.0 + 0.5 / Math.sin(hA));
        this.dartsX = new double[2][ng2][6];
        this.dartsY = new double[2][ng2][6];
        int v0 = ng;
        int v1 = v0 + 1;
        int v2 = v0 + 2;
        int[][] dstruct = new int[][]{{1}, {2}, {3}, {3, 0, v1}, {3, 0, v2}, {2, 0, v1}};
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < ng2; ++j) {
                double[] dtx = this.dartsX[i][j];
                double[] dty = this.dartsY[i][j];
                for (l = 0; l < 6; ++l) {
                    int[] dl = dstruct[l];
                    dty[l] = 0.0;
                    dtx[l] = 0.0;
                    for (int ii = 0; ii < dl.length; ++ii) {
                        int jj = (ngM + j + (2 * i - 1) * dl[ii]) % ng2;
                        int n = l;
                        dtx[n] = dtx[n] + this.n2gonX[jj];
                        int n2 = l;
                        dty[n2] = dty[n2] + this.n2gonY[jj];
                    }
                }
            }
        }
        this.Dets = new double[ng][ng];
        for (int fD = 0; fD < ng; ++fD) {
            for (int eD = 0; eD < ng; ++eD) {
                this.Dets[fD][eD] = this.Gy[eD] * this.Gx[fD] - this.Gx[eD] * this.Gy[fD];
            }
        }
    }

    public void d(Graphics g, int w, int y1, int y2, long yoffs, boolean init) {
        int ng = 5;
        int ng2 = 10;
        int ngM = 100 * ng2;
        int wc = w / 2;
        int h2 = (y2 - y1) / 2;
        int hc = y1 + h2;
        float yy = 0.0f;
        Graphics2D g2 = (Graphics2D)g;
        g2.addRenderingHints(alias);
        GeneralPath poly = new GeneralPath(0, 30);
        g.setClip(0, y1, w, y2 - y1);
        g.setColor(Color.black);
        g.fillRect(0, y1, w, y2 - y1);
        if (init) {
            this.thisSeed = new Random().nextLong();
            this.setup(this.thisSeed, -1);
        }
        double[] gx = this.Gx;
        double[] gy = this.Gy;
        double[] gd = this.Gd;
        double[][] dets = this.Dets;
        double[][][] dtsX = this.dartsX;
        double[][][] dtsY = this.dartsY;
        double inc = this.span0 / 300.0;
        double xm1 = (double)wc * inc + this.marg;
        double xm0 = -xm1;
        double ym1 = (double)(yoffs + (long)h2) * inc + this.marg;
        double ym0 = (double)(yoffs - (long)h2) * inc - this.marg;
        double[] xm = new double[]{xm0, xm1};
        double[] ym = new double[]{ym0, ym1};
        double[] xep = new double[2];
        double[] yep = new double[2];
        for (int pass = 0; pass < 2; ++pass) {
            for (int eD = 0; eD < ng; ++eD) {
                int k;
                int i;
                int j;
                double xe = gx[eD];
                double ye = gy[eD];
                double de = gd[eD] + 0.5;
                int fD = (eD + 1) % ng;
                double xf = gx[fD];
                double yf = gy[fD];
                double df = gd[fD] + 0.5;
                double dd = dets[eD][fD];
                int lc = Integer.MAX_VALUE;
                int uc = Integer.MIN_VALUE;
                for (j = 0; j < 2; ++j) {
                    for (i = 0; i < 2; ++i) {
                        k = (int)Math.ceil(xe * xm[i] + ye * ym[j] + de);
                        if (k < lc) {
                            lc = k;
                        }
                        if (--k <= uc) continue;
                        uc = k;
                    }
                }
                for (int eV = lc; eV <= uc; ++eV) {
                    double y;
                    double x;
                    double ae = (double)eV - de;
                    int nn = 0;
                    for (int ii = 0; ii < 2 && nn < 2; ++ii) {
                        x = xm[ii];
                        y = (ae - gx[eD] * x) / gy[eD];
                        if (y >= ym0 && y <= ym1) {
                            xep[nn] = x;
                            yep[nn++] = y;
                            if (nn == 2) break;
                        }
                        if (!((x = (ae - gy[eD] * (y = ym[ii])) / gx[eD]) >= xm0) || !(x <= xm1)) continue;
                        xep[nn] = x;
                        yep[nn++] = y;
                    }
                    double xep0 = xep[0];
                    double xep1 = xep[1];
                    double yep0 = yep[0];
                    double yep1 = yep[1];
                    double xfae = xf * ae;
                    double yfae = yf * ae;
                    int lc0 = (int)Math.ceil(xf * xep0 + yf * yep0 + df);
                    int uc0 = (int)Math.floor(xf * xep1 + yf * yep1 + df);
                    if (uc0 < lc0) {
                        k = lc0;
                        lc0 = uc0 + 1;
                        uc0 = k - 1;
                    }
                    for (int fV = lc0; fV <= uc0; ++fV) {
                        float yc;
                        float xc;
                        int m;
                        double af = (double)fV - df;
                        x = (yfae - ye * af) / dd;
                        y = (xe * af - xfae) / dd;
                        int sig = eV + fV;
                        double xs = 0.0;
                        double ys = 0.0;
                        for (m = 0; m < ng; ++m) {
                            if (m == eD || m == fD) continue;
                            double gxm = gx[m];
                            double gym = gy[m];
                            double gdm = gd[m];
                            double sm = Math.floor(gxm * x + gym * y + gdm + 0.5);
                            sig += (int)sm;
                            double z = sm - gdm;
                            xs += z * gxm;
                            ys += z * gym;
                        }
                        sig = Math.abs(sig / 2 % 2);
                        m = sig * 2;
                        int vert = (((eD + fD) % 2 == 0 ? ng2 - 1 : eD + fD) + sig * ng) % ng2;
                        double ee = ae + 0.5 - (double)(m / 2);
                        double ff = af + 0.5 - (double)((m + 1) % 4 / 2);
                        double xa = xs + ee * xe + ff * xf - this.n2gonX[vert];
                        double ya = ys + ee * ye + ff * yf - this.n2gonY[vert];
                        float yaf = (float)ya;
                        poly.reset();
                        for (i = 0; i < ng2; ++i) {
                            xc = (float)((double)wc + (xa + this.n2gonX[i]) / inc);
                            yc = (float)((double)hc + (ya + this.n2gonY[i]) / inc - (double)yoffs);
                            if (i == 0) {
                                poly.moveTo(xc, yc);
                                continue;
                            }
                            poly.lineTo(xc, yc);
                        }
                        poly.closePath();
                        if (pass == 0) {
                            g2.setPaint(this.col(yaf, 1.0f, this.pcf));
                            g2.fill(poly);
                            for (i = 0; i < 2; ++i) {
                                for (j = 0; j < ng; j += 3) {
                                    int l = (ngM + vert + (2 * i - 1) * j) % ng2;
                                    poly.reset();
                                    for (k = 0; k < 6; ++k) {
                                        xc = (float)((double)wc + (xa + dtsX[i][l][k]) / inc);
                                        yc = (float)((double)hc + (ya + dtsY[i][l][k]) / inc - (double)yoffs);
                                        if (k == 0) {
                                            poly.moveTo(xc, yc);
                                            continue;
                                        }
                                        poly.lineTo(xc, yc);
                                    }
                                    poly.closePath();
                                    g2.setPaint(this.col(yaf, 1.0f, this.dcf[l % 2]));
                                    g2.fill(poly);
                                }
                            }
                            continue;
                        }
                        g2.setPaint(this.gonCol);
                        g2.setStroke(str);
                        g2.draw(poly);
                        poly.reset();
                        for (m = 0; m < 4; ++m) {
                            ee = ae + 0.5 - (double)(m / 2);
                            ff = af + 0.5 - (double)((m + 1) % 4 / 2);
                            xa = xs + ee * xe + ff * xf;
                            ya = ys + ee * ye + ff * yf;
                            xc = (float)((double)wc + xa / inc);
                            yc = (float)((double)hc + ya / inc - (double)yoffs);
                            if (m == 0) {
                                poly.moveTo(xc, yc);
                                continue;
                            }
                            poly.lineTo(xc, yc);
                        }
                        poly.closePath();
                        g2.setPaint(Color.gray);
                        g2.setStroke(strThin);
                        g2.draw(poly);
                    }
                }
            }
        }
        g.setClip(null);
    }

    Color col(float yy, float toef, float tsef) {
        float sfac1 = (float)(1.0 - Math.sin((double)yy / 171.0)) / 2.0f;
        float bfac = this.bfac0 + (1.0f - this.bfac0) * sfac1;
        return new Color(Color.HSBtoRGB((this.cfac + tsef + yy / 111.0f) % 1.0f, 0.7f * sfac1 + 0.3f, bfac * toef + (1.0f - bfac)));
    }

    public synchronized void mouseEntered(MouseEvent e) {
        this.mouseIN = true;
        this.showStatus("Click to redraw");
    }
}

