/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.applets.A2;
import egan.graphics.FractalMoon;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.util.Random;

public class LiquidMoon
extends A2 {
    private static final long serialVersionUID = 1L;
    byte[] finalPix;
    MemoryImageSource mis;
    Image im;
    byte[] moonPix;
    int nwaves = 1;
    double wn = 0.0;
    short[][] dx;
    short[][] dy;
    double waveAmp;
    double[][] wc;
    double[] ct = new double[1000];

    public boolean d(Graphics g, int w, int h, int p, int q, int f, boolean C, boolean TB, int L, int V) {
        int j;
        int i;
        int moonWidth = Math.min(w, h);
        int moonCentre = moonWidth / 2;
        double[] cosTab = this.ct;
        int twoPi = this.ct.length;
        int piOn2 = twoPi / 4;
        double piCon = (double)twoPi / (Math.PI * 2);
        double dist = 3.0;
        int xc = w / 2;
        int yc = h / 2;
        int ff = (int)this.F - 1;
        int highFrame = 4 * this.nframes - 1;
        double a = 0.0;
        double b = 0.0;
        double c = 0.0;
        double scale = 2.0 / (double)moonWidth;
        if (ff == 0) {
            Random r = new Random();
            this.nwaves = (int)(2.0 + 4.0 * r.nextDouble());
            this.wn = Math.PI * 2 / (0.05 + 0.3 * r.nextDouble());
            this.wc = new double[2][this.nwaves];
            this.wc[0][0] = 1.0 - (double)p * scale;
            this.wc[1][0] = 1.0 - (double)q * scale;
            for (i = 1; i < this.nwaves; ++i) {
                for (j = 0; j < 2; ++j) {
                    this.wc[j][i] = 2.0 * (r.nextDouble() - 0.5);
                }
            }
            this.waveAmp = 0.1 / Math.sqrt(this.nwaves);
            for (i = 0; i < twoPi; ++i) {
                cosTab[i] = Math.cos((double)i / piCon);
            }
            this.dx = new short[2][w * h];
            this.dy = new short[2][w * h];
            int NFAULTS = 2000;
            int NCRATERS = (int)(300.0 * (1.0 + r.nextDouble()));
            int NGREYS = 128;
            this.moonPix = new FractalMoon(moonWidth, NFAULTS, NCRATERS, r).render(NFAULTS, NGREYS);
            this.finalPix = new byte[w * h];
            this.mis = new MemoryImageSource(w, h, (ColorModel)FractalMoon.greyScale((int)NGREYS), this.finalPix, 0, w);
            this.mis.setAnimated(true);
            this.im = this.createImage(this.mis);
        }
        double ws = (1.0 - Math.exp(-Math.min((double)ff / (3.0 * (double)this.nframes), 1.0))) / 10000.0;
        double cf = -20000.0 * this.waveAmp;
        double cA = cf * this.waveAmp;
        double cB = -cf * dist;
        double wnCon = this.wn * piCon;
        double dfactor = (double)moonCentre / 0.9;
        double[] wcx = this.wc[0];
        double[] wcy = this.wc[1];
        a = this.frameA * (double)f;
        c = ws * Math.cos(a);
        double s = ws * Math.sin(a);
        boolean makeD = ff == 1;
        short[] dx0 = this.dx[0];
        short[] dx1 = this.dx[1];
        short[] dy0 = this.dy[0];
        short[] dy1 = this.dy[1];
        int i0 = 0;
        for (j = 0; j < h; ++j) {
            double y = (double)(j - yc) * scale;
            for (i = 0; i < w; ++i) {
                int iy;
                int ix;
                double x = (double)(i - xc) * scale;
                if (makeD) {
                    for (int l = 0; l < 2; ++l) {
                        short[] dxl = this.dx[l];
                        short[] dyl = this.dy[l];
                        double nx = 0.0;
                        double ny = 0.0;
                        for (int k = 0; k < this.nwaves; ++k) {
                            double xx = x - wcx[k];
                            double yy = y - wcy[k];
                            double r = Math.sqrt(xx * xx + yy * yy);
                            double cp = cosTab[(twoPi - piOn2 * l + (int)(wnCon * r)) % twoPi] / r;
                            nx += xx * cp;
                            ny += yy * cp;
                        }
                        double uu = cA * (x * nx + y * ny) + cB;
                        dxl[i0] = (short)(uu * nx);
                        dyl[i0] = (short)(uu * ny);
                    }
                }
                this.finalPix[i0] = (ix = moonCentre - (int)(dfactor * (x + c * (double)dx0[i0] + s * (double)dx1[i0]))) >= 0 && ix < moonWidth && (iy = moonCentre - (int)(dfactor * (y + c * (double)dy0[i0] + s * (double)dy1[i0]))) >= 0 && iy < moonWidth ? this.moonPix[iy * moonWidth + ix] : (byte)0;
                ++i0;
            }
        }
        this.mis.newPixels();
        g.drawImage(this.im, 0, 0, null);
        if (ff == highFrame) {
            this.moonPix = null;
            this.finalPix = null;
            this.dx = null;
            this.dy = null;
        }
        return ff < highFrame;
    }
}

