/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.graphics.GraphicsUtils;
import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;

public class QuantumWell
extends Applet
implements Runnable,
MouseListener {
    private static final long serialVersionUID = 1L;
    boolean mouseIN = false;
    Image bg;
    Image I;
    Graphics2D G2;
    Color[] palette;
    Line2D.Double line = new Line2D.Double();
    GeneralPath rhomb = new GeneralPath(0, 5);
    static final BasicStroke str = new BasicStroke(2.0f, 0, 2);
    private volatile Thread a;
    long F;
    boolean drawn = false;
    int potentialType = 0;
    int nmodes;
    int nsymm = -1;
    float probContours;
    float pixDist;
    float[] freq;
    double[] amp;
    int[] ii;
    int[] jj;
    double[][] H;
    float[] sine;
    float[][] xx;
    float t = 0.0f;
    float dt;
    long dtMs0;
    long dtMs = this.dtMs0 = 5L;
    float[][][] Phi;
    int[][] iLower;
    int[] iLeft;
    int[][][] iRight;
    int[][][] iC;
    float[] fLower;
    float[][] fLeft;
    float[][] fRight;
    float[][] fC;
    double[] TMP;
    float[][] SEGS;
    int[][] zC;
    String statusString = "";
    static final String[] PotentialNames = new String[]{"Square Well", "Harmonic Oscillator"};

    @Override
    public void showStatus(String s) {
        super.showStatus(s);
        this.statusString = s;
    }

    void maybeShowStatus(Graphics g) {
        if (this.statusString.length() != 0) {
            GraphicsUtils.showStatus((String)this.statusString, (Graphics)g, (Component)this);
        }
    }

    @Override
    public synchronized void mouseEntered(MouseEvent e) {
        this.mouseIN = true;
        this.showStatus(PotentialNames[this.potentialType] + "; click to redraw");
    }

    @Override
    public synchronized void mouseExited(MouseEvent e) {
        this.mouseIN = false;
        this.showStatus("");
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        this.F = 0L;
        this.t = 0.0f;
        this.mouseIN = true;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void start() {
        this.a = new Thread(this);
        this.a.start();
        this.a.setPriority(1);
    }

    @Override
    public void stop() {
        this.a = null;
    }

    @Override
    public void run() {
        this.addMouseListener(this);
        Thread thisThread = Thread.currentThread();
        while (this.a == thisThread) {
            if (this.drawn) {
                this.t += this.dt;
                this.drawn = false;
                this.repaint();
            }
            try {
                Thread.sleep(this.dtMs);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public synchronized void update(Graphics g) {
        int p;
        int l;
        int n;
        boolean init;
        int nx = 7;
        int ny = 7;
        int timeSteps = 48;
        int pix = 3;
        int nphase = 32;
        int hphase = 16;
        int ephase = 4;
        float fphase = 32.0f;
        float fphase10 = 320.0f;
        float fphase20 = 640.0f;
        int twoPI = 2000;
        int onePI = 1000;
        int PIon2 = 500;
        int cosOff = 2500;
        int NumberOfPotentials = 2;
        int w = this.getSize().width;
        int h = this.getSize().height;
        int xc = w / 2;
        int yc = h / 2;
        int wh = w * h;
        int i = 0;
        int j = 0;
        int gn = h;
        int gmax = (gn - 1) / 3 * 3;
        int bi = (gn - 1 - gmax) / 2;
        boolean bl = init = this.F++ == 0L;
        if (init) {
            int k;
            float x;
            this.palette = new Color[32];
            for (i = 0; i < 32; ++i) {
                this.palette[i] = new Color(Color.HSBtoRGB((float)i / 32.0f, 1.0f, 1.0f));
            }
            this.potentialType = this.potentialType < 0 ? (int)(Math.random() * 2.0) : (this.potentialType + 1) % 2;
            if (this.mouseIN) {
                this.mouseEntered(null);
            }
            boolean squareWell = this.potentialType == 0;
            boolean harmonic = this.potentialType == 1;
            this.nmodes = 49;
            this.bg = this.createImage(w, h);
            Graphics bb = this.bg.getGraphics();
            bb.setColor(new Color(0x333333));
            bb.fillRect(0, 0, w, h);
            Graphics2D bb2 = (Graphics2D)bb;
            GraphicsUtils.setAA((Graphics)bb2);
            bb2.setPaint(Color.black);
            if (squareWell) {
                this.rhomb.reset();
                this.rhomb.moveTo(w / 2, 0.0f);
                this.rhomb.lineTo(w / 2 - h, h / 2);
                this.rhomb.lineTo(w / 2, h);
                this.rhomb.lineTo(w / 2 + h, h / 2);
                this.rhomb.closePath();
                bb2.fill(this.rhomb);
            } else {
                bb2.fill(new Ellipse2D.Double(w / 2 - h, 0.0, 2 * h, h));
            }
            this.I = this.createImage(w, h);
            this.G2 = (Graphics2D)this.I.getGraphics();
            GraphicsUtils.setAA((Graphics)this.G2);
            this.G2.setStroke(str);
            this.sine = new float[2000];
            for (i = 0; i < 1000; ++i) {
                this.sine[i] = (float)Math.sin((double)i * 0.0031415926535897933);
                this.sine[1000 + i] = -this.sine[i];
            }
            float piong = 1000.0f / (float)gmax;
            this.xx = new float[gn][7];
            this.freq = new float[this.nmodes];
            this.amp = new double[this.nmodes];
            this.ii = new int[this.nmodes];
            this.jj = new int[this.nmodes];
            float gsq = (gn - 1) * (gn - 1);
            if (squareWell) {
                this.probContours = 2.0f * (float)gmax * (float)gmax;
                this.pixDist = 1.0f;
                float norm = (float)Math.sqrt(2.0 / (double)gmax);
                for (i = 0; i < gn; ++i) {
                    x = piong * (float)i;
                    for (n = 1; n <= 7; ++n) {
                        this.xx[i][n - 1] = norm * this.sine[(int)((float)n * x) % 2000];
                    }
                }
                double ax = Math.random();
                double bx = Math.random();
                double ay = Math.random();
                double by = Math.random();
                for (n = 0; n < this.nmodes; ++n) {
                    i = n % 7 + 1;
                    j = n / 7 + 1;
                    this.ii[n] = i;
                    this.jj[n] = j;
                    this.freq[n] = 0.5f * ((float)(i * i) / gsq + (float)(j * j) / gsq) / (2.0f / gsq);
                    this.amp[n] = (Math.cos(ax * (double)i * Math.PI) - Math.cos(bx * (double)i * Math.PI)) / (double)i * (Math.cos(ay * (double)j * Math.PI) - Math.cos(by * (double)j * Math.PI)) / (double)j;
                }
            } else if (harmonic) {
                double translateBy = 2.8;
                this.nsymm = this.nsymm < 0 ? 1 + (int)(6.0 * Math.random()) : 1 + this.nsymm % 6;
                float n0 = (float)Math.sqrt(Math.sqrt(0.3183098861837907));
                float scaleFactor = 8.0f;
                for (i = 0; i < 5; ++i) {
                    this.probContours = 1.5f * scaleFactor * scaleFactor;
                    scaleFactor = (float)(translateBy + Math.sqrt(Math.log(n0 * n0 * n0 * n0 * this.probContours / (float)this.nsymm))) / 0.5f;
                }
                this.pixDist = scaleFactor / (float)gmax;
                for (i = 0; i < gn; ++i) {
                    x = scaleFactor * ((float)i / (float)gmax - 0.5f);
                    float ef = n0 * (float)Math.exp(-0.5 * (double)x * (double)x);
                    float[] xxi = this.xx[i];
                    xxi[0] = ef;
                    xxi[1] = 1.414f * ef * x;
                    for (n = 2; n < 7; ++n) {
                        xxi[n] = (float)(Math.sqrt(2.0 / (double)n) * ((double)(x * xxi[n - 1]) - Math.sqrt((double)(n - 1) / 2.0) * (double)xxi[n - 2]));
                    }
                }
                for (n = 0; n < this.nmodes; ++n) {
                    i = n % 7 + 1;
                    j = n / 7 + 1;
                    this.ii[n] = i;
                    this.jj[n] = j;
                    this.freq[n] = 4 * (i + j - 1);
                }
                for (int nangle = 0; nangle < this.nsymm; ++nangle) {
                    double theta = (double)nangle * (Math.PI * 2) / (double)this.nsymm;
                    for (k = 0; k < 7; ++k) {
                        double aa = 1.0;
                        for (l = 1; l <= k; ++l) {
                            aa *= translateBy / Math.sqrt(2.0 * (double)l);
                        }
                        double NplusPdownN = 1.0;
                        double ctheta = Math.cos(theta);
                        double stheta = Math.sin(theta);
                        for (p = 0; p <= k; ++p) {
                            n = k - p;
                            int n2 = p * 7 + n;
                            this.amp[n2] = this.amp[n2] + aa * Math.sqrt(NplusPdownN) * Math.pow(ctheta, n) * Math.pow(stheta, p);
                            NplusPdownN = NplusPdownN * (double)n / (double)(p + 1);
                        }
                    }
                }
            }
            this.dt = 0.1f;
            for (n = 0; n < this.nmodes; ++n) {
                this.dt = Math.min(this.dt, 1.0f / this.freq[n] / 48.0f);
            }
            this.dtMs = Math.max(this.dtMs0, (long)(1000.0 * (double)this.dt));
            this.H = new double[this.nmodes][this.nmodes];
            for (i = 0; i < this.nmodes; ++i) {
                this.H[i][i] = 1.0;
            }
            double pfactor = 1.0E-4;
            for (i = 0; i < this.nmodes; ++i) {
                for (j = 0; j < this.nmodes; ++j) {
                    this.H[i][j] = i == j ? 1.0 : (this.freq[j] == this.freq[i] ? (j > i ? pfactor * Math.random() : -this.H[j][i]) : 0.0);
                }
            }
            double[] tmp = new double[this.nmodes];
            for (i = 0; i < this.nmodes; ++i) {
                for (k = 0; k < this.nmodes; ++k) {
                    tmp[k] = 0.0;
                }
                for (j = 0; j < i; ++j) {
                    double dp = 0.0;
                    for (k = 0; k < this.nmodes; ++k) {
                        dp += this.H[i][k] * this.H[j][k];
                    }
                    for (k = 0; k < this.nmodes; ++k) {
                        int n3 = k;
                        tmp[n3] = tmp[n3] + dp * this.H[j][k];
                    }
                }
                for (k = 0; k < this.nmodes; ++k) {
                    double[] dArray = this.H[i];
                    int n4 = k;
                    dArray[n4] = dArray[n4] - tmp[k];
                }
                double dp = 0.0;
                for (k = 0; k < this.nmodes; ++k) {
                    dp += this.H[i][k] * this.H[i][k];
                }
                dp = Math.sqrt(dp);
                k = 0;
                while (k < this.nmodes) {
                    double[] dArray = this.H[i];
                    int n5 = k++;
                    dArray[n5] = dArray[n5] / dp;
                }
            }
            this.drawn = false;
        }
        if (!this.drawn) {
            int s;
            int z;
            int m;
            this.G2.drawImage(this.bg, 0, 0, null);
            int hcell = 2 + gn / 3;
            int r3 = 18;
            int r4 = 4 * r3;
            int zmax = 100;
            int zinc = h / zmax;
            if (init) {
                this.Phi = new float[2][9][8];
                this.fLeft = new float[2][hcell];
                this.iLeft = new int[hcell];
                this.fLower = new float[r3];
                this.iLower = new int[2][r3];
                this.iRight = new int[2][hcell][r3];
                this.fRight = new float[hcell][r3];
                this.iC = new int[2][zmax][r4];
                this.fC = new float[zmax][r4];
                this.TMP = new double[this.nmodes];
                this.SEGS = new float[zmax][];
                this.zC = new int[3][zmax];
                int[] msd = this.zC[2];
                for (i = 0; i < zmax; ++i) {
                    double area = this.probContours / (float)(i + 1);
                    double cellSide = 3.0f * this.pixDist;
                    msd[i] = m = 5 * (1 + (int)(1.5 * area / (cellSide * cellSide)));
                    this.SEGS[i] = new float[m];
                }
            }
            int phaseA = 0;
            int phaseB = 0;
            float[][] phiR = this.Phi[0];
            float[][] phiI = this.Phi[1];
            float[] phiRx = this.Phi[0][8];
            float[] phiIx = this.Phi[1][8];
            float magAbove = 0.0f;
            float[] magLeft = this.fLeft[0];
            float phaseAbove = 0.0f;
            float[] phaseLeft = this.fLeft[1];
            int magIAbove = 0;
            int[] magILeft = this.iLeft;
            int[] xMagLower = this.iLower[0];
            int[][] yMagRight = this.iRight[0];
            int[] zMagLower = this.iLower[1];
            int[][] zMagRight = this.iRight[1];
            float[] pMagLower = this.fLower;
            float[][] pMagRight = this.fRight;
            int[][] xm = this.iC[0];
            int[][] ym = this.iC[1];
            float[][] pm = this.fC;
            float pp = 0.0f;
            float p1 = 0.0f;
            int[] sc = this.zC[0];
            int[] mc = this.zC[1];
            int[] msd = this.zC[2];
            float[][] segs = this.SEGS;
            for (i = 0; i < zmax; ++i) {
                mc[i] = 0;
                sc[i] = 0;
            }
            double[] tmp = this.TMP;
            double ssq = 0.0;
            for (i = 0; i < this.nmodes; ++i) {
                tmp[i] = this.amp[i];
                ssq += this.amp[i] * tmp[i];
                this.amp[i] = 0.0;
            }
            ssq = Math.sqrt(ssq);
            for (i = 0; i < this.nmodes; ++i) {
                for (j = 0; j < this.nmodes; ++j) {
                    int n6 = i;
                    this.amp[n6] = this.amp[n6] + this.H[i][j] * tmp[j] / ssq;
                }
            }
            int lx = 7;
            int ly = 7;
            int mx = 0;
            int my = 0;
            for (n = 0; n < this.nmodes; ++n) {
                int f = (int)(this.freq[n] * 2000.0f * this.t) % 2000;
                float aa = (float)this.amp[n];
                i = this.ii[n];
                j = this.jj[n];
                if (i < lx) {
                    lx = i;
                }
                if (i > mx) {
                    mx = i;
                }
                if (j < ly) {
                    ly = j;
                }
                if (j > my) {
                    my = j;
                }
                phiR[i][j] = aa * this.sine[(2500 - f) % 2000];
                phiI[i][j] = -aa * this.sine[f];
            }
            int pi = 0;
            int pj = 0;
            for (i = bi; i < gn; i += 3) {
                float[] xa = this.xx[i - bi];
                for (p = ly; p <= my; ++p) {
                    phiRx[p] = 0.0f;
                    phiIx[p] = 0.0f;
                }
                for (n = lx; n <= mx; ++n) {
                    float snx = xa[n - 1];
                    float[] phiRn = phiR[n];
                    float[] phiIn = phiI[n];
                    for (p = ly; p <= my; ++p) {
                        int n7 = p;
                        phiRx[n7] = phiRx[n7] + phiRn[p] * snx;
                        int n8 = p;
                        phiIx[n8] = phiIx[n8] + phiIn[p] * snx;
                    }
                }
                j = bi;
                int jcell = 0;
                while (j < gn) {
                    float lambda;
                    float rdm;
                    int l2;
                    int l1;
                    boolean closeReal;
                    float[] ya = this.xx[j - bi];
                    float psiI = 0.0f;
                    float psiR = 0.0f;
                    for (p = ly; p <= my; ++p) {
                        float spy = ya[p - 1];
                        psiR += spy * phiRx[p];
                        psiI += spy * phiIx[p];
                    }
                    float psiR2 = psiR * psiR;
                    float psiI2 = psiI * psiI;
                    float mag = this.probContours * (psiR2 + psiI2);
                    int magI = (int)mag;
                    boolean bl2 = closeReal = psiR2 > psiI2;
                    float phase = 320.0f + 4.0f * ((closeReal ? psiI / psiR : (psiI == 0.0f ? -1.0f : -psiR / psiI)) + (float)((psiI < 0.0f ? -1 : 1) * (closeReal ? (psiR < 0.0f ? 4 : 0) : 2)));
                    float mphase = 640.0f - phase;
                    int lc = 0;
                    int rc = 0;
                    int zlo = zmax;
                    int zhi = -1;
                    int[] ymr = yMagRight[jcell];
                    int[] zmr = zMagRight[jcell];
                    float[] pmr = pMagRight[jcell];
                    if (j > bi) {
                        float f;
                        if (i > bi) {
                            l = 0;
                            l1 = zMagLower[0];
                            l2 = zMagLower[1];
                            for (z = l1; z <= l2; ++z) {
                                int n9 = z;
                                mc[n9] = mc[n9] + 1;
                                xm[z][m] = xMagLower[l];
                                ym[z][m] = pj;
                                pm[z][m] = pMagLower[l++];
                            }
                            zlo = l1;
                            zhi = l2;
                            l = 0;
                            l1 = zmr[0];
                            l2 = zmr[1];
                            for (z = l1; z <= l2; ++z) {
                                int n10 = z;
                                mc[n10] = mc[n10] + 1;
                                xm[z][m] = pi;
                                ym[z][m] = ymr[l];
                                pm[z][m] = pmr[l++];
                            }
                            zlo = Math.min(zlo, l1);
                            zhi = Math.max(zhi, l2);
                        }
                        if ((l1 = magI) > (l2 = magIAbove)) {
                            l2 = magI;
                            l1 = magIAbove;
                        }
                        if (l2 >= zmax) {
                            l2 = zmax - 1;
                        }
                        if (l2 - l1 > r3) {
                            l2 = l1 + r3;
                        }
                        pp = (phaseAbove + mphase) % 32.0f;
                        if (f > 16.0f) {
                            pp -= 32.0f;
                        }
                        rdm = 1.0f / (mag - magAbove);
                        for (z = l1 + 1; z <= l2; ++z) {
                            lambda = rdm * (mag - (float)z);
                            int n11 = z;
                            mc[n11] = mc[n11] + 1;
                            xm[z][m] = i;
                            ym[z][m] = ymr[rc] = j - (int)(3.0f * lambda + 0.5f);
                            int n12 = rc++;
                            float f2 = phase + lambda * pp;
                            pmr[n12] = f2;
                            pm[z][m] = f2;
                        }
                        zlo = Math.min(zlo, l1 + 1);
                        zhi = Math.max(zhi, l2);
                        zmr[0] = l1 + 1;
                        zmr[1] = l2;
                    }
                    if (i > bi) {
                        float f;
                        l1 = magI;
                        l2 = magILeft[jcell];
                        if (l1 > l2) {
                            int itmp = l2;
                            l2 = magI;
                            l1 = itmp;
                        }
                        if (l2 >= zmax) {
                            l2 = zmax - 1;
                        }
                        if (l2 - l1 > r3) {
                            l2 = l1 + r3;
                        }
                        pp = (phaseLeft[jcell] + mphase) % 32.0f;
                        if (f > 16.0f) {
                            pp -= 32.0f;
                        }
                        rdm = 1.0f / (mag - magLeft[jcell]);
                        for (z = l1 + 1; z <= l2; ++z) {
                            lambda = rdm * (mag - (float)z);
                            int n13 = z;
                            mc[n13] = mc[n13] + 1;
                            xm[z][m] = xMagLower[lc] = i - (int)(3.0f * lambda + 0.5f);
                            ym[z][m] = j;
                            int n14 = lc++;
                            float f3 = phase + lambda * pp;
                            pMagLower[n14] = f3;
                            pm[z][m] = f3;
                        }
                        zlo = Math.min(zlo, l1 + 1);
                        zhi = Math.max(zhi, l2);
                        zMagLower[0] = l1 + 1;
                        zMagLower[1] = l2;
                        if (j > bi) {
                            for (z = zlo; z <= zhi; ++z) {
                                s = sc[z];
                                float[] sg = segs[z];
                                int maxSegD = msd[z];
                                m = mc[z];
                                for (int c1 = 0; c1 < m - 1; c1 += 2) {
                                    int C1 = c1;
                                    p1 = pm[z][C1];
                                    phaseA = (int)p1 % 32;
                                    int c2 = c1 + 1;
                                    int C2 = c2;
                                    float p2 = pm[z][C2];
                                    phaseB = (int)p2 % 32;
                                    if (phaseA != phaseB) {
                                        float f4;
                                        pp = (320.0f + p2 - p1) % 32.0f;
                                        if (f4 > 16.0f) {
                                            pp = 32.0f - pp;
                                            C1 = c2;
                                            C2 = c1;
                                            p1 = p2;
                                            int itmp = phaseA;
                                            phaseA = phaseB;
                                            phaseB = itmp;
                                        }
                                    }
                                    float x1 = xm[z][C1];
                                    float y1 = ym[z][C1];
                                    float x2 = xm[z][C2];
                                    float y2 = ym[z][C2];
                                    if (phaseA != phaseB && pp != 0.0f) {
                                        float dx = x2 - x1;
                                        float dy = y2 - y1;
                                        float mp1 = 640.0f - p1;
                                        float xp = x1;
                                        float yp = y1;
                                        l = phaseA;
                                        while (true) {
                                            l = (l + 1) % 32;
                                            lambda = ((float)l + mp1) % 32.0f / pp;
                                            float xt = x1 + lambda * dx;
                                            float yt = y1 + lambda * dy;
                                            if (s < maxSegD) {
                                                sg[s++] = phaseA;
                                                sg[s++] = xp;
                                                sg[s++] = yp;
                                                sg[s++] = xt;
                                                sg[s++] = yt;
                                            }
                                            xp = xt;
                                            yp = yt;
                                            if (l == phaseB) break;
                                            phaseA = l;
                                        }
                                        x1 = xp;
                                        y1 = yp;
                                    }
                                    if (s >= maxSegD) continue;
                                    sg[s++] = phaseB;
                                    sg[s++] = x1;
                                    sg[s++] = y1;
                                    sg[s++] = x2;
                                    sg[s++] = y2;
                                }
                                mc[z] = 0;
                                sc[z] = s;
                            }
                        }
                    }
                    magLeft[jcell] = magAbove = mag;
                    magILeft[jcell] = magIAbove = magI;
                    phaseLeft[jcell] = phaseAbove = phase;
                    pj = j;
                    j += 3;
                    ++jcell;
                }
                pi = i;
            }
            for (z = 0; z < zmax; ++z) {
                int yz = yc - zinc * z + gn / 2;
                float[] sg = segs[z];
                s = 0;
                while (s < sc[z]) {
                    int ci = (int)sg[s++];
                    float x1 = sg[s++];
                    float y1 = sg[s++];
                    float x2 = sg[s++];
                    float y2 = sg[s++];
                    double xa = (float)xc + (x1 - y1);
                    double ya = (float)yz - (x1 + y1) / 2.0f;
                    double xb = (float)xc + (x2 - y2);
                    double yb = (float)yz - (x2 + y2) / 2.0f;
                    this.line.setLine(xa, ya, xb, yb);
                    this.G2.setPaint(this.palette[ci]);
                    this.G2.draw(this.line);
                }
            }
            g.drawImage(this.I, 0, 0, null);
            this.maybeShowStatus(g);
            this.drawn = true;
        }
    }
}

