/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.applets.A2;
import egan.util.Utils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;

public class SO3
extends A2 {
    private static final long serialVersionUID = 1L;
    double[] spinAxis;
    static final BasicStroke str = new BasicStroke(0.5f, 0, 2);
    static final RenderingHints aaON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    GeneralPath rhomb = new GeneralPath(0, 5);

    public boolean d(Graphics g, int w, int h, int p, int q, int f, boolean C, boolean TB, int L, int V) {
        if (C) {
            int k;
            int j;
            int i;
            int nCubesAcross = 8;
            double cubeSpace = 0.25;
            double[][] b = new double[16][3];
            double[] c = new double[3];
            double wc = w / 2;
            double hc = h / 2;
            double scale = 0.98 * Math.min(wc, hc);
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(str);
            g2.addRenderingHints(aaON);
            Color[] P = new Color[6];
            for (i = 0; i < 6; ++i) {
                int col = 255 << 8 * (i % 3);
                P[i] = new Color(i < 3 ? col : 0xFFFFFF & ~col);
            }
            if (!TB) {
                g.setColor(Color.white);
                g.fillRect(0, 0, w, h);
            }
            if (f == 0) {
                this.spinAxis = Utils.randomUnitVec(null, (boolean)false);
            }
            double a = (double)f * this.frameA;
            double s1 = Math.sin(a);
            double c1 = Math.cos(a);
            double[] sp = this.spinAxis;
            for (i = 8; i < 16; ++i) {
                for (j = 0; j < 3; ++j) {
                    b[i][j] = 0.0;
                    for (k = 0; k < 3; ++k) {
                        double[] dArray = b[i];
                        int n = j;
                        dArray[n] = dArray[n] + (double)(1 - 2 * (i >> k & 1)) * 0.07217090069284064 * ((1.0 - c1) * sp[j] * sp[k] + (j == k ? c1 : (double)(1 - (j + 4 - k) % 3) * s1 * sp[3 - j - k]));
                    }
                }
            }
            double e = 1.0E-5;
            double oneP = 1.0 + e;
            double twoP = 2.0 + e;
            double threeP = 3.0 + e;
            for (double dObs = -2.75; dObs <= threeP; dObs += 0.25) {
                c[0] = -1.0;
                while (c[0] <= oneP && c[0] <= dObs + twoP) {
                    if (c[0] >= dObs - twoP) {
                        c[1] = -1.0;
                        while (c[1] <= oneP) {
                            double d;
                            c[2] = dObs - c[0] - c[1];
                            if (!(d >= -oneP)) break;
                            if (c[2] <= oneP) {
                                double d2;
                                double r = Math.sqrt(c[0] * c[0] + c[1] * c[1] + c[2] * c[2]);
                                if (d2 <= oneP && (c[0] <= e || c[1] <= e)) {
                                    a = Math.cos(Math.PI * (r += e));
                                    double s = Math.sqrt(1.0 - a * a);
                                    for (i = 0; i < 8; ++i) {
                                        for (j = 0; j < 3; ++j) {
                                            b[i][j] = c[j];
                                            for (k = 0; k < 3; ++k) {
                                                double[] dArray = b[i];
                                                int n = j;
                                                dArray[n] = dArray[n] + b[8 + i][k] * ((1.0 - a) * c[j] * c[k] / (r * r) + (j == k ? a : (double)(1 - (j + 4 - k) % 3) * s * c[3 - j - k] / r));
                                            }
                                        }
                                    }
                                    double baseDP = b[0][0] + b[0][1] + b[0][2];
                                    for (i = 0; i < 3; ++i) {
                                        int n;
                                        j = 1 << i;
                                        if (b[n][0] + b[j][1] + b[j][2] < baseDP) {
                                            j = 0;
                                        }
                                        this.rhomb.reset();
                                        for (k = 0; k < 4; ++k) {
                                            double[] v = b[j | (k >> 1 & 1) << (i + 1) % 3 | ((k ^ k >> 1) & 1) << (i + 2) % 3];
                                            double x = wc + scale * (0.707 * (v[1] - v[0]));
                                            double y = hc + scale * (0.05 + 0.408 * (v[0] + v[1] - 2.0 * v[2]));
                                            if (k == 0) {
                                                this.rhomb.moveTo((float)x, (float)y);
                                                continue;
                                            }
                                            this.rhomb.lineTo((float)x, (float)y);
                                        }
                                        this.rhomb.closePath();
                                        g2.setPaint(P[i + 3 * (j >> i)]);
                                        g2.fill(this.rhomb);
                                        g2.setPaint(Color.black);
                                        g2.draw(this.rhomb);
                                    }
                                }
                            }
                            c[1] = c[1] + 0.25;
                        }
                    }
                    c[0] = c[0] + 0.25;
                }
            }
        }
        return C;
    }
}

