/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.applets.A2;
import egan.graphics.GraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;

public class Tesla
extends A2 {
    private static final long serialVersionUID = 1L;
    int nspheres = -1;
    byte[] tilePix;
    byte[] slice;
    int[] pix;
    double[] rayDest;
    final int nOS = 3;
    final int nOS2 = 9;

    public boolean d(Graphics g, int w, int h, int p, int q, int f, boolean C, boolean TB, int L, int V) {
        if (C) {
            int s;
            int k;
            int j;
            int i;
            GraphicsUtils.setAA((Graphics)g);
            int maxspheres = 4;
            double nSphere = 3.0;
            int sc = w / 200;
            int tW = 12 * this.nframes * sc;
            int tH = 9 * this.nframes * sc;
            int wOS = 3 * w;
            int hOS = 3 * h;
            int ci = 0;
            int nSlice = 3 * wOS;
            if (f == 0) {
                this.nspheres = this.nspheres == -1 ? 1 + (int)(Math.random() * (double)maxspheres) : 1 + this.nspheres % maxspheres;
                this.pix = new int[w * h];
                this.slice = new byte[nSlice];
                this.tilePix = new byte[tW * tH];
                int[] a1 = new int[3];
                int xstep = tW / 24;
                int ystep = 2 * xstep;
                int zmod = 9 * ystep * 1000;
                for (int ix = 0; ix < tW; ++ix) {
                    int ii;
                    a1[0] = ii = zmod + ix / xstep;
                    for (int iy = 0; iy < tH; ++iy) {
                        int yy = 2 * iy;
                        int jj = zmod + (zmod + yy - ix) / ystep;
                        int ll = zmod + (zmod - yy - ix - 1) / ystep;
                        a1[1] = jj;
                        a1[2] = ll;
                        for (i = 0; i < 3; ++i) {
                            j = (i + 1) % 3;
                            if ((zmod + a1[i] / 6 - a1[j] / 6) % 3 != 1) continue;
                            if ((zmod + a1[i] / 2 - a1[j] / 2) % 3 == 0 && a1[i] / 2 % 3 == 1) {
                                k = (i + 2) % 3;
                                if ((zmod + a1[i] - a1[j]) % 3 == 1 + a1[i % 2] / 6 % 2) {
                                    ci = 0;
                                    break;
                                }
                                if ((zmod + a1[j] / 2 - a1[k] / 2) % 3 == 1) {
                                    ci = 2 * k + 1;
                                    break;
                                }
                                ci = 2 * j + 1;
                                break;
                            }
                            ci = 2 * i + 1;
                            break;
                        }
                        this.tilePix[iy * tW + ix] = (byte)ci;
                    }
                }
            }
            int sdist = Math.min(wOS, hOS);
            int outerRad = (int)(0.45 * (double)sdist);
            int[] xc = new int[this.nspheres];
            int[] yc = new int[this.nspheres];
            double da = Math.PI * 2 / (double)this.nspheres;
            double sda2 = Math.sin(da / 2.0);
            double cRad = this.nspheres > 1 ? (double)outerRad / sda2 : 0.0;
            for (i = 0; i < this.nspheres; ++i) {
                double aa = ((double)i + (double)f / (double)this.nframes) * da;
                xc[i] = wOS / 2 + (int)(Math.cos(aa) * cRad);
                yc[i] = hOS / 2 + (int)(Math.sin(aa) * cRad);
            }
            int innerRad = outerRad - 10;
            int outerRadSq = outerRad * outerRad;
            int radCalcs = 10 * outerRad + 1;
            int rad = innerRad / 4;
            int spotPos = -((int)(0.707 * (double)rad));
            int spotRad = (int)(0.25 * (double)rad);
            int shrunkRad = (int)((double)spotRad * 0.707);
            if (this.rayDest == null) {
                this.rayDest = new double[radCalcs];
            }
            int ff = tH / this.nframes * f;
            int ip = 0;
            int px = 0;
            k = 0;
            for (j = 0; j < hOS; ++j) {
                for (i = 0; i < wOS; ++i) {
                    for (s = 0; s < this.nspheres; ++s) {
                        int j0;
                        int i0;
                        boolean needCalc;
                        double d;
                        double d2;
                        int xcs = xc[s];
                        int ycs = yc[s];
                        int x = i - xcs;
                        int y = j - ycs;
                        double rsq = x * x + y * y;
                        if (!(d2 < (double)outerRadSq)) continue;
                        double r = Math.sqrt(rsq);
                        if (!(d >= (double)(rad - 1))) continue;
                        int rint = (int)(10.0 * r);
                        double lambda = this.rayDest[rint];
                        boolean bl = needCalc = lambda == 0.0;
                        while (needCalc) {
                            double d3;
                            double d4;
                            double z = Math.sqrt((double)outerRadSq - rsq);
                            double c1 = z / (double)outerRad;
                            double s1 = r / (double)outerRad;
                            double sint = s1 / nSphere;
                            double cost2 = 1.0 - sint * sint;
                            if (d4 < 0.0) break;
                            double cost = Math.sqrt(cost2);
                            double s2 = s1 * cost - c1 * sint;
                            double c2 = c1 * cost + s1 * sint;
                            lambda = 2.0 * (r * s2 + z * c2);
                            double c3 = -(z -= c2 * lambda) / (double)outerRad;
                            double s3 = (r -= s2 * lambda) / (double)outerRad;
                            s1 = s2 * c3 + c2 * s3;
                            c1 = c2 * c3 - s2 * s3;
                            sint = s1 * nSphere;
                            cost2 = 1.0 - sint * sint;
                            if (d3 < 0.0) break;
                            cost = Math.sqrt(cost2);
                            s1 = s3 * cost - c3 * sint;
                            c1 = c3 * cost + s3 * sint;
                            this.rayDest[rint] = lambda = 1.0 + s1 / c1 * ((z + (double)outerRad) / r);
                            needCalc = false;
                        }
                        if (needCalc || (i0 = (xcs + (int)(0.5 + lambda * (double)x) + 1000 * tW) % tW) < 0 || (j0 = (ycs + (int)(0.5 + lambda * (double)y) + 1000 * tH + ff) % tH) < 0) break;
                        this.slice[ip] = this.tilePix[j0 * tW + i0];
                        break;
                    }
                    if (s == this.nspheres) {
                        this.slice[ip] = this.tilePix[tW * ((j + ff) % tH) + i % tW];
                    }
                    if (++ip != nSlice) continue;
                    ip = 0;
                    for (int rp = 0; rp < w; ++rp) {
                        int grey = 0;
                        for (int ii = 0; ii < 3; ++ii) {
                            for (int jj = 0; jj < 3; ++jj) {
                                grey += 51 * this.slice[rp * 3 + ii + jj * wOS];
                            }
                        }
                        this.pix[px++] = 0xFF000000 | (grey /= 9) << 16 | grey << 8 | grey;
                    }
                }
            }
            GraphicsUtils.drawPixDCM((Component)((Object)this), (Graphics)g, (int[])this.pix, (int)w, (int)h, (int)w, (int)0, (int)0);
            for (s = 0; s < this.nspheres; ++s) {
                g.setColor(Color.black);
                g.fillOval((xc[s] - rad) / 3, (yc[s] - rad) / 3, 2 * rad / 3, 2 * rad / 3);
                g.setColor(Color.white);
                g.fillOval((xc[s] + spotPos - shrunkRad) / 3, (yc[s] - spotRad) / 3, 2 * shrunkRad / 3, 2 * spotRad / 3);
            }
            g.setColor(new Color(153, 102, 255));
            for (s = 0; s < this.nspheres; ++s) {
                for (i = 0; i < 8; ++i) {
                    this.stroke(g, Math.random() * Math.PI, (Math.random() - 0.5) * Math.PI, rad / 3, innerRad / 3, xc[s] / 3, yc[s] / 3);
                }
            }
        }
        return C;
    }

    public void stroke(Graphics g, double t, double p, double r1, double r2, int xc, int yc) {
        int x1 = (int)((double)xc - r1 * Math.cos(t) * Math.cos(p));
        int y1 = (int)((double)yc - r1 * Math.sin(p));
        for (int i = 0; i < 2; ++i) {
            double theta = t + 0.25 * (Math.random() - 0.5);
            double phi = p + 0.25 * (Math.random() - 0.5);
            double r4 = r1 + 0.175 * r2 * (1.0 + Math.random());
            double r3 = Math.min(r4, r2);
            g.drawLine(x1, y1, (int)((double)xc - r3 * Math.cos(theta) * Math.cos(phi)), (int)((double)yc - r3 * Math.sin(phi)));
            if (r3 != r4) continue;
            this.stroke(g, theta, phi, r3, r2, xc, yc);
        }
    }
}

