/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.graphics.FractalMoon;
import egan.graphics.GraphicsUtils;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.util.Random;

public class Clouds
extends Applet
implements Runnable,
MouseListener {
    private static final long serialVersionUID = 1L;
    final int nOS = 3;
    final int nOS2 = 9;
    boolean mouseIN = true;
    long F = 0L;
    long pt = 0L;
    long tStep = 150L;
    private volatile Thread a;
    float[][] f;
    float[][] dA;
    float[][] dC;
    float mind;
    float maxd;
    byte[] finalPix;
    MemoryImageSource mis;
    Image im;
    byte[] moonPix;
    byte[] moonPixAv;
    String statusString = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.addMouseListener(this);
        Thread thisThread = Thread.currentThread();
        while (this.a == thisThread) {
            long t = System.currentTimeMillis();
            Clouds clouds = this;
            synchronized (clouds) {
                if (t - this.pt > this.tStep || t < this.pt) {
                    this.repaint();
                }
            }
            try {
                Thread.sleep(20L);
            }
            catch (Exception e) {
                break;
            }
        }
    }

    @Override
    public void start() {
        this.a = new Thread(this);
        this.a.start();
        this.a.setPriority(1);
    }

    @Override
    public void stop() {
        this.a = null;
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public synchronized void update(Graphics g) {
        long t = System.currentTimeMillis();
        if (t - this.pt >= this.tStep || t < this.pt) {
            this.pt = t;
            int w = this.getSize().width;
            int h = this.getSize().height;
            Random r = new Random();
            int NSHIFT = 2;
            int N2 = 15;
            int NPLANES = h / NSHIFT * N2;
            int NGREYS = 128;
            int moonWidth = 6 * (Math.min(w, h) / 8);
            int moonX = (w - moonWidth) / 2;
            int moonY = (h - moonWidth) / 2;
            if (this.F == 0L) {
                this.f = new float[NPLANES][4];
                this.dA = new float[h][w];
                this.dC = new float[h][w];
                int NFAULTS = 2000;
                int NCRATERS = (int)(300.0 * (1.0 + r.nextDouble()));
                int wOS = moonWidth * 3;
                this.moonPix = new FractalMoon(wOS, NFAULTS, NCRATERS, r).render(NFAULTS, NGREYS);
                this.moonPixAv = new byte[moonWidth * moonWidth];
                for (int i = 0; i < moonWidth; ++i) {
                    for (int j = 0; j < moonWidth; ++j) {
                        int ci = 0;
                        for (int ii = 0; ii < 3; ++ii) {
                            for (int jj = 0; jj < 3; ++jj) {
                                ci += this.moonPix[i * 3 + ii + (j * 3 + jj) * wOS];
                            }
                        }
                        this.moonPixAv[i + j * moonWidth] = (byte)(ci / 9);
                    }
                }
                this.finalPix = new byte[w * h];
                this.mis = new MemoryImageSource(w, h, (ColorModel)FractalMoon.greyScale((int)NGREYS), this.finalPix, 0, w);
                this.mis.setAnimated(true);
                this.im = this.createImage(this.mis);
            }
            this.d(g, w, h, r, this.F, this.finalPix, NPLANES, N2, NSHIFT, NGREYS, this.moonPixAv, moonWidth, moonWidth, moonX, moonY);
            this.maybeShowStatus(g);
            ++this.F;
        }
    }

    public void d(Graphics g, int w, int h, Random r, long frame, byte[] finalPix, int NPLANES, int N2, int NSHIFT, int NGREYS, byte[] bgPix, int bgWidth, int bgHeight, int bgX, int bgY) {
        int delta;
        int k2;
        int k1;
        boolean i0 = false;
        int xc = w / 2;
        int yc = h / 2;
        float scale = 2.0f / (float)(h - 5);
        float d1 = 3.0f * ((float)Math.sqrt(NPLANES) / 2.0f);
        float d0 = -d1;
        float dspan = d1 - d0;
        int bgX1 = bgX + bgWidth;
        int bgY1 = bgY + bgHeight;
        boolean init = frame == 0L;
        float cb0 = 0.1f;
        float cb1 = 0.7f;
        float pcb0 = cb0 * (float)NGREYS;
        float thresh = cb1 * (float)NGREYS;
        float pcbD = thresh - pcb0 - 1.0E-5f;
        float pcbB = -pcbD / 0.39999998f;
        float pcbA = pcb0 - pcbB;
        float rowStart = pcbA + 0.5f * pcbB;
        if (init) {
            k1 = 0;
            k2 = NPLANES;
        } else {
            k1 = (int)(frame * (long)N2 % (long)NPLANES);
            k2 = k1 + N2;
        }
        long shift = (long)NSHIFT * frame;
        long mishift = shift * (long)(h - 1);
        int n = delta = init ? 1 : -1;
        while (delta <= 1) {
            float b;
            float a;
            int i;
            float[] fk;
            int k;
            boolean adding = delta == 1;
            boolean removing = !adding;
            float dfactor = (float)delta * (pcbB / dspan);
            if (adding) {
                for (k = k1; k < k2; ++k) {
                    float ascale;
                    fk = this.f[k];
                    for (i = 0; i < 4; ++i) {
                        fk[i] = 3.0f * (r.nextFloat() - 0.5f);
                    }
                    a = fk[0];
                    b = fk[1];
                    fk[0] = ascale = scale * a;
                    fk[1] = scale * b;
                    fk[2] = -(a * (fk[2] + scale * (float)xc) + b * (fk[3] + scale * (float)((long)yc - shift)));
                    fk[3] = Math.abs(1.0f / ascale);
                }
            }
            int wj = 0;
            for (int j = 0; j < h; ++j) {
                boolean refresh;
                boolean bl = refresh = j < NSHIFT;
                if (refresh && removing) continue;
                int j1 = (int)(((long)j + mishift) % (long)h);
                long js = (long)j - shift;
                float[] dAj = this.dA[j1];
                float[] dCj = this.dC[j1];
                int K1 = k1;
                int K2 = k2;
                if (init || refresh) {
                    for (i = 0; i < w; ++i) {
                        dCj[i] = 0.0f;
                        dAj[i] = 0.0f;
                    }
                    dCj[0] = rowStart;
                    K1 = 0;
                    K2 = NPLANES;
                }
                for (k = K1; k < K2; ++k) {
                    int ihi;
                    fk = this.f[k];
                    b = fk[1];
                    float c = fk[2];
                    float bjc = b * (float)js + c;
                    a = fk[0];
                    float bjca = -bjc / a;
                    float sep = fk[3];
                    int ilo = (int)(bjca - sep);
                    if (ilo >= w || (ihi = (int)(bjca + sep)) < 0) continue;
                    if (ilo < 0) {
                        ilo = 0;
                    }
                    int n2 = ilo;
                    dAj[n2] = dAj[n2] + (a *= dfactor);
                    int n3 = ilo;
                    dCj[n3] = dCj[n3] + (bjc *= dfactor);
                    if (ihi >= w) continue;
                    int n4 = ihi;
                    dAj[n4] = dAj[n4] - a;
                    int n5 = ihi;
                    dCj[n5] = dCj[n5] - bjc;
                }
                if (!adding) continue;
                float CC = 0.0f;
                float AA = 0.0f;
                int m = bgHeight * (j - bgY) - bgX;
                boolean bgSpanV = j >= bgY && j < bgY1;
                for (i = 0; i < w; ++i) {
                    float f;
                    int n6 = wj++;
                    float lightness = (AA += dAj[i]) * (float)i + (CC += dCj[i]);
                    finalPix[n6] = f > thresh ? (bgSpanV && i >= bgX && i < bgX1 ? bgPix[m + i] : (byte)0) : (byte)lightness;
                }
            }
            delta += 2;
        }
        if (!init) {
            this.mis.newPixels();
            g.drawImage(this.im, 0, 0, null);
        }
    }

    @Override
    public void showStatus(String s) {
        super.showStatus(s);
        this.statusString = s;
    }

    void maybeShowStatus(Graphics g) {
        if (this.statusString.length() != 0) {
            GraphicsUtils.showStatus((String)this.statusString, (Graphics)g, (Component)this);
        }
    }

    @Override
    public synchronized void mouseEntered(MouseEvent e) {
        this.mouseIN = true;
        this.showStatus("Click to redraw");
    }

    @Override
    public synchronized void mouseExited(MouseEvent e) {
        this.mouseIN = false;
        this.showStatus("");
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        this.F = 0L;
        this.mouseEntered(null);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

