/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.applets.A2;
import egan.geometry.SphericalTriangle;
import egan.graphics.GraphicsUtils;
import egan.util.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Random;

public class KaleidoHedron
extends A2 {
    private static final long serialVersionUID = 1L;
    double pc;
    double tc;
    double dA;
    boolean phiSq;
    float bc;
    final int nOS = 3;
    final int nOS2 = 9;
    final byte transp = (byte)-40;
    int[] alphas;
    SphericalTriangle[] tiles;
    int ntiles;
    double[][] rotation;
    Random ran = new Random();

    public boolean d(Graphics g, int w, int h, int p, int q, int f, boolean C, boolean TB, int L, int V) {
        if (C) {
            if (f == 0) {
                int i;
                long seed = this.ran.nextLong();
                this.ran = new Random(seed);
                this.bc = 1.2f + 0.6f * (float)this.ran.nextDouble();
                int mf = 5;
                int ns = 3;
                int[][] vA = new int[][]{{1, mf}, {1, 2}, {1, ns}};
                SphericalTriangle canonical = new SphericalTriangle((int[][])vA);
                this.tiles = canonical.tiling(120);
                this.ntiles = this.tiles.length;
                this.pc = mf;
                this.tc = (double)mf * (Math.PI / Math.acos(canonical.vertices[1][2]));
                this.phiSq = this.ran.nextDouble() < 0.5;
                double[][] r0 = new double[3][3];
                Utils.setRotation((double[][])r0, (double)(Math.PI * 2 * this.ran.nextDouble()), (double[])Utils.randomUnitVec((Random)this.ran, (boolean)false), (double)1.0);
                for (int i2 = 0; i2 < this.ntiles; ++i2) {
                    this.tiles[i2].rotate(r0);
                }
                this.rotation = new double[3][3];
                double[] xx = new double[3];
                for (i = 0; i < 3; ++i) {
                    xx[i] = r0[i][2];
                }
                Utils.setRotation((double[][])this.rotation, (double)(this.frameA / (double)mf), (double[])xx, (double)1.0);
                this.alphas = new int[10];
                this.alphas[0] = 0;
                this.alphas[9] = -16777216;
                for (i = 1; i < 9; ++i) {
                    this.alphas[i] = (int)Math.round(255.0 * (double)i / 10.0) << 24;
                }
            }
            if (!TB) {
                g.setColor(Color.white);
                g.fillRect(0, 0, w, h);
            }
            for (int i = 0; i < this.ntiles; ++i) {
                this.tiles[i].rotate(this.rotation);
            }
            int npalette = 50;
            int[][] palette = new int[npalette][3];
            this.dA = Math.PI * 2 / (double)npalette;
            double dF = Math.PI * 2 / (double)this.nframes;
            double fA = (double)f * dF;
            for (int i = 0; i < npalette; ++i) {
                double pA = (double)i * this.dA;
                double cosP = Math.cos(pA);
                float sat = 0.3f + 0.7f * (float)(1.0 + cosP) / 2.0f;
                float hue = (float)(1.0 + Math.cos(pA - fA)) / 2.0f;
                float hb = 2.0f * ((this.bc - hue) % 1.0f);
                if (hb > 1.0f) {
                    hb = 2.0f - hb;
                }
                float bri = 1.0f - hb;
                int col = Color.HSBtoRGB(hue, sat, bri);
                int[] pe = palette[i];
                pe[0] = col >> 16 & 0xFF;
                pe[1] = col >> 8 & 0xFF;
                pe[2] = col & 0xFF;
            }
            int wh = w * h;
            int[] pix = new int[wh];
            int wOS = 3 * w;
            int hOS = 3 * h;
            double wc = ((double)wOS - 1.0) / 2.0;
            double hc = ((double)hOS - 1.0) / 2.0;
            double pixel = 1.0 / (Math.min(wc, hc) - 1.0);
            int nSlice = 3 * wOS;
            byte[] slice = new byte[nSlice];
            SphericalTriangle currentLeftTile = null;
            SphericalTriangle nextLeftTile = null;
            SphericalTriangle currentTile = null;
            SphericalTriangle nextTile = null;
            double[] point = new double[3];
            double[][] s = null;
            int ip = 0;
            int px = 0;
            double ychange = -2.0;
            for (int iy = 0; iy < hOS; ++iy) {
                double y;
                double R2;
                if (ip == 0) {
                    for (int k = 0; k < nSlice; ++k) {
                        slice[k] = -40;
                    }
                }
                if ((R2 = 1.0 - (y = ((double)iy - hc) * pixel) * y) < 0.0) continue;
                double xLeft = -Math.sqrt(R2);
                if (nextLeftTile == null) {
                    double[] testvec = new double[]{xLeft, y, 0.0};
                    for (int itile = 0; itile < this.ntiles; ++itile) {
                        if (!this.vectorInTile(this.tiles[itile], testvec)) continue;
                        nextLeftTile = this.tiles[itile];
                        break;
                    }
                }
                while (y >= ychange) {
                    currentLeftTile = nextLeftTile;
                    double ym = 2.0;
                    double ylow = ychange < -1.0 ? y : ychange + 1.0E-10;
                    int kb = 0;
                    for (int ib = 0; ib < 3; ++ib) {
                        double[] sb = currentLeftTile.edgeNormals[ib];
                        double a = sb[0];
                        double b = sb[1];
                        double pmy = 1.0 / Math.sqrt(1.0 + b * b / (a * a));
                        for (int l = -1; l <= 1; l += 2) {
                            double yi = (double)l * pmy;
                            if (!(-b * yi / a < 0.0) || !(yi > ylow) || !(yi < ym)) continue;
                            ym = yi;
                            kb = ib;
                        }
                    }
                    ychange = ym;
                    nextLeftTile = currentLeftTile.links[kb];
                }
                double xchange = -2.0;
                boolean firstInRow = true;
                nextTile = currentLeftTile;
                for (int ix = 0; ix < wOS; ++ix) {
                    double x = ((double)ix - wc) * pixel;
                    double zsq = R2 - x * x;
                    if (zsq >= 0.0) {
                        double phi;
                        double z = Math.sqrt(zsq);
                        if (firstInRow) {
                            x = xLeft;
                            z = 0.0;
                            firstInRow = false;
                        }
                        double[] spt = new double[]{x, y, z};
                        while (x >= xchange) {
                            currentTile = nextTile;
                            s = currentTile.isometry;
                            double xm = 2.0;
                            double xlow = xchange < -1.0 ? x : xchange + 1.0E-10;
                            int kb = 0;
                            for (int ib = 0; ib < 3; ++ib) {
                                double[] sb = currentTile.edgeNormals[ib];
                                double a = sb[0];
                                double c = sb[2];
                                double a2c2 = a * a + c * c;
                                double b = sb[1];
                                double by = b * y;
                                double disc = a2c2 * R2 - by * by;
                                if (!(disc > 0.0)) continue;
                                double mbya = -by * a;
                                disc = Math.abs(c) * Math.sqrt(disc);
                                for (int l = -1; l <= 1; l += 2) {
                                    double xi = (mbya + (double)l * disc) / a2c2;
                                    if (!((a * xi + by) / c < 0.0) || !(xi > xlow) || !(xi < xm)) continue;
                                    xm = xi;
                                    kb = ib;
                                }
                            }
                            xchange = xm;
                            nextTile = currentTile.links[kb];
                        }
                        for (int i = 0; i < 3; ++i) {
                            double pi = 0.0;
                            for (int j = 0; j < 3; ++j) {
                                pi += s[i][j] * spt[j];
                            }
                            point[i] = pi;
                        }
                        double theta = 1.0 - point[2];
                        x = point[0];
                        double d = phi = x == 0.0 ? 0.0 : Math.abs(point[1] / x);
                        if (this.phiSq) {
                            phi *= phi;
                        }
                        slice[ip] = (byte)((int)((this.pc * phi + this.tc * theta) / this.dA + 0.5) % npalette);
                    }
                    if (++ip != nSlice) continue;
                    ip = 0;
                    for (int rp = 0; rp < w; ++rp) {
                        int red = 0;
                        int green = 0;
                        int blue = 0;
                        int pixC = 0;
                        for (int ii = 0; ii < 3; ++ii) {
                            for (int jj = 0; jj < 3; ++jj) {
                                byte pI = slice[rp * 3 + ii + jj * wOS];
                                if (pI == -40) continue;
                                int[] pe = palette[pI];
                                red += pe[0];
                                green += pe[1];
                                blue += pe[2];
                                ++pixC;
                            }
                        }
                        pix[px++] = this.alphas[pixC] | (red /= 9) << 16 | (green /= 9) << 8 | (blue /= 9);
                    }
                }
            }
            GraphicsUtils.drawPixDCM((Component)((Object)this), (Graphics)g, (int[])pix, (int)w, (int)h, (int)w, (int)0, (int)0);
        }
        return C;
    }

    private boolean vectorInTile(SphericalTriangle tile, double[] vec) {
        boolean allPos = true;
        for (int i = 0; i < 3; ++i) {
            double dp = 0.0;
            for (int j = 0; j < 3; ++j) {
                dp += vec[j] * tile.edgeNormals[i][j];
            }
            if (!(dp < 0.0)) continue;
            return false;
        }
        return true;
    }
}

