/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.applets.A2;
import egan.geometry.BSPobject;
import egan.geometry.Gon2D;
import egan.graphics.GraphicsUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.Vector;

public class Kaleidoscope
extends A2 {
    private static final long serialVersionUID = 1L;
    static final BasicStroke str = new BasicStroke(0.5f, 0, 2);
    static final RenderingHints aaON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    GeneralPath path = new GeneralPath(0, 20);
    Line2D.Double line = new Line2D.Double();
    int npoly;
    int nsymm;
    int numv;
    double[][] drift;
    double[][] cen;
    double prad;
    int[] cols;

    public boolean d(Graphics g, int w, int h, int p, int q, int f, boolean C, boolean TB, int L, int V) {
        if (C) {
            double[] vi;
            int iv;
            int i;
            int hc;
            double[] xp = new double[20];
            double[] yp = new double[20];
            int wc = w / 2;
            int scale = hc = h / 2;
            double fa = this.frameA * (double)f;
            double cfa = Math.cos(fa);
            double sfa = Math.sin(fa);
            g.setColor(Color.black);
            g.fillRect(0, 0, w, h);
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(str);
            g2.addRenderingHints(aaON);
            if (f == 0) {
                this.nsymm = 5 + (int)(Math.random() * 20.0);
                double corner = Math.sqrt(wc * wc + hc * hc) / (double)scale;
                double tpn = Math.tan(Math.PI / (double)this.nsymm);
                double opp = corner * tpn;
                double mdrift = 0.1;
                double hdrift = mdrift / 2.0;
                this.numv = 3 + (int)(Math.random() * 2.0);
                double area = 0.005;
                this.prad = Math.sqrt(area / ((double)this.numv / 2.0 * Math.sin(Math.PI * 2 / (double)this.numv)));
                this.npoly = (int)((corner += mdrift) * (opp += mdrift) / 2.0 * (1.0 + Math.random()) / area);
                this.cen = new double[this.npoly][2];
                this.drift = new double[this.npoly][2];
                this.cols = new int[this.npoly];
                for (int ip = 0; ip < this.npoly; ++ip) {
                    double cy = 0.0;
                    double cx = 0.0;
                    do {
                        cy = corner * Math.random() - hdrift;
                    } while ((cx = opp * Math.random() - hdrift) > tpn * cy + hdrift);
                    double[][] vertices = new double[this.numv][2];
                    for (int j = 0; j < 2; ++j) {
                        this.drift[ip][j] = mdrift * (Math.random() - 0.5);
                        this.cen[ip][j] = j == 0 ? cx : -cy;
                    }
                    this.cols[ip] = (int)(216.0 * Math.random());
                }
            }
            double[][] mn = new double[2][3];
            for (i = 0; i < 2; ++i) {
                double aa = (double)i * (1.0 + 1.0 / (double)this.nsymm) * Math.PI;
                mn[i][0] = Math.cos(aa);
                mn[i][1] = Math.sin(aa);
            }
            Vector<Gon2D> v0 = new Vector<Gon2D>(this.npoly);
            for (i = 0; i < this.npoly; ++i) {
                double[][] vertices = new double[this.numv][2];
                double cx = this.cen[i][0];
                double cy = this.cen[i][1];
                double cx1 = cx + cfa * this.drift[i][0];
                double cy1 = cy + sfa * this.drift[i][1];
                double fa1 = this.frameA * (double)f / (double)this.numv;
                double da = Math.PI * 2 / (double)this.numv;
                for (iv = 0; iv < this.numv; ++iv) {
                    double aa = da * (double)iv + fa1;
                    vi = vertices[iv];
                    vi[0] = cx1 + this.prad * Math.cos(aa);
                    vi[1] = cy1 + this.prad * Math.sin(aa);
                }
                Gon2D gon = new Gon2D(vertices, this.numv);
                gon.surfaceID = this.cols[i];
                gon.edgeIDs = new int[this.numv];
                v0.addElement(gon);
            }
            Vector v1 = new Vector(this.npoly);
            Vector hidden = new Vector(this.npoly);
            Vector<Gon2D> src = v0;
            Vector dest = v1;
            for (int im = 0; im < 2; ++im) {
                dest.setSize(0);
                int nsrc = src.size();
                for (i = 0; i < nsrc; ++i) {
                    ((BSPobject)src.elementAt(i)).BSPsplit(mn[im], 1, null, 0.0, null, hidden, dest, dest);
                }
                Vector<Gon2D> tmp = src;
                src = dest;
                dest = tmp;
            }
            for (int l = 0; l < 2 * this.nsymm; ++l) {
                int k = l / 2;
                double ar = (double)k * 2.0 * Math.PI / (double)this.nsymm;
                double car = Math.cos(ar);
                double sar = Math.sin(ar);
                int np = src.size();
                for (i = 0; i < np; ++i) {
                    Gon2D gon = (Gon2D)src.elementAt(i);
                    int nv = gon.nvert;
                    double[][] vertices = gon.vertices;
                    int[] eids = gon.edgeIDs;
                    this.path.reset();
                    for (iv = 0; iv < nv; ++iv) {
                        vi = vertices[iv];
                        double xx = vi[0];
                        double yy = vi[1];
                        if (l % 2 == 1) {
                            xx = -xx;
                        }
                        double xv = xp[iv] = (double)wc + (double)scale * (car * xx + sar * yy);
                        double yv = yp[iv] = (double)hc + (double)scale * (car * yy - sar * xx);
                        if (iv == 0) {
                            this.path.moveTo((float)xv, (float)yv);
                            continue;
                        }
                        this.path.lineTo((float)xv, (float)yv);
                    }
                    this.path.closePath();
                    Color cc = GraphicsUtils.HTMLcolour((int)gon.surfaceID);
                    g2.setPaint(cc);
                    g2.fill(this.path);
                    for (iv = 0; iv < nv; ++iv) {
                        int jv = (iv + 1) % nv;
                        g2.setPaint(eids[iv] == 1 ? cc : Color.black);
                        this.line.setLine(xp[iv], yp[iv], xp[jv], yp[jv]);
                        g2.draw(this.line);
                    }
                }
            }
        }
        return C;
    }
}

