/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.graphics.GraphicsUtils;
import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;

public class Lissajous
extends Applet
implements Runnable,
MouseListener {
    private static final long serialVersionUID = 1L;
    static final BasicStroke str = new BasicStroke(0.5f, 0, 2);
    static final BasicStroke str2 = new BasicStroke(2.5f, 0, 2);
    static final RenderingHints aaON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    GeneralPath path = new GeneralPath(0, 5);
    Line2D.Double line = new Line2D.Double();
    boolean mouseIN = false;
    Image I;
    Graphics G;
    long F = 0L;
    long tStep = 120L;
    long pt;
    private volatile Thread a;
    int maxSF = 9;
    int[] ncurves;
    int[][] sf;
    int[][] tf;
    int[][] ix;
    int[][] iy;
    boolean[][] active;
    double[] cos;
    double[][] xyz;
    Color[] palette;
    boolean recalc = false;
    String statusString = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.addMouseListener(this);
        Thread thisThread = Thread.currentThread();
        while (this.a == thisThread) {
            long t = System.currentTimeMillis();
            Lissajous lissajous = this;
            synchronized (lissajous) {
                if (t - this.pt > this.tStep || t < this.pt) {
                    this.repaint();
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (Exception e) {
                break;
            }
        }
    }

    @Override
    public void start() {
        this.a = new Thread(this);
        this.a.start();
        this.a.setPriority(1);
    }

    @Override
    public void stop() {
        this.a = null;
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public synchronized void update(Graphics g) {
        long t = System.currentTimeMillis();
        if (t - this.pt > this.tStep || t < this.pt) {
            this.pt = t;
            int w = this.getSize().width;
            int h = this.getSize().height;
            if (this.I == null) {
                this.I = this.createImage(w, h);
                this.G = this.I.getGraphics();
            }
            this.d(this.G, w, h);
            g.drawImage(this.I, 0, 0, null);
            this.maybeShowStatus(g);
            ++this.F;
            if (this.F % 50L == 1L) {
                System.gc();
            }
        }
    }

    public void d(Graphics g, int w, int h) {
        int j;
        int k;
        int nc;
        int i;
        int npts = 200;
        int ncols = 24;
        int maxCurves = 3;
        int maxTF = 9;
        int[] primes = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113};
        if (this.cos == null) {
            this.cos = new double[npts];
            double dtheta = Math.PI * 2 / (double)npts;
            for (i = 0; i < npts; ++i) {
                this.cos[i] = Math.cos((double)i * dtheta);
            }
        }
        if (this.F == 0L) {
            int l;
            this.xyz = new double[3][npts + 6];
            this.ix = new int[3][this.maxSF];
            this.iy = new int[3][this.maxSF];
            this.sf = new int[3][this.maxSF];
            this.tf = new int[3][this.maxSF];
            this.active = new boolean[3][this.maxSF];
            this.ncurves = new int[3];
            nc = 0;
            for (i = 0; i < 3; ++i) {
                this.ncurves[i] = k = 1 + (int)((double)maxCurves * Math.random());
                for (j = 0; j < k; ++j) {
                    while (this.active[i][l = (int)((double)this.maxSF * Math.random())]) {
                    }
                    this.active[i][l] = true;
                    this.sf[i][j] = 1 + l;
                    this.tf[i][j] = primes[nc++];
                }
            }
            for (k = 0; k < 2; ++k) {
                int[][] f = k == 0 ? this.sf : this.tf;
                int gcd = 1;
                boolean ok = true;
                l = 2;
                while (ok) {
                    boolean div = true;
                    for (i = 0; i < 3 && div && ok; ++i) {
                        for (j = 0; j < f[i].length && div && ok; ++j) {
                            int fij = f[i][j];
                            if (l > fij) {
                                ok = false;
                                continue;
                            }
                            if (fij % l == 0) continue;
                            div = false;
                        }
                    }
                    if (div && ok) {
                        gcd = l;
                    }
                    ++l;
                }
                if (gcd <= true) continue;
                for (i = 0; i < 3; ++i) {
                    for (j = 0; j < f[i].length; ++j) {
                        f[i][j] = f[i][j] / gcd;
                    }
                }
            }
            this.active = new boolean[3][this.maxSF];
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < this.ncurves[i]; ++j) {
                    this.active[i][this.sf[i][j] - 1] = true;
                }
            }
            this.palette = new Color[ncols + 1];
            for (i = 0; i < ncols; ++i) {
                this.palette[i] = new Color(Color.HSBtoRGB(((float)i + 0.5f) * (1.0f / (float)ncols), 1.0f, 1.0f));
            }
            this.palette[ncols] = Color.gray;
        }
        if (this.recalc) {
            this.recalc = false;
            nc = 0;
            for (i = 0; i < 3; ++i) {
                this.ncurves[i] = 0;
                for (j = 0; j < this.maxSF; ++j) {
                    if (!this.active[i][j]) continue;
                    int n = i;
                    this.ncurves[n] = this.ncurves[n] + 1;
                    this.sf[i][l] = 1 + j;
                    this.tf[i][l] = primes[nc++];
                }
            }
        }
        g.setColor(Color.black);
        g.fillRect(0, 0, w, h);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHints(aaON);
        g2.setStroke(str);
        double w2 = w / 2;
        double h2 = 0.96 * (double)h / 2.0;
        double r1 = 0.1 * h2;
        double r2 = 0.9 * h2;
        double rinc = (r2 - r1) / (double)(this.maxSF - 1);
        for (i = 0; i < 3; ++i) {
            double aa = (0.8333333333333334 - 0.6666666666666666 * (double)i) * Math.PI;
            double cos = Math.cos(aa);
            double sin = Math.sin(aa);
            g2.setPaint(Color.gray);
            this.line.setLine(w2 + r1 * cos, h2 + r1 * sin, w2 + r2 * cos, h2 + r2 * sin);
            g2.draw(this.line);
            for (j = 0; j < this.maxSF; ++j) {
                double r = r1 + (double)j * rinc;
                int ii = (int)(w2 + r * cos);
                int jj = (int)(h2 + r * sin);
                this.ix[i][j] = ii;
                this.iy[i][j] = jj;
                boolean harmonicOn = this.active[i][j];
                g2.setPaint(harmonicOn ? Color.gray : Color.black);
                Ellipse2D.Double ell = new Ellipse2D.Double(ii - 3, jj - 3, 6.0, 6.0);
                g2.fill(ell);
                g2.setPaint(Color.gray);
                g2.draw(ell);
            }
        }
        double coffs = 0.5 + (double)this.F / 20.0;
        int fi = (int)this.F;
        int xlen = this.ncurves[0];
        int ylen = this.ncurves[1];
        int zlen = this.ncurves[2];
        double xfac = xlen;
        double yfac = ylen;
        double zfac = zlen;
        int[] sfX = this.sf[0];
        int[] tfX = this.tf[0];
        int[] sfY = this.sf[1];
        int[] tfY = this.tf[1];
        int[] sfZ = this.sf[2];
        int[] tfZ = this.tf[2];
        double[] xa = this.xyz[0];
        double[] ya = this.xyz[1];
        double[] za = this.xyz[2];
        double[] cosTab = this.cos;
        double[][] square = new double[][]{{-1.2, -1.2}, {-1.2, 1.2}, {1.2, 1.2}, {1.2, -1.2}, {-1.2, -1.2}};
        block17: for (int pass = 0; pass < 4; ++pass) {
            int p1 = (pass + 1) % 3;
            int p2 = (pass + 2) % 3;
            int px = -1;
            int py = 0;
            int pcol = -1;
            double pfx = 0.0;
            double pfy = 0.0;
            for (i = 0; i <= npts + 5; ++i) {
                double x = 0.0;
                double y = 0.0;
                double z = 0.0;
                boolean needXYZ = true;
                if (i <= npts) {
                    if (pass == 0) {
                        for (k = 0; k < xlen; ++k) {
                            x += cosTab[(sfX[k] * i + tfX[k] * fi) % npts] / xfac;
                        }
                        for (k = 0; k < ylen; ++k) {
                            y += cosTab[(sfY[k] * i + tfY[k] * fi) % npts] / yfac;
                        }
                        for (k = 0; k < zlen; ++k) {
                            z += cosTab[(sfZ[k] * i + tfZ[k] * fi) % npts] / zfac;
                        }
                        xa[i] = x;
                        ya[i] = y;
                        za[i] = z;
                        needXYZ = false;
                    }
                } else {
                    if (i == npts + 1) {
                        if (pass == 3) continue block17;
                        px = -1;
                    }
                    this.xyz[p1][i] = square[i - npts - 1][0];
                    this.xyz[p2][i] = square[i - npts - 1][1];
                }
                if (needXYZ) {
                    x = xa[i];
                    y = ya[i];
                    z = za[i];
                }
                if (pass == 0) {
                    x = -1.7;
                } else if (pass == 1) {
                    y = -1.7;
                }
                if (pass == 2) {
                    z = -1.7;
                }
                double fx = w2 * (1.0 + 0.3 * (y - x));
                double fy = h2 * (1.0 + 0.35 * (0.5 * (x + y) - z));
                int xx = (int)fx;
                int yy = (int)fy;
                if (xx == px && yy == py) continue;
                if (px >= 0) {
                    int icol;
                    int n = icol = pass < 3 ? ncols : (int)((double)ncols * ((z / 2.0 + coffs) % 1.0));
                    if (icol != pcol) {
                        g2.setPaint(this.palette[icol]);
                        pcol = icol;
                    }
                    this.line.setLine(pfx, pfy, fx, fy);
                    g2.setStroke(pass == 3 ? str2 : str);
                    g2.draw(this.line);
                }
                px = xx;
                py = yy;
                pfx = fx;
                pfy = fy;
            }
        }
    }

    @Override
    public void showStatus(String s) {
        super.showStatus(s);
        this.statusString = s;
    }

    void maybeShowStatus(Graphics g) {
        if (this.statusString.length() != 0) {
            GraphicsUtils.showStatus((String)this.statusString, (Graphics)g, (Component)this);
        }
    }

    @Override
    public synchronized void mouseEntered(MouseEvent e) {
        this.mouseIN = true;
        this.showStatus("Click on circles to switch harmonics on/off, elsewhere to randomise");
    }

    @Override
    public synchronized void mouseExited(MouseEvent e) {
        this.mouseIN = false;
        this.showStatus("");
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        boolean hitCircle = false;
        block0: for (int i = 0; i < 3 && !hitCircle; ++i) {
            for (int j = 0; j < this.maxSF; ++j) {
                int dx = x - this.ix[i][j];
                int dy = y - this.iy[i][j];
                if (dx * dx + dy * dy > 36) continue;
                this.active[i][j] = !this.active[i][j];
                hitCircle = true;
                continue block0;
            }
        }
        if (hitCircle) {
            this.recalc = true;
        } else {
            this.F = 0L;
        }
        this.mouseEntered(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

