/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.applets.A2;
import egan.graphics.GraphicsUtils;
import egan.maths.SphericalHarmonic;
import egan.util.Utils;
import java.awt.Component;
import java.awt.Graphics;

public class MirrorRind
extends A2 {
    private static final long serialVersionUID = 1L;
    int nOS = 2;
    int nOS2 = this.nOS * this.nOS;
    final byte transp = (byte)-40;
    int nshells;
    double[][][] axes;
    SphericalHarmonic[] sph;
    short[][][] X;
    byte[] tilePix;
    byte[] bpix;

    public boolean d(Graphics g, int w, int h, int p, int q, int f, boolean C, boolean TB, int L, int V) {
        if (C) {
            int l;
            int ia;
            int k;
            int j;
            int i;
            boolean init;
            int wOS = this.nOS * w;
            int hOS = this.nOS * h;
            int ci = 0;
            int w2 = wOS / 2;
            int h2 = hOS / 2;
            double c = this.frameHA * (double)f;
            double s = Math.sin(c);
            c = Math.cos(c);
            double[] xx = new double[6];
            double hm = 0.0;
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            int sc = w / 200 * 72 * this.nOS;
            int tW = 4 * sc;
            int tH = 3 * sc;
            boolean bl = init = f == 0;
            if (init) {
                this.nshells = 1 + (int)(3.0 * Math.random());
                int ns2 = 2 * this.nshells;
                this.axes = new double[ns2][3][3];
                this.sph = new SphericalHarmonic[ns2];
                this.X = new short[ns2][2][];
                this.bpix = new byte[wOS * hOS];
                this.tilePix = new byte[tW * tH];
                int[] a1 = new int[3];
                int xstep = tW / 24;
                int ystep = 2 * xstep;
                int zmod = 9 * ystep * 1000;
                for (int ix = 0; ix < tW; ++ix) {
                    int ii;
                    a1[0] = ii = zmod + ix / xstep;
                    for (int iy = 0; iy < tH; ++iy) {
                        int yy = 2 * iy;
                        int jj = zmod + (zmod + yy - ix) / ystep;
                        int ll = zmod + (zmod - yy - ix - 1) / ystep;
                        a1[1] = jj;
                        a1[2] = ll;
                        for (i = 0; i < 3; ++i) {
                            j = (i + 1) % 3;
                            if ((zmod + a1[i] / 6 - a1[j] / 6) % 3 != 1) continue;
                            if ((zmod + a1[i] / 2 - a1[j] / 2) % 3 == 0 && a1[i] / 2 % 3 == 1) {
                                k = (i + 2) % 3;
                                if ((zmod + a1[i] - a1[j]) % 3 == 1 + a1[i % 2] / 6 % 2) {
                                    ci = 0;
                                    break;
                                }
                                if ((zmod + a1[j] / 2 - a1[k] / 2) % 3 == 1) {
                                    ci = 2 * k + 1;
                                    break;
                                }
                                ci = 2 * j + 1;
                                break;
                            }
                            ci = 2 * i + 1;
                            break;
                        }
                        this.tilePix[iy * tW + ix] = (byte)ci;
                    }
                }
                for (ia = 0; ia < ns2; ++ia) {
                    l = 1 + (int)(10.0 * Math.random());
                    int m = (int)((double)(l + 1) * Math.random());
                    this.sph[ia] = new SphericalHarmonic(l, m, 1);
                    Utils.setRotation((double[][])this.axes[ia], (double)(Math.PI * 2 * Math.random()), (double[])Utils.randomUnitVec(null, (boolean)false), (double)1.0);
                }
            }
            int ff = tH / this.nframes * f;
            int npix = w * h;
            int[] fPix = new int[npix];
            for (i = 0; i < wOS * hOS; ++i) {
                this.bpix[i] = -40;
            }
            int ns = this.nshells;
            double upix0 = 0.0;
            for (int side = 0; side < 2; ++side) {
                double ssign = 1.0 - 2.0 * (double)side;
                for (int ishell = 0; ishell < ns; ++ishell) {
                    int shell = side == 0 ? ishell : ns - 1 - ishell;
                    double srad = (double)(ns - shell) / (double)ns;
                    double dist = 4.0 / srad;
                    double dist2 = dist * dist;
                    double dist4 = dist2 * dist2;
                    double twoDist = 2.0 * dist;
                    double rmax2 = dist2 / (dist2 - 1.0);
                    double rmax = Math.sqrt(rmax2);
                    double bgDist = 200.0 / srad;
                    if (shell == 0) {
                        upix0 = rmax / ((double)h2 - 0.5);
                    }
                    double upix = upix0 / srad;
                    int span2 = (int)(1.499999 + rmax / upix);
                    int span = 2 * span2;
                    if (init) {
                        this.X[shell][side] = new short[span * span];
                        this.X[shell + ns][side] = new short[span * span];
                    }
                    short[] X1 = this.X[shell][side];
                    short[] X2 = this.X[shell + ns][side];
                    double pa = upix * (0.5 - (double)span2);
                    int io = w2 - span2;
                    int jo = h2 - span2;
                    for (int jj = 0; jj < span; ++jj) {
                        double yscan = pa + upix * (double)jj;
                        double yscan2 = yscan * yscan;
                        j = wOS * (jo + jj) + io;
                        for (int ii = 0; ii < span; ++ii) {
                            double dd;
                            double fac;
                            double d;
                            double xscan = pa + upix * (double)ii;
                            double r2 = xscan * xscan + yscan2;
                            if (!(d <= rmax2)) continue;
                            int n = j + ii;
                            int n0 = jj * span + ii;
                            if (init || side == 1) {
                                z = (-dist * r2 + ssign * Math.sqrt(dist4 * (1.0 - r2) + dist2 * r2)) / (dist2 + r2);
                                double pfac = 1.0 + z / dist;
                                x = pfac * xscan;
                                y = pfac * yscan;
                                if (init) {
                                    xx[3] = x;
                                    xx[4] = y;
                                    xx[5] = z;
                                    for (int ja = 0; ja < 2; ++ja) {
                                        ia = ja * ns + shell;
                                        double[][] axesia = this.axes[ia];
                                        for (l = 0; l < 3; ++l) {
                                            double[] axesial = axesia[l];
                                            xx[l] = 0.0;
                                            for (k = 0; k < 3; ++k) {
                                                int n2 = l;
                                                xx[n2] = xx[n2] + xx[3 + k] * axesial[k];
                                            }
                                        }
                                        double xr = xx[0];
                                        double yr = xx[1];
                                        double zr = xx[2];
                                        hm = this.sph[ia].value(xr, yr, zr);
                                        this.X[ia][side][n0] = (short)(511.0 * hm);
                                    }
                                }
                            }
                            if (!(Math.abs(c * (double)X1[n0] + s * (double)X2[n0]) > 120.8)) continue;
                            this.bpix[n] = side == 0 ? 4 : ((fac = srad * ((dd = dist / (twoDist * z + 1.0)) + bgDist) / (dd - z)) > 0.0 ? this.tilePix[tW * ((Math.abs((int)(y * fac + 135791.0)) + ff) % tH) + Math.abs((int)(x * fac + 135791.0)) % tW] : 0);
                        }
                    }
                }
            }
            int px = 0;
            for (i = 0; i < w; ++i) {
                for (j = 0; j < h; ++j) {
                    int grey = 0;
                    int alpha = 0;
                    for (int ii = 0; ii < this.nOS; ++ii) {
                        for (int jj = 0; jj < this.nOS; ++jj) {
                            byte pI = this.bpix[i * this.nOS + (j * this.nOS + jj) * wOS + ii];
                            if (pI == -40) continue;
                            grey += pI;
                            alpha += 255;
                        }
                    }
                    grey = 51 * grey / this.nOS2;
                    fPix[px++] = (alpha /= this.nOS2) << 24 | grey << 16 | grey << 8 | grey;
                }
            }
            GraphicsUtils.drawPixDCM((Component)((Object)this), (Graphics)g, (int[])fPix, (int)w, (int)h, (int)w, (int)0, (int)0);
        } else {
            this.X = null;
            this.tilePix = null;
        }
        return C;
    }
}

