/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.graphics.GraphicsUtils;
import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;

public class Prisms
extends Applet
implements Runnable,
MouseListener {
    private static final long serialVersionUID = 1L;
    Image I;
    Graphics G;
    boolean mouseIN = false;
    long F = 0L;
    long tStep = 120L;
    long pt;
    private volatile Thread a;
    int np;
    int nv;
    double ap;
    double av;
    double dphase;
    double dphase0;
    double R;
    double prad;
    double[][] cen;
    double[] xs;
    double[] ys;
    double[] rs;
    double[] ref1;
    double[] ref2;
    static final BasicStroke str = new BasicStroke(0.5f, 0, 2);
    static final RenderingHints aaON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    GeneralPath path = new GeneralPath(0, 20);
    String statusString = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.addMouseListener(this);
        Thread thisThread = Thread.currentThread();
        while (this.a == thisThread) {
            long t = System.currentTimeMillis();
            Prisms prisms = this;
            synchronized (prisms) {
                if (t - this.pt > this.tStep || t < this.pt) {
                    this.repaint();
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (Exception e) {
                break;
            }
        }
    }

    @Override
    public void start() {
        this.a = new Thread(this);
        this.a.start();
        this.a.setPriority(1);
    }

    @Override
    public void stop() {
        this.a = null;
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public synchronized void update(Graphics g) {
        long t = System.currentTimeMillis();
        if (t - this.pt > this.tStep || t < this.pt) {
            this.pt = t;
            int w = this.getSize().width;
            int h = this.getSize().height;
            if (this.I == null) {
                this.I = this.createImage(w, h);
                this.G = this.I.getGraphics();
            }
            this.d(this.G, w, h);
            g.drawImage(this.I, 0, 0, null);
            this.maybeShowStatus(g);
            ++this.F;
            if (this.F % 50L == 1L) {
                System.gc();
            }
        }
    }

    public void d(Graphics g, int w, int h) {
        int j;
        int i;
        int nrays = 1;
        int nbundle = 1;
        int ncols = 7 * nbundle;
        double minRI = 1.1;
        double span = 1.2;
        Color[] spec = GraphicsUtils.spectrum;
        if (this.F == 0L) {
            int esep;
            double ha;
            double target;
            do {
                this.nv = 3 + (int)(6.0 * Math.random());
                int nq = 3 + (int)(10.0 * Math.random());
                if (nq % 2 == 1) {
                    ++nq;
                }
                this.np = nq + 1;
                this.ap = Math.PI * 2 / (double)nq;
                this.av = Math.PI * 2 / (double)this.nv;
            } while ((target = Math.sin((ha = (Math.PI - (double)(esep = 1 + (int)(Math.random() * (double)(this.nv / 2 - 1))) * this.av) / 2.0) + this.ap / 2.0) / Math.sin(ha)) <= minRI || (Math.PI - this.ap) / 2.0 <= ha);
            double sa = Math.sin(this.ap / 2.0);
            this.R = 0.49 / (1.0 + sa);
            this.prad = 0.9 * this.R * sa;
            this.cen = new double[this.np][2];
            for (i = 1; i < this.np; ++i) {
                double aa = (double)(i - 1) * this.ap;
                this.cen[i][0] = 0.5 + this.R * Math.cos(aa);
                this.cen[i][1] = 0.5 + this.R * Math.sin(aa);
            }
            this.xs = new double[nrays];
            this.ys = new double[nrays];
            this.rs = new double[nrays];
            for (int iray = 0; iray < nrays; ++iray) {
                j = (int)(Math.random() * (double)(this.np - 1));
                double a0 = this.ap / 2.0 - this.av * ((double)esep - 1.0) / 2.0;
                double a1 = a0 - this.av;
                double pr0 = Math.cos(a0);
                double pr1 = Math.cos(a1);
                double pr2 = Math.cos(this.av / 2.0);
                if (pr2 < pr0) {
                    pr1 = Math.max(pr1, pr2);
                }
                double mu = Math.random();
                double r1 = this.R * Math.cos(this.ap / 2.0) + this.prad * (pr0 * mu + (1.0 - mu) * pr1);
                double ajk = ((double)j + 0.5) * this.ap;
                double ds = Math.random() < 0.5 ? 1.0 : -1.0;
                this.rs[iray] = ajk + ds * Math.PI / 2.0;
                this.xs[iray] = 0.5 + r1 * Math.cos(ajk);
                this.ys[iray] = 0.5 + r1 * Math.sin(ajk);
                this.dphase0 = 0.5 * (this.ap / this.av - 1.0) * (double)(1 - 2 * (j % 2));
            }
            this.ref1 = new double[ncols];
            this.ref2 = new double[ncols];
            double nc1 = (double)ncols - 1.0;
            j = (int)(Math.random() * Math.min((double)ncols, nc1 * Math.log(target / minRI) / Math.log(span)));
            for (i = 0; i < ncols; ++i) {
                this.ref1[i] = target * Math.pow(span, (double)(i - j) / nc1);
                this.ref2[i] = 1.0 / this.ref1[i];
            }
            this.dphase = this.dphase0;
        }
        double[][][] vxy = new double[this.np][this.nv][2];
        double[][][] un = new double[this.np][this.nv][2];
        double[][] border = new double[][]{{0.0, 0.0}, {0.0, 1.0}, {1.0, 1.0}, {1.0, 0.0}};
        vxy[0] = border;
        for (i = 1; i < this.np; ++i) {
            double x = this.cen[i][0];
            double y = this.cen[i][1];
            int i0 = i - 1;
            double phase = (double)i0 * this.ap + (double)(1 - 2 * (i0 % 2)) * this.av * this.dphase;
            for (j = 0; j < this.nv; ++j) {
                double aa = phase + (double)j * this.av;
                vxy[i][j][0] = x + this.prad * Math.cos(aa);
                vxy[i][j][1] = y + this.prad * Math.sin(aa);
                aa = phase + ((double)j + 0.5) * this.av;
                un[i][j][0] = Math.cos(aa);
                un[i][j][1] = Math.sin(aa);
            }
        }
        g.setColor(Color.black);
        g.fillRect(0, 0, w, h);
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(str);
        g2.addRenderingHints(aaON);
        double hits = 0.0;
        boolean[][] hitPrism = new boolean[this.np][this.np];
        double[] dp = new double[20];
        for (int iray = 0; iray < nrays; ++iray) {
            int jx1 = -1;
            int jy1 = -1;
            int jx2 = -1;
            int jy2 = -1;
            boolean[] coltab = new boolean[ncols];
            block7: for (int jcol = 0; jcol < ncols; ++jcol) {
                int icol;
                while (coltab[icol = (int)((double)ncols * Math.random())]) {
                }
                coltab[icol] = true;
                int i1 = -1;
                int j1 = -1;
                double xa = this.xs[iray];
                double ya = this.ys[iray];
                int ix1 = (int)((double)w * xa);
                int iy1 = (int)((double)h * ya);
                double ra = this.rs[iray];
                double c = Math.cos(ra);
                double s = Math.sin(ra);
                boolean done = false;
                boolean inGlass = false;
                for (int m = 0; m < 200 && !done; ++m) {
                    int k;
                    int nvi;
                    double dd = c * ya - s * xa;
                    double lambda0 = 1.0E10;
                    double mu0 = 0.0;
                    int i0 = -1;
                    int j0 = -1;
                    int prism1 = 0;
                    int prism2 = this.np - 1;
                    if (inGlass) {
                        prism1 = prism2 = i1;
                    }
                    for (i = prism1; i <= prism2; ++i) {
                        if (!inGlass && i == i1) continue;
                        double[][] vxyi = vxy[i];
                        nvi = vxyi.length;
                        int pc = 0;
                        for (j = 0; j < nvi; ++j) {
                            double[] vxyij = vxyi[j];
                            dp[j] = c * vxyij[1] - s * vxyij[0] - dd;
                            if (!(dp[j] >= 0.0)) continue;
                            ++pc;
                        }
                        if (pc <= 0 || pc >= nvi) continue;
                        for (j = 0; j < nvi; ++j) {
                            double mu;
                            double lambda;
                            double dpj;
                            if (inGlass && j == j1 || !((dpj = dp[j]) * dp[k = (j + 1) % nvi] < 0.0) || !((lambda = ((mu = dpj / (dpj - dp[k])) * vxyi[k][0] + (1.0 - mu) * vxyi[j][0] - xa) / c) > 1.0E-5) || !(lambda < lambda0)) continue;
                            lambda0 = lambda;
                            i0 = i;
                            j0 = j;
                            mu0 = mu;
                        }
                    }
                    if (i0 < 0) continue block7;
                    double[][] vxy0 = vxy[i0];
                    nvi = vxy0.length;
                    k = (j0 + 1) % nvi;
                    double xb = mu0 * vxy0[k][0] + (1.0 - mu0) * vxy0[j0][0];
                    double yb = mu0 * vxy0[k][1] + (1.0 - mu0) * vxy0[j0][1];
                    g2.setPaint(m == 0 ? Color.white : spec[icol / nbundle]);
                    int ix2 = (int)((double)w * xb);
                    int iy2 = (int)((double)h * yb);
                    if (m <= 1) {
                        jx1 = ix1;
                        jy1 = iy1;
                        jx2 = ix2;
                        jy2 = iy2;
                    } else if (ix1 == jx1 && iy1 == jy1 && ix2 == jx2 && iy2 == jy2) continue block7;
                    this.path.reset();
                    this.path.moveTo(ix1, iy1);
                    this.path.lineTo(ix2, iy2);
                    g2.draw(this.path);
                    if (i0 == 0) {
                        done = true;
                    } else {
                        double ct;
                        double u0 = un[i0][j0][0];
                        double u1 = un[i0][j0][1];
                        double ci = u0 * c + u1 * s;
                        double si = -u1 * c + u0 * s;
                        double st = si / (inGlass ? this.ref2[icol] : this.ref1[icol]);
                        double stsq = st * st;
                        if (stsq <= 1.0) {
                            ct = (inGlass ? 1.0 : -1.0) * Math.sqrt(1.0 - stsq);
                            inGlass = !inGlass;
                        } else {
                            ct = -ci;
                            st = si;
                        }
                        c = ct * u0 - st * u1;
                        s = ct * u1 + st * u0;
                        if (i1 > 0 && i1 != i0 && !hitPrism[i0][i1]) {
                            hitPrism[i0][i1] = true;
                            hits += 1.0;
                        }
                        i1 = i0;
                        j1 = j0;
                    }
                    xa = xb;
                    ya = yb;
                    ix1 = ix2;
                    iy1 = iy2;
                }
            }
        }
        double resfac = Math.min(2.0, hits / (double)(this.np - 1));
        this.dphase += 0.04 * Math.pow(0.01, 0.5 * resfac);
        if (this.dphase - this.dphase0 > 1.0) {
            this.F = -1L;
        }
        g2.setPaint(new Color(0x666666));
        for (i = 1; i < this.np; ++i) {
            this.path.reset();
            for (j = 0; j < this.nv; ++j) {
                double xp = (double)w * vxy[i][j % this.nv][0];
                double yp = (double)h * vxy[i][j % this.nv][1];
                if (j == 0) {
                    this.path.moveTo((float)xp, (float)yp);
                    continue;
                }
                this.path.lineTo((float)xp, (float)yp);
            }
            this.path.closePath();
            g2.draw(this.path);
        }
    }

    @Override
    public void showStatus(String s) {
        super.showStatus(s);
        this.statusString = s;
    }

    void maybeShowStatus(Graphics g) {
        if (this.statusString.length() != 0) {
            GraphicsUtils.showStatus((String)this.statusString, (Graphics)g, (Component)this);
        }
    }

    @Override
    public synchronized void mouseEntered(MouseEvent e) {
        this.mouseIN = true;
        this.showStatus("Click to redraw");
    }

    @Override
    public synchronized void mouseExited(MouseEvent e) {
        this.mouseIN = false;
        this.showStatus("");
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        this.F = 0L;
        this.mouseEntered(null);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

