/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.applets.A2;
import egan.graphics.GraphicsUtils;
import egan.maths.SphericalHarmonic;
import egan.util.Utils;
import java.awt.Component;
import java.awt.Graphics;

public class SoapBubbles
extends A2 {
    private static final long serialVersionUID = 1L;
    SphericalHarmonic[] sph;
    double[] omega;
    double ba;
    double athick;
    double bthick;
    double[][][] hax;
    double[][] light = new double[3][];

    public boolean d(Graphics g, int w, int h, int p, int q, int f, boolean C, boolean TB, int L, int V) {
        if (C) {
            int k;
            int n;
            int j;
            int l;
            int ia;
            int i;
            int nOS = 3;
            int nOS2 = nOS * nOS;
            int viewW = w;
            int viewH = h;
            int vwh = w * h;
            int wh = (w *= nOS) * (h *= nOS);
            int nh = 3;
            int nb = 6;
            int pop = this.nframes - 3;
            double[] wave = new double[]{701.0, 534.5, 422.5};
            float cutoff = 1.0f;
            int sdist = Math.min(w, h) / 2;
            double[] v = new double[6];
            float[][] pcols = new float[wh][3];
            int[] fPix = new int[vwh];
            float bscale = (float)(51.0 / (double)nOS2);
            if (f == 0) {
                this.ba = Math.PI * 2 * Math.random();
                this.athick = Math.PI * 10 * wave[0] * (0.25 + 0.75 * Math.random());
                this.bthick = 0.5;
                double phi = -Math.random() * Math.PI / 4.0;
                double cphi = Math.cos(phi);
                double sphi = Math.sin(phi);
                for (i = 0; i < 3; ++i) {
                    double theta = Math.PI * 2 * Math.random();
                    double[] ls = new double[]{cphi * Math.cos(theta), cphi * Math.sin(theta), sphi};
                    this.light[i] = ls;
                }
                this.sph = new SphericalHarmonic[nh];
                this.omega = new double[nh];
                this.hax = new double[nh][3][3];
                for (ia = 0; ia < nh; ++ia) {
                    l = 1 + (int)(10.0 * Math.random());
                    int m = (int)((double)(l + 1) * Math.random());
                    this.sph[ia] = new SphericalHarmonic(l, m, 1);
                    this.omega[ia] = 1.5 * Math.sqrt(l * (l + 1));
                    Utils.setRotation((double[][])this.hax[ia], (double)(Math.PI * 2 * Math.random()), (double[])Utils.randomUnitVec(null, (boolean)false), (double)1.0);
                }
            }
            double at = this.athick;
            double bt = this.bthick;
            double a = this.ba - this.frameHA * (double)f;
            double cba = Math.cos(a);
            double sba = Math.sin(a);
            double[] lx = new double[3];
            double[] ly = new double[3];
            double lz = 0.0;
            for (i = 0; i < 3; ++i) {
                double[] ls = this.light[i];
                lx[i] = -sba * ls[0] + cba * ls[1];
                ly[i] = cba * ls[0] + sba * ls[1];
                lz = ls[2];
            }
            float lfac = (float)(10.0 / (1.0 + lz));
            int fpop = f - pop;
            double bfade = 1.0 + 6.0 * (double)fpop / (double)(this.nframes - 1 - pop);
            float df = 0.0f;
            for (int side = 0; side < 2; ++side) {
                for (int kb = 0; kb < nb; ++kb) {
                    int ib = side == 0 ? kb : nb - 1 - kb;
                    boolean bursting = ib == 0 && fpop > 0;
                    double jb = 1.0 - 2.0 * (double)(ib % 2);
                    double bf = (double)ib - (double)fpop / (double)this.nframes;
                    boolean topLayer = side == 1 && kb >= nb - 2;
                    int ri = (int)((double)sdist * Math.pow(0.5, bf));
                    double xpx = jb / (double)ri;
                    double dfact = 0.92 + 0.08 * bf / (double)nb;
                    ri = (int)((double)ri / dfact);
                    double cRad = jb * (double)ri;
                    int xc = w / 2 + (int)(cba * cRad);
                    int yc = h / 2 + (int)(sba * cRad);
                    double ypx = jb / (double)ri;
                    double[] s = new double[nh];
                    for (l = 0; l < nh; ++l) {
                        s[l] = Math.sin(bf * this.omega[l]);
                    }
                    for (j = -ri; j <= ri; ++j) {
                        int ay = yc + j;
                        if (ay < 0 || ay >= h) continue;
                        for (i = -ri; i <= ri; ++i) {
                            double d;
                            int ax = xc + i;
                            if (ax < 0 || ax >= w || (n = ax + w * ay) < 0 || n >= wh) continue;
                            float[] pcolsn = pcols[n];
                            double y0 = ypx * ((double)i * cba + (double)j * sba);
                            double x0 = xpx * ((double)j * cba - (double)i * sba);
                            double zz = 1.0 - y0 * y0 - x0 * x0;
                            if (!(d >= 0.0)) continue;
                            v[3] = x0;
                            v[4] = y0;
                            double pathLengthFactor = Math.sqrt(0.7689000000000001 + zz);
                            double z0 = Math.sqrt(zz);
                            float bfac = lfac * (bursting ? (float)Math.exp(-bfade * y0 * y0) : 1.0f);
                            k = 2 * side - 1;
                            v[5] = (double)k * z0;
                            double ns = jb * (double)k;
                            double x1 = ns * x0;
                            double y1 = ns * y0;
                            boolean gotHM = false;
                            double yy = 0.0;
                            double d1 = 0.0;
                            float tdim = z0 < 0.4 ? 0.9f * (float)Math.exp(1.0 - 0.4 / (z0 + 1.0E-10)) : 0.9f;
                            for (int ic = 0; ic < 3; ++ic) {
                                float dp = (float)(2.0 * z0 * (lx[ic] * x1 + ly[ic] * y1 + lz * z0) - lz);
                                if (dp > 0.0f) {
                                    float f2;
                                    df = bfac * (dp * dp * dp);
                                    if (f2 >= cutoff) {
                                        if (!gotHM) {
                                            for (ia = 0; ia < nh; ++ia) {
                                                for (l = 0; l < 3; ++l) {
                                                    v[l] = 0.0;
                                                    for (k = 0; k < 3; ++k) {
                                                        int n2 = l;
                                                        v[n2] = v[n2] + v[3 + k] * this.hax[ia][l][k];
                                                    }
                                                }
                                                yy += s[ia] * this.sph[ia].value(v[0], v[1], v[2]);
                                            }
                                            d1 = at * (1.0 + bt * (yy / (double)nh)) * pathLengthFactor;
                                            gotHM = true;
                                        }
                                        float mag = (float)Math.sin(d1 / wave[ic]);
                                        pcolsn[ic] = tdim * pcolsn[ic] + mag * mag * df;
                                        continue;
                                    }
                                }
                                pcolsn[ic] = tdim * pcolsn[ic];
                            }
                        }
                    }
                }
            }
            float[] pc = new float[3];
            for (i = 0; i < viewW; ++i) {
                for (j = 0; j < viewH; ++j) {
                    for (k = 0; k < 3; ++k) {
                        pc[k] = 0.0f;
                    }
                    for (int ii = 0; ii < nOS; ++ii) {
                        for (int jj = 0; jj < nOS; ++jj) {
                            n = nOS * i + ii + w * (nOS * j + jj);
                            for (k = 0; k < 3; ++k) {
                                int n3 = k;
                                pc[n3] = pc[n3] + pcols[n][k];
                            }
                        }
                    }
                    int ci = 0;
                    for (k = 0; k < 3; ++k) {
                        ci = ci << 8 | Math.min(255, (int)(bscale * Math.abs(pc[k])));
                    }
                    fPix[i + viewW * j] = 0xFF000000 | ci;
                }
            }
            GraphicsUtils.drawPixDCM((Component)((Object)this), (Graphics)g, (int[])fPix, (int)viewW, (int)viewH, (int)viewW, (int)0, (int)0);
        }
        return C;
    }
}

