/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.graphics.GraphicsUtils;
import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Line2D;

public class Subluminal
extends Applet
implements Runnable,
MouseListener {
    private static final long serialVersionUID = 1L;
    boolean mouseIN = false;
    BasicStroke str;
    static final RenderingHints aaON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    Line2D.Double line = new Line2D.Double();
    long F = 0L;
    long pt = 0L;
    long tStep = 100L;
    private volatile Thread a;
    Image I;
    Image[] strips;
    Graphics o;
    boolean positive = true;
    boolean shutterDown;
    int nspec = 2;
    int nparts = 7 * this.nspec;
    int nwaves = this.nparts + 1;
    double[] k;
    double[] omega;
    double[][] xphase;
    double[] vel;
    double[] lambda;
    double[] offset;
    int[] ps;
    Color[][] palette;
    static final int twoPI = 2000;
    double[] waveTab;
    double dA = 0.0031415926535897933;
    double[][] contribs;
    int waveHeight;
    static final int maxSh = 50;
    double[][][] sGap;
    int iSh;
    int nSh;
    int shutterX;
    String statusString = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.addMouseListener(this);
        Thread thisThread = Thread.currentThread();
        while (this.a == thisThread) {
            long t = System.currentTimeMillis();
            Subluminal subluminal = this;
            synchronized (subluminal) {
                if (t - this.pt > this.tStep || t < this.pt) {
                    this.repaint();
                }
            }
            try {
                Thread.sleep(20L);
            }
            catch (Exception e) {
                break;
            }
        }
    }

    @Override
    public void start() {
        this.a = new Thread(this);
        this.a.start();
        this.a.setPriority(1);
    }

    @Override
    public void stop() {
        this.a = null;
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public synchronized void update(Graphics g) {
        long t = System.currentTimeMillis();
        if (t - this.pt >= this.tStep || t < this.pt) {
            this.pt = t;
            int w = this.getSize().width;
            int h = this.getSize().height;
            if (this.F == 0L) {
                int i;
                int i2;
                this.str = new BasicStroke((float)(h > 300 ? 1 : 0) + 1.0f, 0, 2);
                this.contribs = new double[w][this.nparts];
                this.waveHeight = (int)(0.5 + ((double)(h - 2 * this.nparts) - 1.0) / (4.0 * (double)this.nparts));
                this.k = new double[this.nparts];
                this.omega = new double[this.nparts];
                this.vel = new double[this.nparts];
                this.lambda = new double[this.nparts];
                double omin = 90.0;
                double omax = 180.0;
                double ospan = omax - omin;
                double delta = ospan / (double)(this.nparts - 1);
                for (i2 = 0; i2 < this.nparts; ++i2) {
                    double om = omin + (double)i2 * delta;
                    double kay = omax + (om - omax) / (double)(this.positive ? 3 : -3);
                    this.omega[i2] = om / this.dA;
                    this.k[i2] = kay / this.dA;
                    this.vel[i2] = (double)w * om / kay;
                    this.lambda[i2] = Math.PI * 2 / kay * (double)w;
                }
                this.waveTab = new double[2000];
                for (i2 = 0; i2 < 2000; ++i2) {
                    this.waveTab[i2] = (double)(-this.waveHeight) * Math.sin(this.dA * (double)i2);
                }
                this.xphase = new double[this.nparts][w];
                for (int j = 0; j < w; ++j) {
                    double x = (double)j / (double)w;
                    for (int i3 = 0; i3 < this.nparts; ++i3) {
                        this.xphase[i3][j] = this.k[i3] * x;
                    }
                }
                this.palette = new Color[7][this.waveHeight + 1];
                float[] hsb = new float[3];
                for (i = 0; i < 7; ++i) {
                    Color col = GraphicsUtils.spectrum[i];
                    Color.RGBtoHSB(col.getRed(), col.getGreen(), col.getBlue(), hsb);
                    for (int j = 0; j <= this.waveHeight; ++j) {
                        this.palette[i][j] = new Color(Color.HSBtoRGB(hsb[0], 1.0f, 0.4f + 0.6f * ((float)j / (float)this.waveHeight)));
                    }
                }
                this.strips = new Image[this.nparts];
                this.offset = new double[this.nparts];
                this.ps = new int[this.nparts];
                for (i = 0; i < this.nparts; ++i) {
                    this.offset[i] = -2 * w;
                    int sw = 2 * w + 2;
                    int sh = 2 * (this.waveHeight + 1);
                    this.strips[i] = this.createImage(sw, sh);
                    Graphics G = this.strips[i].getGraphics();
                    G.setColor(Color.black);
                    G.fillRect(0, 0, sw, sh);
                    Graphics2D G2 = (Graphics2D)G;
                    G2.setStroke(this.str);
                    G2.addRenderingHints(aaON);
                    int py = 0;
                    int pci = 0;
                    int fl = this.waveHeight + 1;
                    Color[] cp = this.palette[i / this.nspec];
                    for (int j = 0; j <= sw; ++j) {
                        double x = (double)(j - 2 * w) / (double)w;
                        double zz = this.waveTab[(int)Math.abs(this.k[i] * x) % 2000];
                        int iy = (int)((double)fl + 0.5 + zz);
                        int ci = Math.abs(fl - iy);
                        if (j > 0) {
                            G2.setPaint(cp[Math.max(ci, pci)]);
                            this.line.setLine(j - 1, py, j, iy);
                            G2.draw(this.line);
                        }
                        py = iy;
                        pci = ci;
                    }
                }
                this.sGap = new double[50][this.nparts][2];
                this.shutterX = w / 2;
                this.shutterDown = false;
                this.iSh = 0;
                this.nSh = 1;
                for (i = 0; i < this.nparts; ++i) {
                    this.sGap[0][i][0] = 2 * w + 1;
                    this.sGap[0][i][1] = 5 * w;
                }
                this.I = this.createImage(w, h);
                this.o = this.I.getGraphics();
            }
            this.d(this.o, w, h, this.F);
            g.drawImage(this.I, 0, 0, null);
            this.maybeShowStatus(g);
            ++this.F;
        }
    }

    public void d(Graphics g, int w, int h, long f) {
        double dt = 0.01;
        double t = dt * (double)f;
        g.setColor(Color.black);
        g.fillRect(0, 0, w, h);
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(this.str);
        g2.addRenderingHints(aaON);
        int dh = 2 * (this.waveHeight + 1);
        int delta = 0;
        boolean canRatchet = true;
        for (int i = 0; i < this.nparts; ++i) {
            int minshift;
            double shift = this.offset[i];
            double lam = this.lambda[i];
            double ki = this.k[i];
            int idh = i * dh;
            if (shift > 0.0) {
                double backStep = lam * (double)((int)((double)w / lam));
                this.offset[i] = shift -= backStep;
                for (int l = 0; l < this.nSh; ++l) {
                    int jSh = (this.iSh + l) % 50;
                    double[] dArray = this.sGap[jSh][i];
                    dArray[0] = dArray[0] + backStep;
                    double[] dArray2 = this.sGap[jSh][i];
                    dArray2[1] = dArray2[1] + backStep;
                }
                canRatchet = false;
            }
            int ishift = (int)shift;
            if (canRatchet && f > 0L && i > 1 && ishift < (minshift = this.ps[i] + delta)) {
                ishift = minshift;
            }
            g.drawImage(this.strips[i], ishift, idh, null);
            delta = ishift - this.ps[i];
            this.ps[i] = ishift;
            double tphase = this.omega[i] * t;
            double[] xp = this.xphase[i];
            for (int j = 0; j < w; ++j) {
                this.contribs[j][i] = this.waveTab[(int)Math.abs(xp[j] - tphase) % 2000];
            }
            int fl = idh + this.waveHeight + 1;
            int iDecay = (int)lam;
            Color[] cp = this.palette[i / this.nspec];
            for (int l = this.nSh - 1; l >= 0; --l) {
                int jSh = (this.iSh + l) % 50;
                double[] sg = this.sGap[jSh][i];
                int s1 = ishift + (int)sg[0];
                int s0 = s1 - iDecay;
                if (i == 0 && s0 > w && l == 0) {
                    this.iSh = (this.iSh + 1) % 50;
                    --this.nSh;
                    break;
                }
                int s3 = ishift + (int)sg[1];
                int s2 = s3 - iDecay;
                if (l == this.nSh - 1 && this.shutterDown) {
                    sg[0] = (double)this.shutterX - this.offset[i];
                    s0 = s1 = this.shutterX;
                }
                if (s2 < s1) {
                    s1 = s2 = (s1 + s2) / 2;
                }
                g.setColor(Color.black);
                g.fillRect(s0, idh, s3 - s0, dh);
                int[][] ep = new int[][]{{s0, s1}, {s2, s3}};
                for (int pass = 0; pass < 2; ++pass) {
                    int py = 0;
                    int pci = 0;
                    int[] epp = ep[pass];
                    for (int j = epp[0]; j <= epp[1]; ++j) {
                        if (j < 0 || j >= w) continue;
                        double dd = (double)Math.abs(j - epp[pass]) / (double)iDecay;
                        double factor = 0.5 - 0.5 * Math.sin(Math.PI * (dd - 0.5));
                        double[] dArray = this.contribs[j];
                        int n = i;
                        dArray[n] = dArray[n] * factor;
                        double x = (double)(j - 2 * w - ishift) / (double)w;
                        double zz = factor * this.waveTab[(int)Math.abs(ki * x) % 2000];
                        int iy = (int)((double)fl + 0.5 + zz);
                        int ci = Math.abs(fl - iy);
                        if (j > epp[0]) {
                            g2.setPaint(cp[Math.max(ci, pci)]);
                            this.line.setLine(j - 1, py, j, iy);
                            g2.draw(this.line);
                        }
                        py = iy;
                        pci = ci;
                    }
                }
                g2.setPaint(cp[0]);
                this.line.setLine(s1, fl, s2, fl);
                g2.draw(this.line);
                for (int j = s1; j <= s2; ++j) {
                    if (j < 0 || j >= w) continue;
                    this.contribs[j][i] = 0.0;
                }
            }
            int n = i;
            this.offset[n] = this.offset[n] + this.vel[i] * dt;
        }
        g2.setPaint(Color.gray);
        int ngrid = 6;
        int dg = w / ngrid;
        for (int i = 0; i < ngrid; ++i) {
            int xf = ((int)((double)w * (t % 1.0)) + i * dg) % w;
            this.line.setLine(xf, 0.0, xf, h - 1);
            g2.draw(this.line);
        }
        double z = (double)((h + this.nparts * dh) / 2) + 0.5;
        g2.setColor(Color.white);
        int py = 0;
        for (int j = 0; j < w; ++j) {
            double sum = z;
            double[] cj = this.contribs[j];
            for (int i = 0; i < this.nparts; ++i) {
                sum += cj[i];
            }
            int iy = (int)sum;
            if (j > 0) {
                this.line.setLine(j - 1, py, j, iy);
                g2.draw(this.line);
            }
            py = iy;
        }
        if (this.shutterDown) {
            g.setColor(Color.gray);
            g.fillRect(this.shutterX - 2, 0, 5, h);
            g.setColor(Color.white);
            g.drawRect(this.shutterX - 2, 0, 5, h - 1);
        }
    }

    @Override
    public void showStatus(String s) {
        super.showStatus(s);
        this.statusString = s;
    }

    void maybeShowStatus(Graphics g) {
        if (this.statusString.length() != 0) {
            GraphicsUtils.showStatus((String)this.statusString, (Graphics)g, (Component)this);
        }
    }

    @Override
    public synchronized void mouseEntered(MouseEvent e) {
        this.mouseIN = true;
        String[] pn = new String[]{"positive", "negative"};
        int pni = this.positive ? 0 : 1;
        this.showStatus(this.shutterDown ? "Shutter is down; SHIFT-click to raise it." : "Group velocity is " + pn[pni] + "; click to see " + pn[1 - pni] + ". SHIFT-click to lower shutter.");
    }

    @Override
    public synchronized void mouseExited(MouseEvent e) {
        this.mouseIN = false;
        this.showStatus("");
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        if (e.isShiftDown()) {
            this.shutterDown = !this.shutterDown;
            if (this.shutterDown) {
                int jSh = (this.iSh + this.nSh) % 50;
                for (int i = 0; i < this.nparts; ++i) {
                    this.sGap[jSh][i][1] = (double)this.shutterX - this.offset[i];
                }
                ++this.nSh;
            }
        } else {
            this.positive = !this.positive;
            this.shutterDown = false;
            this.F = 0L;
        }
        this.mouseEntered(null);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

