/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.geometry.BSP;
import egan.geometry.BSPobject;
import egan.geometry.Gon3D;
import egan.geometry.PointManager;
import egan.geometry.Polyhedron;
import egan.graphics.BgTiler;
import egan.graphics.GraphicsUtils;
import egan.util.Utils;
import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

public class Syntheme
extends Applet
implements Runnable,
MouseListener {
    private static final long serialVersionUID = 1L;
    static final BasicStroke str1 = new BasicStroke(1.0f, 0, 2);
    static final BasicStroke str2 = new BasicStroke(1.5f, 0, 2);
    static final RenderingHints aaON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    static final RenderingHints aaOFF = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    long F = 0L;
    long pt = 0L;
    long tStep = 100L;
    boolean mouseIN = false;
    private volatile Thread a;
    Image I;
    Graphics o;
    Graphics2D o2;
    BgTiler bgt = null;
    Polyhedron ph;
    int NF;
    int NV;
    boolean pentad = true;
    Gon3D[] faceGons;
    int nduads;
    double[][] duadNorms;
    static final double tolerance = 1.0E-4;
    BSP bsp;
    PointManager pm;
    double[][] rotation = new double[3][3];
    static final int nshades = 4;
    Color[][] palette;
    double[] lum;
    int[][] sb = new int[2][];
    int[] xp = new int[10];
    int[] yp = new int[10];
    int wc;
    int hc;
    int rad;
    String statusString = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.addMouseListener(this);
        Thread thisThread = Thread.currentThread();
        while (this.a == thisThread) {
            long t = System.currentTimeMillis();
            Syntheme syntheme = this;
            synchronized (syntheme) {
                if (t - this.pt > this.tStep || t < this.pt) {
                    this.repaint();
                }
            }
            try {
                Thread.sleep(20L);
            }
            catch (Exception e) {
                break;
            }
        }
    }

    @Override
    public void start() {
        this.a = new Thread(this);
        this.a.start();
        this.a.setPriority(1);
    }

    @Override
    public void stop() {
        this.a = null;
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public synchronized void update(Graphics g) {
        long t = System.currentTimeMillis();
        if (t - this.pt >= this.tStep || t < this.pt) {
            this.pt = t;
            int w = this.getSize().width;
            int h = this.getSize().height;
            if (this.F == 0L) {
                int j;
                this.I = this.createImage(w, h);
                this.o = this.I.getGraphics();
                this.o2 = (Graphics2D)this.o;
                this.o2.setRenderingHints(aaON);
                this.o2.setStroke(str1);
                this.ph = Polyhedron.regularPolyhedron((int)4);
                double[][] vertices = this.ph.vertices;
                int nf = this.NF = this.ph.NF;
                int nv = this.NV = this.ph.NV;
                int[][] ev = this.ph.edge_vertices;
                int ne = this.ph.NE;
                int[] opp = new int[nv];
                block0: for (int j2 = 0; j2 < nv; ++j2) {
                    for (int k = 0; k < nv; ++k) {
                        if (k == j2) continue;
                        double dp = 0.0;
                        for (int l = 0; l < 3; ++l) {
                            dp += vertices[j2][l] * vertices[k][l];
                        }
                        if (!(Math.abs(dp + 1.0) < 1.0E-6)) continue;
                        opp[j2] = k;
                        continue block0;
                    }
                }
                this.faceGons = new Gon3D[nf];
                for (int jf = 0; jf < nf; ++jf) {
                    this.faceGons[jf] = this.ph.faceToGon3D(jf);
                }
                this.sb[0] = new int[nf];
                int nDL = 0;
                int[][] duadList = new int[15][4];
                int[] duadVertices = new int[15];
                for (int i = 0; i < ne; ++i) {
                    int v1 = ev[i][0];
                    int v2 = ev[i][1];
                    int v3 = opp[v1];
                    int v4 = opp[v2];
                    int vflags = 1 << v1 | 1 << v2 | 1 << v3 | 1 << v4;
                    boolean ok = true;
                    for (j = 0; j < nDL; ++j) {
                        if (vflags != duadVertices[j]) continue;
                        ok = false;
                        break;
                    }
                    if (!ok) continue;
                    int[] dl = new int[]{v1, v2, v3, v4};
                    duadList[nDL] = dl;
                    duadVertices[nDL++] = vflags;
                }
                int[][] synthList = new int[15][3];
                int nSL = 0;
                int[] synthDuads = new int[15];
                int[] dSet = new int[]{0, 1, 2};
                block6: while (true) {
                    int ic;
                    int dv;
                    int ic0;
                    int avoid = 0;
                    for (ic0 = 0; ic0 < 3 && (avoid & (dv = duadVertices[dSet[ic0]])) == 0; ++ic0) {
                        avoid |= dv;
                    }
                    if (ic0 == 3) {
                        ic0 = 2;
                        int sd = 0;
                        for (j = 0; j < 3; ++j) {
                            int dsj;
                            synthList[nSL][j] = dsj = dSet[j];
                            sd |= 1 << dsj;
                        }
                        synthDuads[nSL] = sd;
                        if (++nSL == 15) break;
                    }
                    for (ic = ic0; ic >= 0; --ic) {
                        int n = ic;
                        dSet[n] = dSet[n] + 1;
                        if (dSet[n] < nDL - 2 + ic) break;
                    }
                    int i = ic + 1;
                    while (true) {
                        if (i >= 3) continue block6;
                        dSet[i] = dSet[i - 1] + 1;
                        ++i;
                    }
                    break;
                }
                int[][] pentadList = new int[6][5];
                int nPL = 0;
                int[] sSet = new int[]{0, 1, 2, 3, 4};
                block11: while (true) {
                    int ic;
                    int sd;
                    int ic0;
                    int avoid = 0;
                    for (ic0 = 0; ic0 < 5 && (avoid & (sd = synthDuads[sSet[ic0]])) == 0; ++ic0) {
                        avoid |= sd;
                    }
                    if (ic0 == 5) {
                        ic0 = 4;
                        for (int j3 = 0; j3 < 5; ++j3) {
                            pentadList[nPL][j3] = sSet[j3];
                        }
                        if (++nPL == 6) break;
                    }
                    for (ic = ic0; ic >= 0; --ic) {
                        int n = ic;
                        sSet[n] = sSet[n] + 1;
                        if (sSet[n] < nSL - 4 + ic) break;
                    }
                    int i = ic + 1;
                    while (true) {
                        if (i >= 5) continue block11;
                        sSet[i] = sSet[i - 1] + 1;
                        ++i;
                    }
                    break;
                }
                this.pentad = !this.pentad;
                int nsynthemes = this.pentad ? 5 : 1;
                this.nduads = 3 * nsynthemes;
                int[][] duads = new int[this.nduads][];
                int nd = 0;
                int ipent = (int)(6.0 * Math.random());
                for (int i = 0; i < nsynthemes; ++i) {
                    int isynth = this.pentad ? pentadList[ipent][i] : (int)(15.0 * Math.random());
                    for (int j4 = 0; j4 < 3; ++j4) {
                        duads[nd++] = duadList[synthList[isynth][j4]];
                    }
                }
                this.duadNorms = new double[this.nduads][];
                Gon3D[] duadGons = new Gon3D[this.nduads];
                for (int jd = 0; jd < this.nduads; ++jd) {
                    int[] si = duads[jd];
                    double[][] vt = new double[4][];
                    for (int i = 0; i < 4; ++i) {
                        vt[i] = vertices[si[i]];
                    }
                    Gon3D gnd = duadGons[jd] = new Gon3D((double[][])vt, 4);
                    gnd.surfaceID = jd;
                    gnd.setEdgeIDs();
                    this.duadNorms[jd] = gnd.plane();
                }
                this.sb[1] = new int[this.nduads];
                this.pm = new PointManager(3, 1.0E-4);
                this.bsp = new BSP(3, this.duadNorms[0], 0, 1.0E-4, this.pm, (BSPobject)duadGons[0]);
                for (int i = 1; i < this.nduads; ++i) {
                    this.bsp.add((BSPobject)duadGons[i], this.duadNorms[i], i, true);
                }
                int ncols = this.pentad ? 5 : 4;
                this.palette = GraphicsUtils.randomPalette((int)ncols, (int)4, (int)(this.pentad ? 0 : 2));
                if (!this.pentad) {
                    this.palette[0][0] = new Color(this.palette[0][0].getRGB() & 0xFFFFFF | 0xAA000000, true);
                    this.palette[0][1] = new Color(this.palette[0][0].getRGB() & 0xFFFFFF | 0xAA000000, true);
                }
                Utils.setRotation((double[][])this.rotation, (double)(0.03 * (2.0 + Math.random())), (double[])Utils.randomUnitVec(null, (boolean)false), (double)1.0);
                this.lum = Utils.randomUnitVec(null, (boolean)true);
                this.wc = w / 2;
                this.hc = h / 2;
                this.rad = Math.min(this.wc, this.hc) - 4;
            }
            this.ph.transform(this.rotation, 1.0);
            for (int jx = 0; jx < this.nduads; ++jx) {
                Utils.transform((double[][])this.rotation, (double[])this.duadNorms[jx]);
            }
            this.pm.transform(this.rotation);
            if (this.bgt == null) {
                this.bgt = new BgTiler((Applet)this, w, h);
            }
            this.d(this.o, w, h, this.bgt.tile(this.o));
            g.drawImage(this.I, 0, 0, null);
            this.maybeShowStatus(g);
            ++this.F;
        }
    }

    public void d(Graphics g, int w, int h, boolean TB) {
        if (!TB) {
            g.setColor(Color.white);
            g.fillRect(0, 0, w, h);
        }
        int nv = this.NV;
        int nf = this.NF;
        double[][] vertices = this.ph.vertices;
        int[] nsurfaces = new int[]{nf, this.nduads};
        double[][][] surfaceNorms = new double[][][]{this.ph.faces, this.duadNorms};
        for (int i = 0; i < 2; ++i) {
            int nsf = nsurfaces[i];
            for (int j = 0; j < nsf; ++j) {
                double[] norm = surfaceNorms[i][j];
                double ndl = 0.0;
                for (int k = 0; k < 3; ++k) {
                    ndl += norm[k] * this.lum[k];
                }
                double brightness = this.lum[2] - 2.0 * ndl * norm[2];
                this.sb[i][j] = brightness < 0.1 ? 1 : (brightness > 0.6 ? 3 : 2);
            }
        }
        int pA = 0;
        int pB = 3;
        if (this.pentad) {
            pB = 2;
            pA = 2;
        }
        for (int pass = pA; pass <= pB; ++pass) {
            if (pass == 2) {
                this.renderBSP(g, this.bsp);
                continue;
            }
            boolean doFront = pass == 0 || pass == 3;
            boolean doBorders = pass == 1 || pass == 3;
            for (int jf = 0; jf < nf; ++jf) {
                boolean front;
                boolean bl = front = this.ph.faces[jf][2] > 0.0;
                if (front && !doFront || !front && doFront) continue;
                this.renderGon(g, this.faceGons[jf], doBorders ? null : this.palette[0][this.sb[0][jf]], doBorders ? this.palette[0][front ? 0 : 3] : null);
            }
        }
    }

    private void renderGon(Graphics g, Gon3D gnd, Color faceCol, Color borderCol) {
        double[][] vtx = gnd.vertices;
        int nv = gnd.nvert;
        int mv = nv + 1;
        for (int i = 0; i < mv; ++i) {
            int j = i % nv;
            this.xp[i] = this.wc + (int)((double)this.rad * vtx[j][0]);
            this.yp[i] = this.hc + (int)((double)this.rad * vtx[j][1]);
        }
        if (faceCol != null) {
            g.setColor(faceCol);
            g.fillPolygon(this.xp, this.yp, nv);
        }
        if (borderCol != null) {
            g.setColor(borderCol);
            g.drawPolygon(this.xp, this.yp, mv);
        }
    }

    private void renderSegment(Graphics g, Gon3D gnd) {
        int si = gnd.surfaceID;
        if ((long)si > this.F / 8L) {
            return;
        }
        Color[] cols = this.palette[this.pentad ? si / 3 : 1 + si];
        Color faceCol = cols[this.sb[1][si]];
        Color edgeCol = cols[0];
        this.renderGon(g, gnd, faceCol, null);
        Graphics2D g2 = (Graphics2D)g;
        for (int pass = 0; pass < 2; ++pass) {
            int nv = gnd.nvert;
            int[] eid = gnd.edgeIDs;
            for (int ie = 0; ie < nv; ++ie) {
                boolean normalEdge;
                int je = ie + 1;
                int ei = eid[ie];
                boolean bl = normalEdge = (ei & 0x44000000) != 0;
                if (pass == 0 && normalEdge || pass == 1 && !normalEdge) continue;
                g.setColor(normalEdge ? edgeCol : faceCol);
                if (!normalEdge) {
                    g2.setRenderingHints(aaOFF);
                    g2.setStroke(str2);
                }
                g.drawLine(this.xp[ie], this.yp[ie], this.xp[je], this.yp[je]);
                if (normalEdge) continue;
                g2.setRenderingHints(aaON);
                g2.setStroke(str1);
            }
        }
    }

    private void renderBSP(Graphics g, BSP bsp) {
        BSP back = null;
        BSP front = null;
        if (bsp.svec != null) {
            int ib = bsp.svec[2] > 0.0 ? 0 : 1;
            back = bsp.npBSP[ib];
            front = bsp.npBSP[1 - ib];
        }
        if (back != null) {
            this.renderBSP(g, back);
        }
        Vector contents = bsp.contents;
        int nc = contents.size();
        for (int ic = 0; ic < nc; ++ic) {
            this.renderSegment(g, (Gon3D)contents.elementAt(ic));
        }
        if (front != null) {
            this.renderBSP(g, front);
        }
    }

    @Override
    public void showStatus(String s) {
        super.showStatus(s);
        this.statusString = s;
    }

    void maybeShowStatus(Graphics g) {
        if (this.statusString.length() != 0) {
            GraphicsUtils.showStatus((String)this.statusString, (Graphics)g, (Component)this);
        }
    }

    @Override
    public synchronized void mouseEntered(MouseEvent e) {
        this.mouseIN = true;
        this.showStatus("Click to redraw");
    }

    @Override
    public synchronized void mouseExited(MouseEvent e) {
        this.mouseIN = false;
        this.showStatus("");
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        this.F = 0L;
        this.mouseEntered(null);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

