/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.applets.CellEdgeVector;
import egan.applets.CellFace;
import java.util.BitSet;

public class CellEdge {
    BitSet line;
    BitSet endPoint1;
    BitSet endPoint2;
    CellFace[] cellFaces;
    int[] edgeNum;
    int nPlanes;
    int[] planes;
    int flags;
    int matchDir;
    static CellEdgeVector[][][] ce;

    public CellEdge(BitSet line, BitSet endPoint1, BitSet endPoint2) {
        this.line = line;
        this.endPoint1 = endPoint1;
        this.endPoint2 = endPoint2;
        this.cellFaces = new CellFace[2];
        this.edgeNum = new int[2];
        this.nPlanes = 0;
        int np = line.size();
        for (int i = 0; i < np; ++i) {
            if (!line.get(i)) continue;
            ++this.nPlanes;
        }
        this.planes = new int[this.nPlanes];
        int ip = 0;
        for (int i = 0; i < np; ++i) {
            if (!line.get(i)) continue;
            this.planes[ip++] = i;
        }
    }

    public int matches(BitSet v1, BitSet v2) {
        if (this.endPoint1.equals(v1) && this.endPoint2.equals(v2)) {
            return 1;
        }
        if (this.endPoint1.equals(v2) && this.endPoint2.equals(v1)) {
            return -1;
        }
        return 0;
    }

    public static void clearStorage() {
        ce = null;
    }

    static CellEdgeVector ceVector(int jf, BitSet line) {
        CellEdgeVector[][] root;
        int nf = line.size();
        if (ce == null) {
            ce = new CellEdgeVector[nf][][];
        }
        if ((root = ce[jf]) == null) {
            root = new CellEdgeVector[nf][];
            CellEdge.ce[jf] = root;
            for (int i = 1; i < nf; ++i) {
                root[i] = new CellEdgeVector[i];
                CellEdgeVector[] ri = root[i];
                for (int j = 0; j < i; ++j) {
                    ri[j] = new CellEdgeVector(1, 1);
                }
            }
        }
        int m1 = -1;
        int m2 = -1;
        for (int k = 0; k < nf; ++k) {
            if (!line.get(k)) continue;
            m2 = m1;
            m1 = k;
        }
        return root[m1][m2];
    }

    public static CellEdge newCellEdge(int jf, BitSet line, BitSet pt1, BitSet pt2) {
        CellEdgeVector celVec = CellEdge.ceVector(jf, line);
        CellEdge cEdge = new CellEdge(line, pt1, pt2);
        celVec.addElement(cEdge);
        return cEdge;
    }

    public static CellEdge findCellEdge(int jf, BitSet line, BitSet pt1, BitSet pt2) {
        CellEdgeVector celVec = CellEdge.ceVector(jf, line);
        int ncv = celVec.size();
        int mdir = 0;
        CellEdge cEdge = null;
        for (int icv = 0; icv < ncv && (mdir = (cEdge = celVec.elementAt(icv)).matches(pt1, pt2)) == 0; ++icv) {
        }
        if (mdir == 0) {
            cEdge = null;
        }
        if (cEdge != null) {
            cEdge.matchDir = mdir;
        }
        return cEdge;
    }
}

