/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.geometry.Polyhedron;
import egan.geometry.SphericalTriangle;
import egan.graphics.BgTiler;
import egan.graphics.GraphicsUtils;
import egan.util.Utils;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class Crystalline
extends Applet
implements Runnable,
MouseListener {
    private static final long serialVersionUID = 1L;
    long F = 0L;
    long pt = 0L;
    long tStep = 100L;
    private volatile Thread a;
    Image I;
    Graphics o;
    BgTiler bgt = null;
    int par = -1;
    boolean mouseIN = false;
    String[] msg = new String[]{"Tetrahedral", "Cubic", "Icosahedral"};
    double toler = 1.0E-6;
    SphericalTriangle[] tiles;
    int ntiles;
    double[][] rotation = new double[3][3];
    double[] axis;
    double[][] rotation2 = new double[3][3];
    double[][] offsets;
    Polyhedron ph;
    double[][] faces;
    double[] f0;
    double[] sb;
    boolean[] sf;
    double[] lum;
    static final int nshades = 3;
    Color[][] palette;
    int[][] xp;
    int[][] yp;
    String statusString = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.addMouseListener(this);
        Thread thisThread = Thread.currentThread();
        while (this.a == thisThread) {
            long t = System.currentTimeMillis();
            Crystalline crystalline = this;
            synchronized (crystalline) {
                if (t - this.pt > this.tStep || t < this.pt) {
                    this.repaint();
                }
            }
            try {
                Thread.sleep(20L);
            }
            catch (Exception e) {
                break;
            }
        }
    }

    @Override
    public void start() {
        this.a = new Thread(this);
        this.a.start();
        this.a.setPriority(1);
    }

    @Override
    public void stop() {
        this.a = null;
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public synchronized void update(Graphics g) {
        long t = System.currentTimeMillis();
        if (t - this.pt >= this.tStep || t < this.pt) {
            this.pt = t;
            int w = this.getSize().width;
            int h = this.getSize().height;
            if (this.F == 0L) {
                this.I = this.createImage(w, h);
                this.o = this.I.getGraphics();
                GraphicsUtils.setAA((Graphics)this.o);
                int[][][] pars = new int[][][]{new int[][]{{1, 3}, {1, 2}, {1, 3}, {1, 24}}, new int[][]{{1, 3}, {1, 2}, {1, 4}, {1, 48}}, new int[][]{{1, 5}, {1, 2}, {1, 3}, {1, 120}}};
                int ni = pars.length;
                this.par = this.par < 0 ? (int)((double)ni * Math.random()) : (this.par + 1) % ni;
                int[][] pp = pars[this.par];
                int mf = pp[0][1];
                int ns = pp[2][1];
                int[][] vA = new int[][]{{1, mf}, {1, 2}, {1, ns}};
                SphericalTriangle canonical = new SphericalTriangle((int[][])vA);
                this.tiles = canonical.tiling(pp[3][1]);
                this.ntiles = this.tiles.length;
                this.f0 = null;
                Utils.setRotation((double[][])this.rotation, (double)(0.02 * (2.0 + Math.random())), (double[])Utils.randomUnitVec(null, (boolean)false), (double)1.0);
                this.axis = Utils.randomUnitVec(null, (boolean)false);
                this.faces = new double[this.ntiles][4];
                this.sb = new double[this.ntiles];
                this.sf = new boolean[this.ntiles];
                this.lum = Utils.randomUnitVec(null, (boolean)false);
                this.xp = new int[this.ntiles][50];
                this.yp = new int[this.ntiles][50];
            }
            if (this.f0 == null) {
                this.f0 = Utils.randomUnitVec(null, (boolean)false);
                this.palette = GraphicsUtils.randomPalette((int)2, (int)3, (int)1);
                this.offsets = new double[this.ntiles][3];
                for (int i = 0; i < this.ntiles; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        this.offsets[i][j] = Math.random();
                    }
                }
            }
            Utils.transform((double[][])this.rotation, (double[])this.f0);
            for (int i = 0; i < this.ntiles; ++i) {
                Utils.transform((double[][])this.tiles[i].isometry, (double[])this.f0, (double[])this.faces[i]);
                this.faces[i][3] = 3.0 + this.offsets[i][0] + this.offsets[i][1] * Math.cos(this.offsets[i][2] * (double)this.F / 2000.0);
            }
            this.ph = new Polyhedron(this.faces, this.ntiles, this.toler, false, false);
            if (this.ph.NF == 0 || this.ph.NV == 0) {
                this.f0 = null;
                return;
            }
            double max = 0.0;
            for (int i = 0; i < this.ph.NV; ++i) {
                double mag = Math.sqrt(Utils.dot((double[])this.ph.vertices[i], (double[])this.ph.vertices[i]));
                if (!(mag > max)) continue;
                max = mag;
            }
            Utils.setRotation((double[][])this.rotation2, (double)((double)this.F * 0.1), (double[])this.axis, (double)1.0);
            this.ph.transform(this.rotation2, 1.0 / max);
            if (this.bgt == null) {
                this.bgt = new BgTiler((Applet)this, w, h);
            }
            this.d(this.o, w, h, this.bgt.tile(this.o));
            g.drawImage(this.I, 0, 0, null);
            this.maybeShowStatus(g);
            ++this.F;
        }
    }

    public void d(Graphics g, int w, int h, boolean TB) {
        int wc = w / 2;
        int hc = h / 2;
        int rad = Math.min(wc, hc) - 4;
        if (!TB) {
            g.setColor(Color.white);
            g.fillRect(0, 0, w, h);
        }
        int nf = this.ph.NF;
        for (int jf = 0; jf < nf; ++jf) {
            double brightness;
            double[] norm = this.ph.faces[jf];
            this.sf[jf] = norm[2] > 0.0;
            double ndl = 0.0;
            for (int i = 0; i < 3; ++i) {
                ndl += norm[i] * this.lum[i];
            }
            this.sb[jf] = brightness = this.lum[2] - 2.0 * ndl * norm[2];
        }
        for (int i = 0; i < nf; ++i) {
            int gn = this.ph.face_vertices[i].length;
            int[] xpi = this.xp[i];
            int[] ypi = this.yp[i];
            for (int j = 0; j <= gn; ++j) {
                double[] gk = this.ph.vertices[this.ph.face_vertices[i][j % gn]];
                xpi[j] = (int)((double)wc + (double)rad * gk[0]);
                ypi[j] = (int)((double)hc + (double)rad * gk[1]);
            }
        }
        for (int pass = 0; pass <= 2; ++pass) {
            for (int i = 0; i < nf; ++i) {
                double brightness = this.sb[i];
                boolean front = this.sf[i];
                boolean back = !front;
                int gn = this.ph.face_vertices[i].length;
                if (pass == 0 && front) {
                    g.setColor(this.palette[0][back ? 0 : (brightness > 0.6 ? 2 : 1)]);
                    g.fillPolygon(this.xp[i], this.yp[i], gn);
                    continue;
                }
                if ((pass != 1 || !back) && (pass != 2 || !front)) continue;
                g.setColor(this.palette[0][front ? 0 : 2]);
                g.drawPolygon(this.xp[i], this.yp[i], gn + 1);
            }
        }
        if (this.F == 0L && this.mouseIN) {
            this.mouseEntered(null);
        }
    }

    @Override
    public void showStatus(String s) {
        super.showStatus(s);
        this.statusString = s;
    }

    void maybeShowStatus(Graphics g) {
        if (this.statusString.length() != 0) {
            GraphicsUtils.showStatus((String)this.statusString, (Graphics)g, (Component)this);
        }
    }

    @Override
    public synchronized void mouseEntered(MouseEvent e) {
        this.mouseIN = true;
        this.showStatus(this.msg[this.par] + " orbits; click to redraw");
    }

    @Override
    public synchronized void mouseExited(MouseEvent e) {
        this.mouseIN = false;
        this.showStatus("");
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        this.F = 0L;
        this.mouseIN = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

