/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.graphics.GraphicsUtils;
import egan.util.Utils;
import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class Dirac
extends Applet
implements Runnable,
MouseListener {
    private static final long serialVersionUID = 1L;
    boolean mouseIN = false;
    Image I;
    Graphics G;
    long F = 0L;
    long tStep = 120L;
    long pt;
    private volatile Thread a;
    int moveSign = 1;
    static final BasicStroke str = new BasicStroke(1.0f, 0, 2);
    static final BasicStroke strBig = new BasicStroke(4.0f, 0, 2);
    static final RenderingHints aaON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    static final RenderingHints aaOFF = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    static final int nsegs = 150;
    static final int nstrips = 10;
    static final int npieces = 1500;
    double[][] segRotations = new double[151][3];
    double[][] segCentres = new double[1500][4];
    int[] surface = new int[150];
    int[] shade = new int[150];
    double[][][] xyz = new double[151][11][3];
    int[][][] sxy = new int[2][151][11];
    int[] bx;
    int[] by;
    double[][] vp = new double[][]{{0.707, -0.707, 0.0}, {0.407939, 0.407939, 0.815878}, {-0.577, -0.577, 0.577}};
    static final int nshades = 3;
    Color[][] palette;
    double[] lum;
    double dpViewerIllum;
    Font fnt = null;
    FontMetrics fm = null;
    int fh;
    int fd;
    int soRad;
    int soDiam;
    int sotw;
    int sox;
    int soy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.addMouseListener(this);
        Thread thisThread = Thread.currentThread();
        while (this.a == thisThread) {
            long t = System.currentTimeMillis();
            Dirac dirac = this;
            synchronized (dirac) {
                if (t - this.pt > this.tStep || t < this.pt) {
                    this.repaint();
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (Exception e) {
                break;
            }
        }
    }

    @Override
    public void start() {
        this.a = new Thread(this);
        this.a.start();
        this.a.setPriority(1);
    }

    @Override
    public void stop() {
        this.a = null;
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public synchronized void update(Graphics g) {
        long t = System.currentTimeMillis();
        if (t - this.pt > this.tStep || t < this.pt) {
            this.pt = t;
            int w = this.getSize().width;
            int h = this.getSize().height;
            if (this.F == 0L) {
                this.I = this.createImage(w, h);
                this.G = this.I.getGraphics();
            }
            Graphics2D g2 = (Graphics2D)this.G;
            this.d(g2, w, h, this.F);
            g.drawImage(this.I, 0, 0, null);
            ++this.F;
        }
    }

    public void d(Graphics2D g, int w, int h, long f) {
        int i;
        int ii;
        int f1 = 60;
        int f2 = 65;
        int f3 = 155;
        boolean stage1 = false;
        boolean stage2 = false;
        boolean stage3 = false;
        boolean stage4 = false;
        double lambda = 0.0;
        String[] description = new String[]{"First, give the belt two full twists.", null, "Next, remove the kink without moving the ends.", "Finished.  Click to redraw."};
        int dindx = 1;
        String eobTxt1 = "End of belt has been rotated by ";
        String eobTxt2 = " deg";
        int margin = 5;
        String soText = "Path through SO(3)";
        double scale = 0.8 * (double)Math.min(w, h);
        int xc = w / 2;
        int yc = h / 2;
        double ssc = scale / 15.0;
        if (f == 0L) {
            this.palette = GraphicsUtils.randomPalette((int)2, (int)3, (int)0);
            double[] ll = Utils.randomUnitVec(null, (boolean)true);
            this.lum = ll;
            this.dpViewerIllum = 0.0;
            for (int k = 0; k < 3; ++k) {
                this.dpViewerIllum += ll[k] * this.vp[2][k];
            }
            this.bx = new int[60];
            this.by = new int[60];
            String fontName = GraphicsUtils.getNiceFont((Component)this);
            for (int fsize = 24; fsize > 4; fsize -= 2) {
                boolean ok = true;
                this.fnt = new Font(fontName, 0, fsize);
                this.fm = this.getFontMetrics(this.fnt);
                this.fh = this.fm.getAscent();
                this.fd = this.fm.getDescent();
                for (int i2 = 0; i2 < 4; ++i2) {
                    if (description[i2] == null || this.fm.stringWidth(description[i2]) <= w - 5) continue;
                    ok = false;
                    break;
                }
                this.soRad = (int)(ssc * Math.PI);
                this.soDiam = 2 * this.soRad + 1;
                this.sotw = this.fm.stringWidth(soText);
                this.sox = w - 5 - Math.max(this.soRad, this.sotw / 2);
                this.soy = h - 5 - this.soRad - this.fh - this.fd;
                if (15 + this.fm.stringWidth(eobTxt1 + "720" + eobTxt2) > this.sox - this.sotw / 2) {
                    ok = false;
                }
                if (ok) break;
            }
        }
        if (f < 60L) {
            stage1 = true;
            dindx = 0;
        } else if (f < 65L) {
            stage2 = true;
            dindx = 1;
        } else if (f < 155L) {
            stage3 = true;
            dindx = 2;
        } else if (f == 155L) {
            stage4 = true;
            dindx = 3;
        } else {
            return;
        }
        boolean stageA = stage1 || stage2;
        boolean stageB = stage3 || stage4;
        g.setFont(this.fnt);
        g.setColor(Color.white);
        g.fillRect(0, 0, w, h);
        g.addRenderingHints(aaON);
        g.setStroke(str);
        double[] right = this.vp[0];
        double[] up = this.vp[1];
        double[] toViewer = this.vp[2];
        double[][] segR = this.segRotations;
        int[][] sx = this.sxy[0];
        int[][] sy = this.sxy[1];
        int farEndDeg = 0;
        double sigma = stage1 ? (double)f / 59.0 : 1.0;
        double farEndRad = Math.PI * 4 * sigma;
        farEndDeg = (int)Math.round(720.0 * sigma);
        double spScale = scale / 10.0;
        int spRad = (int)spScale;
        int spDiam = 2 * spRad;
        String spText = "Spinor state";
        int sptw = this.fm.stringWidth(spText);
        int spx = w - 5 - Math.max(spRad, sptw / 2);
        int spy = this.fh + 15 + spRad;
        int spy2 = spy + 5 + spDiam;
        g.setColor(new Color(0xCCCCCC));
        g.drawOval(spx - spRad, spy - spRad, spDiam, spDiam);
        g.drawOval(spx - spRad, spy2 - spRad, spDiam, spDiam);
        g.setColor(Color.black);
        g.drawLine(spx, spy, spx + (int)(spScale * Math.cos(farEndRad / 2.0)), spy);
        g.drawLine(spx, spy2, spx, spy2 + (int)(spScale * Math.sin(farEndRad / 2.0)));
        g.drawString(spText, spx - sptw / 2, spy2 + spRad + this.fh);
        lambda = stageB ? Math.min(1.0, (double)(f - 65L) / 89.0) : 0.0;
        double phi = 0.7853981633974483;
        double theta = Math.PI * lambda;
        double sinTheta = Math.sin(theta);
        double[] startAxis = new double[]{-1.0, 0.0, 0.0};
        double[] midAxis = new double[]{Math.cos(theta), sinTheta * Math.cos(phi), sinTheta * Math.sin(phi)};
        double[] rotAxis = new double[]{1.0, 0.0, 0.0};
        g.setColor(new Color(0x999999));
        if (stage1) {
            int i3 = 1;
            while ((long)i3 < f) {
                if (i3 == 30) {
                    g.setColor(new Color(0x333333));
                }
                g.drawLine(this.bx[i3 - 1], this.by[i3 - 1], this.bx[i3], this.by[i3]);
                ++i3;
            }
        }
        g.setColor(new Color(0xCCCCCC));
        g.fillOval(this.sox - this.soRad, this.soy - this.soRad, this.soDiam, this.soDiam);
        g.setColor(Color.black);
        g.drawString(soText, this.sox - this.sotw / 2, this.soy + this.soRad + this.fh);
        int px = -1;
        int py = 0;
        boolean doneSH = false;
        for (int i4 = 0; i4 <= 150; ++i4) {
            double aonPI;
            double[] segRi = segR[i4];
            double mu = 2.0 * (double)Math.min(149, i4) / 149.0;
            if (stageA) {
                double d;
                aonPI = -1.0 + 2.0 * mu * sigma;
                if (d > 1.0) {
                    aonPI -= 2.0;
                }
            } else {
                boolean secondHalf = mu > 1.0;
                if (secondHalf) {
                    mu = 2.0 - mu;
                    if (!doneSH) {
                        doneSH = true;
                        px = -1;
                    }
                }
                double omu = 1.0 - mu;
                double magsq = 0.0;
                for (int k = 0; k < 3; ++k) {
                    double rk = mu * midAxis[k] + omu * startAxis[k];
                    magsq += rk * rk;
                    rotAxis[k] = rk;
                }
                double mag = Math.sqrt(magsq);
                if (mag > 0.0) {
                    int k = 0;
                    while (k < 3) {
                        int n = k++;
                        rotAxis[n] = rotAxis[n] / mag;
                    }
                }
                aonPI = secondHalf ? -mag : mag;
            }
            double angle = Math.PI * aonPI;
            double s1 = Math.sin(angle);
            double c1 = Math.cos(angle);
            for (int l = 0; l < 3; ++l) {
                segRi[l] = (1.0 - c1) * rotAxis[l] * rotAxis[1] + (l == 1 ? c1 : (double)((l + 4 - 1) % 3 - 1) * s1 * rotAxis[3 - l - 1]);
            }
            int x = this.sox + (int)(ssc * rotAxis[0] * angle);
            int y = this.soy - (int)(ssc * rotAxis[2] * angle);
            if (px > -1) {
                g.drawLine(x, y, px, py);
            }
            if (i4 == 0 || i4 == 150) {
                g.fillOval(x - 1, y - 1, 3, 3);
            }
            px = x;
            py = y;
        }
        double BeltWidth = 0.1;
        double StripWidth = 0.01;
        double HalfBelt = 0.05;
        double[][] pxyz = new double[2][3];
        double[] e1 = new double[3];
        double par = Math.sin(lambda * Math.PI);
        par *= par;
        double omp = 1.0 - par;
        double sdev = 0.4 * Math.sin(lambda * 2.0 * Math.PI);
        int cenStrip = 5;
        for (int i5 = 0; i5 <= 150; ++i5) {
            double[] segRi = segR[i5];
            double[][] xyzi = this.xyz[i5];
            int[] sxi = sx[i5];
            int[] syi = sy[i5];
            double mu = (double)Math.min(149, i5) / 149.0;
            double omu = 1.0 - mu;
            double a1 = Math.PI * omu;
            double a2 = 2.0 * a1;
            double[] sc = xyzi[cenStrip];
            sc[0] = i5 == 150 ? this.xyz[i5 - 1][cenStrip][0] + 0.1 : 1.35 * (par * (0.5 - omu * Math.cos(a2)) + omp * (0.5 - omu)) - 0.4;
            sc[1] = (double)(-this.moveSign) * sdev * Math.sin(a1);
            sc[2] = (double)this.moveSign * 0.8 * (par * omu + omp) * (-0.4 * Math.sin(a2));
            for (int s = 0; s <= 10; ++s) {
                double[] pt = xyzi[s];
                double stripPar = 0.05 - (double)s * 0.01;
                double xx = 0.0;
                double yy = 0.0;
                for (int k = 0; k < 3; ++k) {
                    double ptk = pt[k] = sc[k] + stripPar * segRi[k];
                    xx += right[k] * ptk;
                    yy += up[k] * ptk;
                }
                sxi[s] = xc + (int)(scale * xx);
                syi[s] = yc - (int)(scale * yy);
            }
            if (i5 <= 0) continue;
            double[] st = this.xyz[i5 - 1][cenStrip];
            for (int k = 0; k < 3; ++k) {
                e1[k] = sc[k] - st[k];
            }
            double magsq = 0.0;
            double dpViewerNorm = 0.0;
            double dpIllumNorm = 0.0;
            for (int k = 0; k < 3; ++k) {
                int l = (k + 1) % 3;
                int m = (k + 2) % 3;
                double nk = e1[l] * segRi[m] - e1[m] * segRi[l];
                double vk = toViewer[k];
                double lk = this.lum[k];
                magsq += nk * nk;
                dpViewerNorm += nk * vk;
                dpIllumNorm += nk * lk;
            }
            this.surface[i5 - 1] = dpViewerNorm < 0.0 ? 0 : 1;
            this.shade[i5 - 1] = Math.max(0, (int)(3.0 * (this.dpViewerIllum - 2.0 * dpIllumNorm * dpViewerNorm / magsq)));
        }
        if (stage1) {
            int j = (int)f;
            this.bx[j] = sx[150][0];
            this.by[j] = sy[150][0];
        }
        double loZ = Double.POSITIVE_INFINITY;
        double hiZ = Double.NEGATIVE_INFINITY;
        for (ii = 0; ii < 1500; ++ii) {
            int s;
            double[] sgc = this.segCentres[ii];
            if (f == 0L) {
                i = ii / 10;
                sgc[0] = i;
                s = ii % 10;
                sgc[1] = s;
            } else {
                i = (int)sgc[0];
                s = (int)sgc[1];
            }
            double[] pt = this.xyz[i][s];
            double zz = 0.0;
            for (int k = 0; k < 3; ++k) {
                zz += toViewer[k] * pt[k];
            }
            sgc[3] = zz;
            loZ = Math.min(zz, loZ);
            hiZ = Math.max(zz, hiZ);
        }
        Utils.qs((int)3, (double[][])this.segCentres, (int)0, (int)1499, (double)loZ, (double)hiZ);
        for (ii = 0; ii < 1500; ++ii) {
            boolean buckle;
            double[] sgc = this.segCentres[ii];
            i = (int)sgc[0];
            int s = (int)sgc[1];
            boolean bl = buckle = i == 149;
            if (buckle) {
                g.setStroke(strBig);
            } else {
                g.setStroke(str);
            }
            int[] sxi = sx[i];
            int[] syi = sy[i];
            int[] sxip = sx[i + 1];
            int[] syip = sy[i + 1];
            int[] segX = new int[]{sxi[s], sxi[s + 1], sxip[s + 1], sxip[s]};
            int[] segY = new int[]{syi[s], syi[s + 1], syip[s + 1], syip[s]};
            if (!buckle) {
                g.setColor(this.palette[this.surface[i]][this.shade[i]]);
                g.addRenderingHints(aaOFF);
                g.fillPolygon(segX, segY, 4);
                g.addRenderingHints(aaON);
            }
            g.setColor(Color.black);
            if (s == 0 || buckle && s == 5) {
                g.drawLine(segX[0], segY[0], segX[3], segY[3]);
            }
            if (s == 9) {
                g.drawLine(segX[1], segY[1], segX[2], segY[2]);
            }
            if (i == 0) {
                g.drawLine(segX[0], segY[0], segX[1], segY[1]);
                continue;
            }
            if (!buckle && i != 148) continue;
            g.drawLine(segX[2], segY[2], segX[3], segY[3]);
        }
        g.setColor(Color.black);
        if (!stage4) {
            g.drawString(eobTxt1 + Integer.toString(farEndDeg) + eobTxt2, 5, this.moveSign == 1 ? h - 5 - this.fd : 2 * this.fh + this.fd + 5);
        }
        if (description[dindx] != null) {
            g.drawString(description[dindx], 5, this.fh + 5);
        }
    }

    @Override
    public synchronized void mouseEntered(MouseEvent e) {
        this.mouseIN = true;
        this.showStatus("Click to redraw");
    }

    @Override
    public synchronized void mouseExited(MouseEvent e) {
        this.mouseIN = false;
        this.showStatus("");
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        this.F = 0L;
        this.moveSign = -this.moveSign;
        this.mouseEntered(null);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

