/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.applets.GirihTile;
import egan.graphics.GraphicsUtils;
import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Random;
import java.util.Vector;

public class Girih
extends Applet
implements Runnable,
MouseListener {
    private static final long serialVersionUID = 1L;
    long F = 0L;
    long pt = 0L;
    long tStep = 100L;
    boolean mouseIN = false;
    private volatile Thread a;
    Image I;
    Graphics o;
    Vector<GirihTile> gts0;
    Vector<GirihTile> gts1;
    int tp = 0;
    int seedType = 2;
    boolean showStraps = true;
    static final RenderingHints aaON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    Color[][] cols;
    static final int framesPerStep = 50;
    String statusString = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.addMouseListener(this);
        Thread thisThread = Thread.currentThread();
        while (this.a == thisThread) {
            long t = System.currentTimeMillis();
            Girih girih = this;
            synchronized (girih) {
                if (t - this.pt > this.tStep || t < this.pt) {
                    this.repaint();
                }
            }
            try {
                Thread.sleep(20L);
            }
            catch (Exception e) {
                break;
            }
        }
    }

    @Override
    public void start() {
        this.a = new Thread(this);
        this.a.start();
        this.a.setPriority(1);
    }

    @Override
    public void stop() {
        this.a = null;
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public synchronized void update(Graphics g) {
        long t = System.currentTimeMillis();
        if (t - this.pt >= this.tStep || t < this.pt) {
            this.pt = t;
            int w = this.getSize().width;
            int h = this.getSize().height;
            if (this.F == 0L) {
                this.showStraps = !this.showStraps;
                if (!this.showStraps) {
                    ++this.seedType;
                }
                this.I = this.createImage(w, h);
                this.o = this.I.getGraphics();
                this.o.translate(w / 2, h / 2);
                GirihTile.setup();
                int tc = 1 + (this.seedType - 1) % 3;
                Random r = new Random();
                double cx = 0.04 * r.nextDouble() * (double)w;
                double cy = 0.02 * r.nextDouble() * (double)h;
                GirihTile seed = new GirihTile(cx, cy, this.showStraps ? 60.0 : 40.0, 0, tc, this.showStraps ? 1 : 0);
                this.gts0 = new Vector(1);
                this.gts0.add(seed);
                seed.edges(this.gts0);
                this.tp = 0;
                float hue = r.nextFloat();
                float incHue = 0.1f + 0.4f * r.nextFloat();
                this.cols = new Color[5][50];
                for (int i = 0; i < 5; ++i) {
                    int rr;
                    int gg;
                    int bb;
                    Color[] ci = this.cols[i];
                    if (i == 4) {
                        bb = 255;
                        gg = 255;
                        rr = 255;
                    } else if (i == 0) {
                        bb = 0;
                        gg = 0;
                        rr = 0;
                    } else {
                        Color cc = Color.getHSBColor((hue + (float)i * incHue) % 1.0f, 0.3f + 0.5f * r.nextFloat(), 0.3f + 0.7f * r.nextFloat());
                        rr = cc.getRed();
                        gg = cc.getGreen();
                        bb = cc.getBlue();
                    }
                    for (int j = 0; j < 50; ++j) {
                        double a = (double)j / 49.0;
                        int aa = (int)Math.floor(255.0 * a);
                        ci[j] = new Color(rr, gg, bb, aa);
                    }
                }
            }
            if (this.F % 50L == 0L) {
                GirihTile gt;
                int i;
                Vector<GirihTile> gtsA = this.tp == 0 ? this.gts0 : this.gts1;
                int isize1 = gtsA.size();
                int isize2 = 0;
                for (i = 0; i < isize1; ++i) {
                    gt = gtsA.elementAt(i);
                    if (gt == null) continue;
                    isize2 += gt.inflationSize();
                }
                Vector<GirihTile> gtsB = new Vector<GirihTile>(isize2);
                for (i = 0; i < isize1; ++i) {
                    gt = gtsA.elementAt(i);
                    if (gt == null) continue;
                    gt.inflate(gtsB);
                }
                if (this.tp == 0) {
                    this.gts1 = gtsB;
                } else {
                    this.gts0 = gtsB;
                }
                this.tp = 1 - this.tp;
            }
            this.d(this.o, w, h);
            g.drawImage(this.I, 0, 0, null);
            this.maybeShowStatus(g);
            ++this.F;
        }
    }

    public void d(Graphics g, int w, int h) {
        int wc = w / 2;
        int hc = h / 2;
        g.setColor(Color.white);
        g.fillRect(-wc, -hc, w, h);
        Rectangle r = new Rectangle(-10, -10, w + 20, h + 20);
        Graphics2D g2 = (Graphics2D)g;
        g2.addRenderingHints(aaON);
        for (int j = 0; j < 2; ++j) {
            int fj = j == 0 ? 49 : (int)(this.F % 50L);
            if (fj == 0) continue;
            double mu = (double)(this.F % 50L) / 50.0;
            if (j == 1) {
                mu -= 1.0;
            }
            double scale = Math.pow(GirihTile.inflationFactor, mu);
            AffineTransform saveAT = g2.getTransform();
            g2.scale(scale, scale);
            AffineTransform saveAT2 = g2.getTransform();
            int tpj = (this.tp + j + 1) % 2;
            Vector<GirihTile> gt = tpj == 0 ? this.gts0 : this.gts1;
            int gtN = gt.size();
            boolean setStroke = false;
            for (int i = 0; i < gtN; ++i) {
                GirihTile gg = gt.elementAt(i);
                if (gg == null) continue;
                int type = gg.getType();
                GeneralPath p = gg.getPath();
                g2.transform(gg.getTransform());
                if (g2.hit(r, p, false)) {
                    g2.setPaint(this.cols[type][fj]);
                    if (type == 0) {
                        if (!setStroke) {
                            g2.setStroke(new BasicStroke(1.0f / (float)(scale * gg.getScale()), 0, 2));
                            setStroke = true;
                        }
                        g2.draw(p);
                    } else {
                        g2.fill(p);
                        if (this.showStraps) {
                            for (int s = 0; s >= 0; --s) {
                                g2.setPaint(this.cols[s == 0 ? 0 : 4][fj]);
                                GeneralPath[] v = gg.getStraps(s);
                                int ns = v.length;
                                for (int si = 0; si < ns; ++si) {
                                    g2.fill(v[si]);
                                }
                            }
                        }
                    }
                } else {
                    gt.setElementAt(null, i);
                }
                g2.setTransform(saveAT2);
            }
            g2.setTransform(saveAT);
        }
        if (this.F == 0L && this.mouseIN) {
            this.mouseEntered(null);
        }
    }

    @Override
    public void showStatus(String s) {
        super.showStatus(s);
        this.statusString = s;
    }

    void maybeShowStatus(Graphics g) {
        if (this.statusString.length() != 0) {
            GraphicsUtils.showStatus((String)this.statusString, (Graphics)g, (Component)this);
        }
    }

    @Override
    public synchronized void mouseEntered(MouseEvent e) {
        this.mouseIN = true;
        this.showStatus("Click to redraw");
    }

    @Override
    public synchronized void mouseExited(MouseEvent e) {
        this.mouseIN = false;
        this.showStatus("");
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        this.F = 0L;
        this.mouseEntered(null);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

