/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.applets.GirihTile;
import egan.applets.ScrollingApplet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Random;

public class Girih2
extends ScrollingApplet {
    private static final long serialVersionUID = 1L;
    static final int ng = 5;
    static final double lambda = (3.0 - Math.sqrt(5.0)) / 2.0;
    static final double oml = (Math.sqrt(5.0) - 1.0) / 2.0;
    static final double lambda2 = (Math.sqrt(5.0) - 1.0) / 4.0;
    static final double oml2 = 1.0 - lambda2;
    static final double lambda3 = (Math.sqrt(5.0) - 1.0) / 2.0;
    static final double oml3 = 1.0 - lambda3;
    static final double screenPix = 300.0;
    double coordWidth = 1.0;
    double inc;
    double rhombEdge;
    double decagonRadius;
    double decagonEdge;
    double eps;
    Color[] palette;
    boolean showTiles = false;
    boolean useDecagons = true;
    BasicStroke str2 = null;
    double[] Gx;
    double[] Gy;
    double[] Gd;
    double[][] Dets;
    double marg;
    boolean[][] thin;
    int[][] Orient;
    int[][] dv = new int[][]{{2, 2, 3, 3}, {3, 0, 2}, {0, 0}, {1}};
    static final BasicStroke str = new BasicStroke(0.5f, 0, 2);
    static final RenderingHints aaON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    GeneralPath rhomb = new GeneralPath(0, 6);

    ScrollingApplet getNewApplet() {
        return new Girih2();
    }

    public void setup(long rseed, int mp) {
        int numD = 6;
        if (mp > 0) {
            this.mainParameter = mp;
        } else if (this.mainParameter < 0) {
            this.mainParameter = 0;
        }
        this.n1 = (this.mainParameter + 1) % numD;
        this.n2 = (this.mainParameter + numD - 1) % numD;
        Random r = new Random(rseed);
        this.Gx = new double[5];
        this.Gy = new double[5];
        this.Gd = new double[5];
        double sA = 0.6283185307179586;
        double hA = sA / 2.0;
        double theta = 2.0 * sA;
        double norm = Math.sqrt(0.4);
        for (int k = 0; k < 5; ++k) {
            this.Gx[k] = norm * Math.cos(theta * (double)k);
            this.Gy[k] = norm * Math.sin(theta * (double)k);
            this.Gd[k] = r.nextDouble();
        }
        this.Gd[4] = -(this.Gd[0] + this.Gd[1] + this.Gd[2] + this.Gd[3] + 2.5);
        this.marg = 0.75 * norm / Math.sin(hA);
        this.thin = new boolean[5][5];
        this.Orient = new int[5][5];
        this.Dets = new double[5][5];
        for (int fD = 0; fD < 5; ++fD) {
            for (int eD = 0; eD < 5; ++eD) {
                double xf = this.Gx[fD];
                double yf = this.Gy[fD];
                double xe = this.Gx[eD];
                double ye = this.Gy[eD];
                float t = (float)(Math.acos((xf * xe + yf * ye) / Math.sqrt((xf * xf + yf * yf) * (xe * xe + ye * ye))) / Math.PI);
                this.thin[fD][eD] = (double)t > 0.5;
                this.Dets[fD][eD] = ye * xf - xe * yf;
                this.Orient[fD][eD] = 2 * (eD + fD);
            }
        }
        this.Orient[3][0] = 16;
        this.Orient[0][3] = 16;
        this.Orient[4][0] = 18;
        this.Orient[0][4] = 18;
        this.Orient[4][1] = 0;
        this.Orient[1][4] = 0;
        float hue = r.nextFloat();
        float incHue = 0.1f + 0.4f * r.nextFloat();
        this.palette = new Color[4];
        for (int i = 0; i < 4; ++i) {
            if (i <= 0) continue;
            this.palette[i] = Color.getHSBColor((hue + (float)i * incHue) % 1.0f, 0.3f + 0.5f * r.nextFloat(), 0.3f + 0.7f * r.nextFloat());
        }
        GirihTile.setup();
        this.showTiles = this.mainParameter % 2 == 0;
        this.coordWidth = 3.0 - (double)(this.mainParameter / 2 % 3);
        this.inc = this.coordWidth / Math.sqrt(5.0) / 300.0;
        this.rhombEdge = Math.sqrt(2.0) * 300.0 / this.coordWidth;
        this.decagonRadius = 2.0 / Math.sqrt(5.0) * 2.0 * Math.sin(0.3141592653589793) * Math.sin(0.6283185307179586) * this.rhombEdge;
        this.decagonEdge = 2.0 * Math.sin(0.3141592653589793) * this.decagonRadius;
        this.str2 = new BasicStroke(0.5f / (float)this.decagonEdge, 0, 2);
        this.eps = this.decagonEdge * this.decagonEdge / 4.0;
        if (this.mouseIN) {
            this.mouseEntered(null);
        }
    }

    public void d(Graphics g, int w, int y1, int y2, long yoffs, boolean init) {
        int wc = w / 2;
        int h2 = (y2 - y1) / 2;
        int hc = y1 + h2;
        Graphics2D g2 = (Graphics2D)g;
        g2.addRenderingHints(aaON);
        float[] xp = new float[4];
        float[] yp = new float[4];
        float[] xp2 = new float[4];
        float[] yp2 = new float[4];
        boolean[] fatE = new boolean[2];
        boolean[] fatF = new boolean[2];
        if (init) {
            this.thisSeed = new Random().nextLong();
            this.setup(this.thisSeed, -1);
            g2.setStroke(this.str2);
        }
        double[] gx = this.Gx;
        double[] gy = this.Gy;
        double[] gd = this.Gd;
        double[][] dets = this.Dets;
        g.setColor(this.showTiles ? Color.white : this.palette[3]);
        g.fillRect(0, y1, w, y2 - y1);
        double xm1 = (double)wc * this.inc + this.marg;
        double xm0 = -xm1;
        double ym1 = (double)(yoffs + (long)h2) * this.inc + this.marg;
        double ym0 = (double)(yoffs - (long)h2) * this.inc - this.marg;
        double[] xm = new double[]{xm0, xm1};
        double[] ym = new double[]{ym0, ym1};
        double[] xep = new double[2];
        double[] yep = new double[2];
        for (int eD = 0; eD < 5; ++eD) {
            int k;
            double xe = gx[eD];
            double ye = gy[eD];
            double de = gd[eD] + 0.5;
            int lc = Integer.MAX_VALUE;
            int uc = Integer.MIN_VALUE;
            for (int j = 0; j < 2; ++j) {
                for (int i = 0; i < 2; ++i) {
                    k = (int)Math.ceil(xe * xm[i] + ye * ym[j] + de);
                    if (k < lc) {
                        lc = k;
                    }
                    if (--k <= uc) continue;
                    uc = k;
                }
            }
            for (int eV = lc; eV <= uc; ++eV) {
                double y;
                double x;
                double ae = (double)eV - de;
                int nn = 0;
                for (int ii = 0; ii < 2 && nn < 2; ++ii) {
                    x = xm[ii];
                    y = (ae - gx[eD] * x) / gy[eD];
                    if (y >= ym0 && y <= ym1) {
                        xep[nn] = x;
                        yep[nn++] = y;
                        if (nn == 2) break;
                    }
                    if (!((x = (ae - gy[eD] * (y = ym[ii])) / gx[eD]) >= xm0) || !(x <= xm1)) continue;
                    xep[nn] = x;
                    yep[nn++] = y;
                }
                double xep0 = xep[0];
                double xep1 = xep[1];
                double yep0 = yep[0];
                double yep1 = yep[1];
                for (int fD = eD + 1; fD < 5; ++fD) {
                    double xf = gx[fD];
                    double xfae = xf * ae;
                    double yf = gy[fD];
                    double yfae = yf * ae;
                    double df = gd[fD] + 0.5;
                    double dd = dets[eD][fD];
                    int lc0 = (int)Math.ceil(xf * xep0 + yf * yep0 + df);
                    int uc0 = (int)Math.floor(xf * xep1 + yf * yep1 + df);
                    if (uc0 < lc0) {
                        k = lc0;
                        lc0 = uc0 + 1;
                        uc0 = k - 1;
                    }
                    for (int fV = lc0; fV <= uc0; ++fV) {
                        int m;
                        double af = (double)fV - df;
                        x = (yfae - ye * af) / dd;
                        y = (xe * af - xfae) / dd;
                        double xs = 0.0;
                        double ys = 0.0;
                        int lV = eV + fV;
                        for (m = 0; m < 5; ++m) {
                            if (m == eD || m == fD) continue;
                            double gxm = gx[m];
                            double gym = gy[m];
                            double gdm = gd[m];
                            double flr = Math.floor(gxm * x + gym * y + gdm + 0.5);
                            double z = flr - gdm;
                            xs += z * gxm;
                            ys += z * gym;
                            lV += (int)flr + 1;
                        }
                        for (m = 0; m < 4; ++m) {
                            double ee = ae + 0.5 - (double)(m / 2);
                            double ff = af + 0.5 - (double)((m + 1) % 4 / 2);
                            double xa = xs + ee * xe + ff * xf;
                            double ya = ys + ee * ye + ff * yf;
                            xp[m] = (float)((double)wc + xa / this.inc);
                            yp[m] = (float)((double)hc + ya / this.inc - (double)yoffs);
                        }
                        while (lV < 0) {
                            lV += 5000000;
                        }
                        int decOrient = (eV + fV) % 10;
                        if (this.thin[eD][fD]) {
                            this.drawTileThin(g2, xp, yp, lV % 5, this.Orient[eD][fD], dd, eD, fD, decOrient);
                            continue;
                        }
                        this.drawTileThick(g2, xp, yp, lV % 5, this.Orient[eD][fD], dd, eD, fD, decOrient);
                    }
                }
            }
        }
    }

    public void drawTileThin(Graphics2D g2, float[] xp, float[] yp, int aa, int orient, double dd, int eD, int fD, int decOrient) {
        int i;
        double x0 = xp[0];
        double x1 = xp[1];
        double x2 = xp[2];
        double x3 = xp[3];
        double y0 = yp[0];
        double y1 = yp[1];
        double y2 = yp[2];
        double y3 = yp[3];
        double x10 = (x0 + x2) / 2.0;
        double y10 = (y0 + y2) / 2.0;
        double x11 = lambda3 * x10 + oml3 * x3;
        double y11 = lambda3 * y10 + oml3 * y3;
        this.drawGirih(g2, new GirihTile(x11, y11, this.decagonEdge, orient + 5, 1, 2));
        double x12 = lambda3 * x10 + oml3 * x1;
        double y12 = lambda3 * y10 + oml3 * y1;
        this.drawGirih(g2, new GirihTile(x12, y12, this.decagonEdge, orient + 5, 1, 2));
        int n = i = dd < 0.0 ? 0 : 1;
        while (i < 4) {
            int j = (i + 1) % 4;
            double xx = (double)(xp[i] + xp[j]) / 2.0;
            double yy = (double)(yp[i] + yp[j]) / 2.0;
            this.drawGirih(g2, new GirihTile(xx, yy, this.decagonEdge, 4 * (i % 2 == 0 ? fD : eD), 2, 2));
            i += 2;
        }
        int decV = this.dv[eD][fD - eD - 1];
        double xdec = xp[decV];
        double ydec = yp[decV];
        this.drawDecagon(g2, xdec, ydec, decOrient);
    }

    public void drawTileThick(Graphics2D g2, float[] xp, float[] yp, int aa, int orient, double dd, int eD, int fD, int decOrient) {
        int v0;
        if (aa == 1) {
            v0 = 0;
        } else {
            v0 = 2;
            orient += 10;
        }
        int dd1 = dd < 0.0 ? -1 : 1;
        int v1 = (v0 + 1) % 4;
        int v2 = (v0 + 2) % 4;
        int v3 = (v0 + 3) % 4;
        double x0 = xp[v0];
        double x1 = xp[v1];
        double x2 = xp[v2];
        double x3 = xp[v3];
        double y0 = yp[v0];
        double y1 = yp[v1];
        double y2 = yp[v2];
        double y3 = yp[v3];
        double x4 = lambda * x0 + oml * x2;
        double y4 = lambda * y0 + oml * y2;
        this.drawDecagon(g2, x4, y4, decOrient);
        int decV = this.dv[eD][fD - eD - 1];
        double xdec = xp[decV];
        double ydec = yp[decV];
        this.drawDecagon(g2, xdec, ydec, decOrient);
        if (dd < 0.0) {
            double xx = (x2 + x3) / 2.0;
            double yy = (y2 + y3) / 2.0;
            this.drawGirih(g2, new GirihTile(xx, yy, this.decagonEdge, 4 * (v2 % 2 == 0 ? fD : eD), 2, 2));
            xx = (x3 + x0) / 2.0;
            yy = (y3 + y0) / 2.0;
            this.drawGirih(g2, new GirihTile(xx, yy, this.decagonEdge, 4 * (v3 % 2 == 0 ? fD : eD), 2, 2));
        } else {
            double xx = (x1 + x2) / 2.0;
            double yy = (y1 + y2) / 2.0;
            this.drawGirih(g2, new GirihTile(xx, yy, this.decagonEdge, 4 * (v1 % 2 == 0 ? fD : eD), 2, 2));
            xx = (x0 + x1) / 2.0;
            yy = (y0 + y1) / 2.0;
            this.drawGirih(g2, new GirihTile(xx, yy, this.decagonEdge, 4 * (v0 % 2 == 0 ? fD : eD), 2, 2));
        }
        double x9 = lambda2 * x2 + oml2 * x0;
        double y9 = lambda2 * y2 + oml2 * y0;
        this.drawGirih(g2, new GirihTile(x9, y9, this.decagonEdge, orient, 2, 2));
        double x10 = (x3 + x4) / 2.0;
        double y10 = (y3 + y4) / 2.0;
        double x11 = lambda3 * x10 + oml3 * x0;
        double y11 = lambda3 * y10 + oml3 * y0;
        this.drawGirih(g2, new GirihTile(x11, y11, this.decagonEdge, orient - dd1, 1, 2));
        double x12 = (x1 + x4) / 2.0;
        double y12 = (y1 + y4) / 2.0;
        double x13 = lambda3 * x12 + oml3 * x0;
        double y13 = lambda3 * y12 + oml3 * y0;
        this.drawGirih(g2, new GirihTile(x13, y13, this.decagonEdge, orient + dd1, 1, 2));
    }

    public void drawGirih(Graphics2D g2, GirihTile gt) {
        AffineTransform saveAT = g2.getTransform();
        g2.transform(gt.getTransform());
        if (this.showTiles) {
            GeneralPath gp = gt.getPath();
            g2.setColor(this.palette[gt.getType()]);
            g2.fill(gp);
            g2.setColor(Color.white);
            g2.draw(gp);
        }
        for (int s = 1; s >= 0; --s) {
            g2.setPaint(s == 0 ? Color.black : Color.white);
            for (GeneralPath gp : gt.getStraps(s)) {
                g2.fill(gp);
            }
        }
        g2.setTransform(saveAT);
    }

    public void drawDecagon(Graphics2D g2, double xdec, double ydec, int decOrient) {
        if (this.useDecagons) {
            this.drawGirih(g2, new GirihTile(xdec, ydec, this.decagonEdge, 1, 3, 2));
        } else {
            int dec2 = 2 * decOrient;
            double a = 0.3141592653589793;
            double rh = this.decagonRadius * Math.cos(3.0 * a);
            double xx = xdec + rh * Math.cos((double)dec2 * a);
            double yy = ydec + rh * Math.sin((double)dec2 * a);
            this.drawGirih(g2, new GirihTile(xx, yy, this.decagonEdge, (dec2 + 5) % 20, 1, 2));
            xx = xdec + rh * Math.cos((double)(dec2 + 6) * a);
            yy = ydec + rh * Math.sin((double)(dec2 + 6) * a);
            this.drawGirih(g2, new GirihTile(xx, yy, this.decagonEdge, (dec2 + 11) % 20, 1, 2));
            xx = xdec + rh * Math.cos((double)(dec2 + 12) * a);
            yy = ydec + rh * Math.sin((double)(dec2 + 12) * a);
            this.drawGirih(g2, new GirihTile(xx, yy, this.decagonEdge, (dec2 + 17) % 20, 1, 2));
            double rb = this.decagonRadius * Math.cos(a) - rh;
            xx = xdec + rb * Math.cos((double)(dec2 + 16) * a);
            yy = ydec + rb * Math.sin((double)(dec2 + 16) * a);
            this.drawGirih(g2, new GirihTile(xx, yy, this.decagonEdge, (dec2 + 6) % 20, 2, 2));
        }
    }

    public synchronized void mouseEntered(MouseEvent e) {
        this.mouseIN = true;
        this.showStatus("Click to redraw");
    }

    public synchronized void keyPressed(KeyEvent e) {
        int kc = e.getKeyCode();
        if (kc == 68) {
            ((Girih2)this.keyTarget).useDecagons = !((Girih2)this.keyTarget).useDecagons;
            this.keyTarget.redraw = true;
            this.keyTarget.lowY = 0L;
        } else {
            super.keyPressed(e);
        }
    }
}

