/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.geometry.BSPobject;
import egan.geometry.Gon2D;
import egan.geometry.GraphEdge;
import egan.geometry.GraphNode;
import egan.geometry.PlanarGraph;
import egan.graphics.BgTiler;
import egan.graphics.GraphicsUtils;
import egan.util.Utils;
import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;
import java.util.Vector;

public class Hypercube
extends Applet
implements Runnable,
MouseListener {
    private static final long serialVersionUID = 1L;
    static final BasicStroke str = new BasicStroke(0.75f, 0, 2);
    static final RenderingHints aaON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    GeneralPath rhomb = new GeneralPath(0, 5);
    long F = 0L;
    long pt = 0L;
    long tStep = 100L;
    private volatile Thread a;
    Image I;
    Graphics o;
    BgTiler bgt = null;
    boolean mouseIN;
    int minDIM = 4;
    int maxDIM = 5;
    int dim = 3;
    int MAXPIECES = 0;
    int MAXPTS = 20;
    int[][] xxx;
    int[][] yyy;
    int[] fsf;
    double[] cp = new double[3];
    double[] lum;
    float[][] tRGB;
    float[][] rRGB;
    float[] rgb = new float[3];
    float sat;
    float oms;
    float flash;
    float flashEdge;
    int nvertices;
    double[][] vertices;
    int nedges;
    int nParallelEdges;
    int[][] edges;
    int[][] edgeFaces;
    boolean[][] edgeFaceRev;
    double edgeWidth;
    int nfaces;
    int nParallelFaces;
    int nFaceOrientations;
    int verticesPerFace;
    int[][] faces;
    int[][] ddFace;
    int[][] faceHyperfaces;
    int[][] faceCubes;
    int[][] faceCubeDim;
    boolean[] faceCW;
    boolean[] isSurface;
    boolean[] isFront;
    double[][] faceCoords;
    float[] faceBrightness;
    int ncubes;
    int nParallelCubes;
    int nCubeOrientations;
    int[][] cubeHyperfaces;
    boolean[] stp;
    boolean[] is3Surface;
    int nhyperfaces;
    double[][] normals;
    double[][] rotation;
    String statusString = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.addMouseListener(this);
        Thread thisThread = Thread.currentThread();
        while (this.a == thisThread) {
            long t = System.currentTimeMillis();
            Hypercube hypercube = this;
            synchronized (hypercube) {
                if (t - this.pt > this.tStep || t < this.pt) {
                    this.repaint();
                }
            }
            try {
                Thread.sleep(20L);
            }
            catch (Exception e) {
                break;
            }
        }
    }

    @Override
    public void start() {
        this.a = new Thread(this);
        this.a.start();
        this.a.setPriority(1);
    }

    @Override
    public void stop() {
        this.a = null;
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public synchronized void update(Graphics g) {
        long t = System.currentTimeMillis();
        if (t - this.pt >= this.tStep || t < this.pt) {
            int i;
            this.pt = t;
            int w = this.getSize().width;
            int h = this.getSize().height;
            if (this.F == 0L) {
                int d2;
                int d1;
                this.I = this.createImage(w, h);
                this.o = this.I.getGraphics();
                this.dim = this.dim < 0 ? this.minDIM + (int)(Math.random() * (double)(this.maxDIM - this.minDIM + 1)) : this.minDIM + (this.dim - this.minDIM + 1) % (this.maxDIM - this.minDIM + 1);
                int dm1 = this.dim - 1;
                int dm2 = this.dim - 2;
                this.sat = 0.7f - 0.1f * (float)this.dim;
                this.oms = 1.0f - this.sat;
                this.flash = 0.55f;
                this.flashEdge = 0.55f;
                this.nvertices = 1 << this.dim;
                this.vertices = new double[this.nvertices][this.dim];
                double normalise = Math.sqrt(this.dim);
                this.edgeWidth = 2.0 / normalise;
                for (int i2 = 0; i2 < this.nvertices; ++i2) {
                    for (int j = 0; j < this.dim; ++j) {
                        this.vertices[i2][j] = (double)((i2 & 1 << j) == 0 ? 1 : -1) / normalise;
                    }
                }
                this.nParallelEdges = 1 << dm1;
                this.nedges = this.dim * this.nParallelEdges;
                this.edges = new int[this.nedges][2];
                this.edgeFaces = new int[this.nedges][this.dim - 1];
                this.edgeFaceRev = new boolean[this.nedges][this.dim - 1];
                int ie = 0;
                for (int d12 = 0; d12 < this.dim; ++d12) {
                    for (int offset = 0; offset < this.nParallelEdges; ++offset) {
                        int v1 = 0;
                        int m = 0;
                        for (int n = 0; n < this.dim; ++n) {
                            if (n == d12) continue;
                            v1 |= (offset >> m++ & 1) << n;
                        }
                        this.edges[ie][0] = v1;
                        this.edges[ie][1] = v1 | 1 << d12;
                        ++ie;
                    }
                }
                this.nFaceOrientations = this.dim * dm1 / 2;
                this.nParallelFaces = 1 << dm2;
                this.nfaces = this.nParallelFaces * this.nFaceOrientations;
                this.verticesPerFace = 4;
                this.faces = new int[this.nfaces][this.verticesPerFace];
                this.faceCW = new boolean[this.nFaceOrientations];
                this.faceCoords = new double[this.nFaceOrientations][4];
                this.faceBrightness = new float[this.nfaces];
                this.faceHyperfaces = new int[this.nfaces][this.dim - 2];
                this.ddFace = new int[this.dim][this.dim];
                this.isSurface = new boolean[this.nfaces];
                this.isFront = new boolean[this.nfaces];
                int nf = 0;
                int[] vmap = new int[]{3, 2, 0, 1};
                for (int d13 = 0; d13 < dm1; ++d13) {
                    for (int d22 = d13 + 1; d22 < this.dim; ++d22) {
                        int n = nf;
                        this.ddFace[d22][d13] = n;
                        this.ddFace[d13][d22] = n;
                        for (int offset = 0; offset < this.nParallelFaces; ++offset) {
                            int i3;
                            int[] fv = this.faces[nf];
                            for (i3 = 0; i3 < 4; ++i3) {
                                int j = vmap[i3];
                                int l = 0;
                                int m = 0;
                                for (int n2 = 0; n2 < this.dim; ++n2) {
                                    int bit = n2 == d13 ? j & 1 : (n2 == d22 ? j / 2 : offset >> m++ & 1);
                                    l |= bit << n2;
                                }
                                fv[i3] = l;
                            }
                            for (i3 = 0; i3 < 4; ++i3) {
                                int j;
                                int edim;
                                int v1 = fv[i3];
                                int v2 = fv[(i3 + 1) % 4];
                                if (i3 % 2 == 0) {
                                    edim = d13;
                                    j = d22 - 1;
                                } else {
                                    edim = d22;
                                    j = d13;
                                }
                                int mask = (1 << edim) - 1;
                                ie = this.nParallelEdges * edim + (v1 & mask | v1 >> 1 & ~mask);
                                this.edgeFaces[ie][j] = nf;
                                this.edgeFaceRev[ie][j] = v1 > v2;
                            }
                            int hfc = 0;
                            for (int i4 = 0; i4 < this.dim; ++i4) {
                                if (i4 == d13 || i4 == d22) continue;
                                this.faceHyperfaces[nf][hfc] = 2 * i4 + (offset >> hfc & 1);
                                ++hfc;
                            }
                            ++nf;
                        }
                    }
                }
                this.tRGB = new float[this.nfaces][3];
                this.rRGB = new float[this.nfaces][3];
                double x = Math.random();
                for (int i5 = 0; i5 < this.nfaces; ++i5) {
                    float hue = (float)(x + (double)i5 / (double)this.nfaces) % 1.0f;
                    int ci = Color.HSBtoRGB(hue, 1.0f, 1.0f);
                    for (int ic = 0; ic < 3; ++ic) {
                        float yy = (float)(ci >> 8 * ic & 0xFF) / 255.0f;
                        this.tRGB[i5][ic] = this.oms + this.sat * yy;
                        this.rRGB[i5][ic] = yy;
                    }
                }
                if (this.dim == 5) {
                    this.nCubeOrientations = this.dim * dm1 * dm2 / 6;
                    this.nParallelCubes = 1 << this.dim - 3;
                    this.ncubes = this.nParallelCubes * this.nCubeOrientations;
                    this.cubeHyperfaces = new int[this.ncubes][this.dim - 3];
                    this.faceCubes = new int[this.nfaces][this.dim - 2];
                    this.faceCubeDim = new int[this.nfaces][this.dim - 2];
                    int[] fcC = new int[this.nfaces];
                    this.stp = new boolean[this.dim];
                    this.is3Surface = new boolean[this.ncubes];
                    int nc = 0;
                    for (d1 = 0; d1 < dm2; ++d1) {
                        for (d2 = d1 + 1; d2 < dm1; ++d2) {
                            for (int d3 = d2 + 1; d3 < this.dim; ++d3) {
                                int[] dset = new int[]{d1, d2, d3};
                                for (int offset = 0; offset < this.nParallelCubes; ++offset) {
                                    int hfc = 0;
                                    for (int i6 = 0; i6 < this.dim; ++i6) {
                                        if (i6 == d1 || i6 == d2 || i6 == d3) continue;
                                        this.cubeHyperfaces[nc][hfc] = 2 * i6 + (offset >> hfc & 1);
                                        ++hfc;
                                    }
                                    for (int edim = 0; edim < 3; ++edim) {
                                        int dA = dset[(edim + 1) % 3];
                                        int dB = dset[(edim + 2) % 3];
                                        int dC = dset[edim];
                                        for (int shift = 0; shift < 2; ++shift) {
                                            int l = 0;
                                            int m = 0;
                                            int z = 0;
                                            for (int n = 0; n < this.dim; ++n) {
                                                if (n == dA || n == dB) continue;
                                                int bit = n == dC ? shift : offset >> m++ & 1;
                                                l |= bit << z++;
                                            }
                                            int n = l += this.ddFace[dA][dB];
                                            fcC[n] = fcC[n] + 1;
                                            this.faceCubes[l][y] = nc;
                                            this.faceCubeDim[l][y] = shift == 0 ? -1 - dC : 1 + dC;
                                        }
                                    }
                                    ++nc;
                                }
                            }
                        }
                    }
                }
                this.nhyperfaces = 2 * this.dim;
                this.normals = new double[this.nhyperfaces][this.dim];
                for (int i7 = 0; i7 < this.nhyperfaces; ++i7) {
                    this.normals[i7][i7 / 2] = i7 % 2 == 0 ? 1.0 : -1.0;
                }
                double[][] prevR = null;
                double[][] newR = null;
                for (d1 = 0; d1 < this.dim - 1; ++d1) {
                    for (d2 = d1 + 1; d2 < this.dim; ++d2) {
                        int j;
                        double angle = 0.01 * (2.0 + Math.random());
                        double[][] rm = new double[this.dim][this.dim];
                        for (j = 0; j < this.dim; ++j) {
                            rm[j][j] = 1.0;
                        }
                        double d = Math.cos(angle);
                        rm[d2][d2] = d;
                        rm[d1][d1] = d;
                        rm[d1][d2] = Math.sin(angle);
                        rm[d2][d1] = -rm[d1][d2];
                        if (prevR == null) {
                            prevR = rm;
                            continue;
                        }
                        if (newR == null) {
                            newR = new double[this.dim][this.dim];
                        }
                        for (j = 0; j < this.dim; ++j) {
                            for (int k = 0; k < this.dim; ++k) {
                                double s = 0.0;
                                for (int l = 0; l < this.dim; ++l) {
                                    s += prevR[j][l] * rm[l][k];
                                }
                                newR[j][k] = s;
                            }
                        }
                        double[][] tmp = prevR;
                        prevR = newR;
                        newR = tmp;
                    }
                }
                this.rotation = prevR;
                this.lum = Utils.randomUnitVec(null, (boolean)false);
            }
            for (i = 0; i < this.nvertices; ++i) {
                Utils.transform((double[][])this.rotation, (double[])this.vertices[i]);
            }
            for (i = 0; i < this.nhyperfaces; ++i) {
                Utils.transform((double[][])this.rotation, (double[])this.normals[i]);
            }
            if (this.bgt == null) {
                this.bgt = new BgTiler((Applet)this, w, h);
            }
            this.d(this.o, w, h, this.bgt.tile(this.o));
            g.drawImage(this.I, 0, 0, null);
            this.maybeShowStatus(g);
            ++this.F;
        }
    }

    public void d(Graphics g, int w, int h, boolean TB) {
        int wc = w / 2;
        int hc = h / 2;
        int rad = Math.min(wc, hc) - 4;
        if (!TB) {
            g.setColor(Color.white);
            g.fillRect(0, 0, w, h);
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHints(aaON);
        g2.setStroke(str);
        if (this.dim == 5) {
            int halfC = this.nParallelCubes / 2;
            int cbase = 0;
            for (int d1 = 0; d1 < this.dim - 2; ++d1) {
                for (int d2 = d1 + 1; d2 < this.dim - 1; ++d2) {
                    for (int d3 = d2 + 1; d3 < this.dim; ++d3) {
                        for (int offset = 0; offset < halfC; ++offset) {
                            int ci = cbase + offset;
                            int ci2 = cbase + (this.nParallelCubes - 1 - offset);
                            int[] hf = this.cubeHyperfaces[ci];
                            this.is3Surface[ci] = this.normals[hf[0]][3] * this.normals[hf[1]][3] < 0.0;
                            this.is3Surface[ci2] = this.is3Surface[ci];
                        }
                        cbase += this.nParallelCubes;
                    }
                }
            }
        }
        int half = this.nParallelFaces / 2;
        int nf = 0;
        int fbase = 0;
        for (int d1 = 0; d1 < this.dim - 1; ++d1) {
            double[] h1 = this.normals[2 * d1];
            double aa = h1[0];
            double cc = h1[1];
            for (int d2 = d1 + 1; d2 < this.dim; ++d2) {
                double[] h2 = this.normals[2 * d2];
                Utils.cross((double[])h1, (double[])h2, (double[])this.cp);
                double det = this.cp[2];
                this.faceCW[nf] = det < 0.0;
                double[] fc = this.faceCoords[nf];
                fc[0] = h2[1] / det;
                fc[1] = -h2[0] / det;
                fc[2] = -cc / det;
                fc[3] = aa / det;
                if (this.dim == 5) {
                    for (int d3 = 0; d3 < this.dim; ++d3) {
                        if (d3 == d1 || d3 == d2) continue;
                        this.stp[d3] = Utils.dot((double[])this.cp, (double[])this.normals[2 * d3]) > 0.0;
                    }
                }
                for (int i = 0; i < half; ++i) {
                    int fi = fbase + i;
                    int fi2 = fbase + (this.nParallelFaces - 1 - i);
                    boolean surface = false;
                    if (this.dim == 4) {
                        int[] hf = this.faceHyperfaces[fi];
                        surface = this.normals[hf[0]][3] * this.normals[hf[1]][3] < 0.0;
                    } else if (this.dim == 5) {
                        int[] fcubes = this.faceCubes[fi];
                        int[] fcd = this.faceCubeDim[fi];
                        int sc = 0;
                        surface = true;
                        for (int j = 0; j < 3; ++j) {
                            if (!this.is3Surface[fcubes[j]]) continue;
                            ++sc;
                            int k = fcd[j];
                            if (k < 0) {
                                if (this.stp[-k - 1]) continue;
                                surface = !surface;
                                continue;
                            }
                            if (!this.stp[k - 1]) continue;
                            surface = !surface;
                        }
                        if (sc != 2) {
                            surface = false;
                        }
                    }
                    this.isSurface[fi2] = this.isSurface[fi] = surface;
                    if (!this.isSurface[fi]) continue;
                    this.isFront[fi] = Utils.dot((double[])this.cp, (double[])this.vertices[this.faces[fi][0]]) * det > 0.0;
                    this.isFront[fi2] = !this.isFront[fi];
                    this.faceBrightness[fi2] = this.faceBrightness[fi] = (float)Math.sqrt(Math.max(0.25, this.lum[2] - 2.0 * Utils.dot((double[])this.cp, (double[])this.lum) * det));
                }
                ++nf;
                fbase += this.nParallelFaces;
            }
        }
        Vector<BSPobject> pieces = new Vector<BSPobject>(3 * this.nfaces);
        int np = this.disjoint(pieces, 1.0E-8);
        if (np > this.MAXPIECES) {
            this.MAXPIECES = np;
            this.xxx = new int[this.MAXPIECES][this.MAXPTS];
            this.yyy = new int[this.MAXPIECES][this.MAXPTS];
            this.fsf = new int[this.MAXPIECES];
        }
        for (int pass = 0; pass < 3; ++pass) {
            for (int i = 0; i < np; ++i) {
                int j;
                float fb;
                int sf;
                Gon2D gg = (Gon2D)pieces.elementAt(i);
                int nv = gg.nvert;
                int[] xx = this.xxx[i];
                int[] yy = this.yyy[i];
                float[] Rrgb = null;
                if (pass == 0) {
                    sf = -1;
                    for (int ic = 0; ic < 3; ++ic) {
                        this.rgb[ic] = 1.0f;
                    }
                    for (int ig = 0; ig < this.nfaces; ++ig) {
                        if (!gg.inGons[ig]) continue;
                        float[] Trgb = this.tRGB[ig];
                        for (int ic = 0; ic < 3; ++ic) {
                            int n = ic;
                            this.rgb[n] = this.rgb[n] * Trgb[ic];
                        }
                        if (sf >= 0 || !this.isSurface[ig] || !this.isFront[ig]) continue;
                        sf = ig;
                    }
                    Rrgb = this.rRGB[sf];
                    fb = this.flash * this.faceBrightness[sf];
                    float omf = 1.0f - fb;
                    for (int ic = 0; ic < 3; ++ic) {
                        this.rgb[ic] = omf * this.rgb[ic] + fb * Rrgb[ic];
                    }
                    this.fsf[i] = sf;
                    for (j = 0; j <= nv; ++j) {
                        int k = j % nv;
                        xx[j] = wc + (int)((double)rad * gg.vertices[k][0]);
                        yy[j] = hc + (int)((double)rad * gg.vertices[k][1]);
                    }
                    g.setColor(new Color(this.rgb[0], this.rgb[1], this.rgb[2]));
                    g.fillPolygon(xx, yy, nv);
                    continue;
                }
                sf = this.fsf[i];
                Rrgb = this.rRGB[sf];
                fb = this.flashEdge * this.faceBrightness[sf];
                boolean[][][] edgeOwners = gg.edgeOwners;
                g.setColor(pass == 1 ? new Color(fb * Rrgb[0], fb * Rrgb[1], fb * Rrgb[2]) : Color.black);
                for (j = 0; j < nv; ++j) {
                    boolean ext;
                    boolean[][] ej = edgeOwners[j];
                    boolean bl = ext = ej[0][sf] || ej[1][sf];
                    if ((!ext || pass != 2) && (ext || pass != 1)) continue;
                    g.drawLine(xx[j], yy[j], xx[j + 1], yy[j + 1]);
                }
            }
        }
        if (this.F == 0L && this.mouseIN) {
            this.mouseEntered(null);
        }
    }

    private int disjoint(Vector<BSPobject> pieces, double tolerance) {
        int nfacesPlus = this.nfaces + 1;
        PlanarGraph graph = new PlanarGraph(this.nvertices, this.nvertices, this.nvertices, this.nvertices, 2, tolerance);
        GraphNode[] vertexNodes = new GraphNode[this.nvertices];
        for (int i = 0; i < this.nvertices; ++i) {
            vertexNodes[i] = graph.createNode(this.vertices[i], null);
        }
        for (int ie = 0; ie < this.nedges; ++ie) {
            int[] eie = this.edges[ie];
            int[] fie = this.edgeFaces[ie];
            boolean[] rie = this.edgeFaceRev[ie];
            long group = 1 << 2 + ie / this.nParallelEdges;
            boolean[][] eData = new boolean[2][nfacesPlus];
            for (int j = 0; j < this.dim - 1; ++j) {
                int ci;
                int fi = fie[j];
                int n = ci = this.faceCW[fi / this.nParallelFaces] ? 1 : 0;
                if (rie[j]) {
                    ci = 1 - ci;
                }
                eData[ci][fi] = true;
                group |= this.isSurface[fi] ? (long)(this.isFront[fi] ? 1 : 2) : 0L;
            }
            GraphEdge ee = graph.createEdge(vertexNodes[eie[0]], vertexNodes[eie[1]], (Object)eData);
            ee.group = group;
        }
        graph.planarDecompose(this.nfaces);
        int npieces = graph.GraphToGon2Ds(pieces, this.nfaces, true);
        for (int ip = 0; ip < npieces; ++ip) {
            Gon2D piece = (Gon2D)pieces.elementAt(ip);
            piece.inGons = new boolean[this.nfaces];
            boolean[] ig = piece.inGons;
            boolean[][] pData = piece.parGons;
            boolean[] inPar = pData[0];
            boolean[] outPar = pData[1];
            System.arraycopy(inPar, 0, ig, 0, this.nfaces);
            for (int jg = 0; jg < this.nfaces; ++jg) {
                double dy;
                double[] orig;
                double[] p2;
                double[][] vv;
                double[] p1;
                double dx;
                double[] fc;
                double cx;
                if (outPar[jg] || inPar[jg] || !((cx = (fc = this.faceCoords[jg / this.nParallelFaces])[0] * (dx = ((p1 = (vv = piece.vertices)[0])[0] + (p2 = vv[1])[0]) / 2.0 - (orig = this.vertices[this.faces[jg][0]])[0]) + fc[1] * (dy = (p1[1] + p2[1]) / 2.0 - orig[1])) >= 0.0) || !(cx <= this.edgeWidth)) continue;
                double cy = fc[2] * dx + fc[3] * dy;
                ig[jg] = cy >= 0.0 && cy <= this.edgeWidth;
            }
        }
        graph.destroy();
        return npieces;
    }

    @Override
    public void showStatus(String s) {
        super.showStatus(s);
        this.statusString = s;
    }

    void maybeShowStatus(Graphics g) {
        if (this.statusString.length() != 0) {
            GraphicsUtils.showStatus((String)this.statusString, (Graphics)g, (Component)this);
        }
    }

    @Override
    public synchronized void mouseEntered(MouseEvent e) {
        this.mouseIN = true;
        this.showStatus("Hypercube of dimension " + this.dim + "; click for next");
    }

    @Override
    public synchronized void mouseExited(MouseEvent e) {
        this.mouseIN = false;
        this.showStatus("");
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        this.mouseIN = true;
        this.F = 0L;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

