/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.geometry.Gon3D;
import egan.geometry.Polyhedron;
import egan.graphics.BgTiler;
import egan.graphics.GraphicsUtils;
import egan.util.Utils;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

public class Platonic
extends Applet
implements Runnable,
MouseListener {
    private static final long serialVersionUID = 1L;
    long F = 0L;
    long pt = 0L;
    long tStep = 100L;
    private volatile Thread a;
    boolean mouseIN = true;
    Image I;
    Graphics o;
    BgTiler bgt = null;
    int pair = -1;
    static final int npoly = 2;
    Polyhedron[] ph = new Polyhedron[2];
    Gon3D[] gons;
    double[] sb;
    boolean[] sf;
    double[][][] rotation = new double[2][3][3];
    double[] lum;
    static final int nshades = 3;
    Color[][] palette;
    int[][] xp;
    int[][] yp;
    String statusString = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.addMouseListener(this);
        Thread thisThread = Thread.currentThread();
        while (this.a == thisThread) {
            long t = System.currentTimeMillis();
            Platonic platonic = this;
            synchronized (platonic) {
                if (t - this.pt > this.tStep || t < this.pt) {
                    this.repaint();
                }
            }
            try {
                Thread.sleep(20L);
            }
            catch (Exception e) {
                break;
            }
        }
    }

    @Override
    public void start() {
        this.a = new Thread(this);
        this.a.start();
        this.a.setPriority(1);
    }

    @Override
    public void stop() {
        this.a = null;
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public synchronized void update(Graphics g) {
        long t = System.currentTimeMillis();
        if (t - this.pt >= this.tStep || t < this.pt) {
            this.pt = t;
            int w = this.getSize().width;
            int h = this.getSize().height;
            if (this.F == 0L) {
                this.I = this.createImage(w, h);
                this.o = this.I.getGraphics();
                GraphicsUtils.setAA((Graphics)this.o);
                this.palette = GraphicsUtils.randomPalette((int)3, (int)3, (int)1);
                this.palette[0][0] = new Color(this.palette[0][0].getRGB() & 0xFFFFFF | 0xAA000000, true);
                this.palette[0][1] = new Color(this.palette[0][0].getRGB() & 0xFFFFFF | 0xAA000000, true);
                int[][] indexList = new int[][]{{0, 0}, {1, 1}, {1, 2}, {2, 2}, {2, 1}, {3, 3}, {3, 4}, {4, 4}, {4, 3}};
                int ni = indexList.length;
                this.pair = this.pair < 0 ? (int)((double)ni * Math.random()) : (this.pair + 1) % ni;
                int[] index = indexList[this.pair];
                int maxgons = 0;
                for (int ip = 0; ip < 2; ++ip) {
                    Polyhedron phA = this.ph[ip] = Polyhedron.regularPolyhedron((int)index[ip]);
                    maxgons += 4 * phA.NF;
                    Utils.setRotation((double[][])this.rotation[ip], (double)(0.03 * (2.0 + Math.random())), (double[])Utils.randomUnitVec(null, (boolean)false), (double)1.0);
                }
                this.gons = new Gon3D[maxgons];
                Polyhedron p = this.ph[0];
                int nf = p.NF;
                int[][] fv = p.face_vertices;
                double[][] vertices = p.vertices;
                for (int jf = 0; jf < nf; ++jf) {
                    int[] fvj = fv[jf];
                    int ns = fvj.length;
                    double[][] vt = new double[ns][];
                    for (int i = 0; i < ns; ++i) {
                        vt[i] = vertices[fvj[i]];
                    }
                    this.gons[jf] = new Gon3D((double[][])vt, ns);
                    this.gons[jf].surfaceID = jf;
                }
                this.sb = new double[nf];
                this.sf = new boolean[nf];
                this.lum = Utils.randomUnitVec(null, (boolean)false);
                this.xp = new int[maxgons][50];
                this.yp = new int[maxgons][50];
            }
            for (int ip = 0; ip < 2; ++ip) {
                this.ph[ip].transform(this.rotation[ip], 1.0);
            }
            if (this.bgt == null) {
                this.bgt = new BgTiler((Applet)this, w, h);
            }
            this.d(this.o, w, h, this.bgt.tile(this.o));
            g.drawImage(this.I, 0, 0, null);
            this.maybeShowStatus(g);
            ++this.F;
        }
    }

    public void d(Graphics g, int w, int h, boolean TB) {
        int gn;
        int i;
        int wc = w / 2;
        int hc = h / 2;
        int rad = Math.min(wc, hc) - 4;
        if (!TB) {
            g.setColor(Color.white);
            g.fillRect(0, 0, w, h);
        }
        Vector igons = Polyhedron.faceIntersections((Polyhedron[])this.ph, (int)53);
        int ngons = 0;
        for (int ip = 0; ip < 1; ++ip) {
            Polyhedron phA = this.ph[ip];
            int nf = phA.NF;
            double[][] normals = phA.faces;
            for (int jf = 0; jf < nf; ++jf) {
                double brightness;
                double[] norm = normals[jf];
                this.sf[jf] = norm[2] > 0.0;
                double ndl = 0.0;
                for (int i2 = 0; i2 < 3; ++i2) {
                    ndl += norm[i2] * this.lum[i2];
                }
                this.sb[jf] = brightness = this.lum[2] - 2.0 * ndl * norm[2];
            }
            ngons += nf;
        }
        int np = igons.size();
        for (i = 0; i < np; ++i) {
            this.gons[ngons++] = (Gon3D)igons.elementAt(i);
        }
        for (i = 0; i < ngons; ++i) {
            Gon3D gnd = this.gons[i];
            double[][] gi = gnd.vertices;
            gn = gnd.nvert;
            int[] xpi = this.xp[i];
            int[] ypi = this.yp[i];
            for (int j = 0; j <= gn; ++j) {
                double[] gk = gi[j % gn];
                xpi[j] = (int)((double)wc + (double)rad * gk[0]);
                ypi[j] = (int)((double)hc + (double)rad * gk[1]);
            }
        }
        for (int pass = 0; pass < 6; ++pass) {
            for (int i3 = 0; i3 < ngons; ++i3) {
                int gc;
                boolean seg;
                Gon3D gnd = this.gons[i3];
                gn = gnd.nvert;
                int fi = gnd.surfaceID;
                double brightness = this.sb[fi];
                boolean front = this.sf[fi];
                boolean back = !front;
                boolean full = gnd.flags == 0;
                boolean bl = seg = !full;
                int n = full ? 0 : (gc = front ? 1 : 2);
                if (pass == 0 && front && full || pass == 2 && back && seg || pass == 3 && front && seg) {
                    g.setColor(this.palette[gc][back ? 0 : (brightness < 0.1 ? 0 : (brightness > 0.6 ? 2 : 1))]);
                    g.fillPolygon(this.xp[i3], this.yp[i3], gn);
                    continue;
                }
                if (!(pass == 1 && back && full || pass == 4 && front && seg) && (pass != 5 || !front || !full)) continue;
                g.setColor(this.palette[gc][front ? 0 : 2]);
                g.drawPolygon(this.xp[i3], this.yp[i3], gn + 1);
            }
        }
    }

    @Override
    public void showStatus(String s) {
        super.showStatus(s);
        this.statusString = s;
    }

    void maybeShowStatus(Graphics g) {
        if (this.statusString.length() != 0) {
            GraphicsUtils.showStatus((String)this.statusString, (Graphics)g, (Component)this);
        }
    }

    @Override
    public synchronized void mouseEntered(MouseEvent e) {
        this.mouseIN = true;
        this.showStatus("Click to redraw");
    }

    @Override
    public synchronized void mouseExited(MouseEvent e) {
        this.mouseIN = false;
        this.showStatus("");
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        this.F = 0L;
        this.mouseEntered(null);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

