/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.applets.A2;
import egan.util.Utils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;

public class SO4
extends A2 {
    private static final long serialVersionUID = 1L;
    boolean SO3mode = true;
    double[] spinAxis;
    Color[] palette;
    int nf = this.setNFrames(24);
    static final BasicStroke str = new BasicStroke(0.5f, 0, 2);
    static final RenderingHints aaON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    GeneralPath rhomb = new GeneralPath(0, 5);

    public boolean d(Graphics g, int w, int h, int p, int q, int f, boolean C, boolean TB, int L, int V) {
        if (C) {
            int nCubesAcross = 8;
            double cubeSpace = 0.25;
            double[] c = new double[3];
            int[] x = new int[5];
            int[] y = new int[5];
            int wc = w / 2;
            int hc = h / 2;
            double scale = 0.98 * (double)Math.min(wc, hc);
            double e = 1.0E-8;
            if (!TB) {
                g.setColor(Color.white);
                g.fillRect(0, 0, w, h);
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(str);
            g2.addRenderingHints(aaON);
            if (f == 0) {
                boolean bl = this.SO3mode = !this.SO3mode;
                if (this.statusString.length() != 0) {
                    this.mouseEntered(null);
                }
                this.spinAxis = Utils.randomUnitVec(null, (boolean)false);
                this.palette = new Color[24];
                float min = 0.2f;
                float range = 1.0f - min;
                float mid = min + range / 2.0f;
                for (int i1 = 1; i1 < 4; ++i1) {
                    for (int i2 = 0; i2 < i1; ++i2) {
                        for (int s1 = 0; s1 < 2; ++s1) {
                            for (int s2 = 0; s2 < 2; ++s2) {
                                int ci = s1 + 2 * s2 + 4 * (i2 + i1 * (i1 - 1) / 2);
                                float[] fc = new float[4];
                                fc[i1] = 0.707f * (float)(1 - 2 * s1);
                                fc[i2] = 0.707f * (float)(1 - 2 * s2);
                                double psi = Math.acos(fc[3]);
                                double theta = Math.acos((double)fc[2] / Math.sin(psi));
                                this.palette[ci] = new Color(Color.HSBtoRGB((0.2f + (float)(0.5 + 0.5 * Math.atan2(fc[1], fc[0]) / Math.PI)) % 1.0f, mid + range * (float)(theta / Math.PI - 0.5), mid + range * (float)(psi / Math.PI - 0.25)));
                            }
                        }
                    }
                }
            }
            double angle = ((double)f + e) * this.frameA;
            double sa = Math.sin(angle);
            double fqa = Math.cos(angle);
            double fqb = sa * this.spinAxis[0];
            double fqc = sa * this.spinAxis[1];
            double fqd = sa * this.spinAxis[2];
            double[][] fqL = new double[][]{{fqa, -fqd, fqc, fqb}, {fqd, fqa, -fqb, fqc}, {-fqc, fqb, fqa, fqd}, {-fqb, -fqc, -fqd, fqa}};
            double[][] rotBasis = new double[4][4];
            double[][] rot3 = new double[4][4];
            rot3[3][3] = 1.0;
            Object cubeRot = null;
            double oneP = 1.0 + e;
            double twoP = 2.0 + e;
            double threeP = 3.0 + e;
            for (double dObs = -2.75; dObs <= threeP; dObs += 0.25) {
                c[0] = -1.0;
                while (c[0] <= oneP && c[0] <= dObs + twoP) {
                    if (c[0] >= dObs - twoP) {
                        c[1] = -1.0;
                        while (c[1] <= oneP) {
                            double d;
                            c[2] = dObs - c[0] - c[1];
                            if (!(d >= -oneP)) break;
                            if (c[2] <= oneP) {
                                double d2;
                                double r = Math.sqrt(c[0] * c[0] + c[1] * c[1] + c[2] * c[2]);
                                if (d2 <= oneP && (c[0] <= e || c[1] <= e)) {
                                    if (this.SO3mode) {
                                        angle = Math.PI * r;
                                        Utils.setRotation((double[][])rot3, (double)angle, (double[])c, (double)r);
                                        cubeRot = rot3;
                                    } else {
                                        angle = Math.PI * r / 2.0;
                                        double srr = r == 0.0 ? 0.0 : Math.sin(angle) / r;
                                        double cqa = Math.cos(angle);
                                        double cqb = srr * c[0];
                                        double cqc = srr * c[1];
                                        double cqd = srr * c[2];
                                        double[][] cqR = new double[][]{{cqa, cqd, -cqc, cqb}, {-cqd, cqa, cqb, cqc}, {cqc, -cqb, cqa, cqd}, {-cqb, -cqc, -cqd, cqa}};
                                        cubeRot = cqR;
                                    }
                                    for (int i = 0; i < 4; ++i) {
                                        for (int j = 0; j < 4; ++j) {
                                            double sum = 0.0;
                                            for (int k = 0; k < 4; ++k) {
                                                sum += cubeRot[k][i] * fqL[j][k];
                                            }
                                            rotBasis[i][j] = sum;
                                        }
                                    }
                                    int xc = wc + (int)(scale * (0.707 * (c[1] - c[0])));
                                    int yc = hc + (int)(scale * (0.05 + 0.408 * (c[0] + c[1] - 2.0 * c[2])));
                                    this.hyper(g2, xc, yc, scale * 0.25 / 4.0, rotBasis);
                                }
                            }
                            c[1] = c[1] + 0.25;
                        }
                    }
                    c[0] = c[0] + 0.25;
                }
            }
        }
        return C;
    }

    public void hyper(Graphics2D g2, int xc, int yc, double scale, double[][] basis) {
        int[] hcval = new int[4];
        for (int i = 0; i < 4; ++i) {
            hcval[i] = basis[i][3] < 0.0 ? -1 : 1;
        }
        int[] ix = new int[]{-1, -1, 1, 1, -1};
        int[] iy = new int[]{-1, 1, 1, -1, -1};
        double[] cp = new double[3];
        double[] v = new double[3];
        for (int hod = 0; hod < 4; ++hod) {
            for (int fod = 0; fod < 4; ++fod) {
                if (fod == hod) continue;
                for (int fos = -1; fos <= 1; fos += 2) {
                    int s2;
                    int s1;
                    int i2;
                    int i1;
                    if (hcval[fod] == fos) continue;
                    int hos = hcval[hod];
                    double[] bh = basis[hod];
                    double[] bf = basis[fod];
                    double[] b1 = null;
                    double[] b2 = null;
                    for (int i = 0; i < 4; ++i) {
                        if (i == hod || i == fod) continue;
                        if (b1 == null) {
                            b1 = basis[i];
                            continue;
                        }
                        b2 = basis[i];
                    }
                    double dp = 0.0;
                    for (int k = 0; k < 3; ++k) {
                        int k1 = (k + 1) % 3;
                        int k2 = (k + 2) % 3;
                        double cpk = cp[k] = b1[k1] * b2[k2] - b1[k2] * b2[k1];
                        dp += cpk * bf[k];
                    }
                    if ((double)fos * dp * (cp[0] + cp[1] + cp[2]) < 0.0) continue;
                    this.rhomb.reset();
                    for (int i = 0; i < 4; ++i) {
                        for (int j = 0; j < 3; ++j) {
                            v[j] = (double)hos * bh[j] + (double)fos * bf[j] + (double)ix[i] * b1[j] + (double)iy[i] * b2[j];
                        }
                        double x = (double)xc + scale * (0.707 * (v[1] - v[0]));
                        double y = (double)yc + scale * (0.408 * (v[0] + v[1] - 2.0 * v[2]));
                        if (i == 0) {
                            this.rhomb.moveTo((float)x, (float)y);
                            continue;
                        }
                        this.rhomb.lineTo((float)x, (float)y);
                    }
                    this.rhomb.closePath();
                    if (hod > fod) {
                        i1 = hod;
                        i2 = fod;
                        s1 = hos;
                        s2 = fos;
                    } else {
                        i2 = hod;
                        i1 = fod;
                        s2 = hos;
                        s1 = fos;
                    }
                    int ci = (s1 + 1) / 2 + (s2 + 1) + 4 * (i2 + i1 * (i1 - 1) / 2);
                    g2.setPaint(this.palette[ci]);
                    g2.fill(this.rhomb);
                    g2.setPaint(Color.black);
                    g2.draw(this.rhomb);
                }
            }
        }
    }

    public synchronized void mouseEntered(MouseEvent e) {
        String[] modes = new String[]{"T(v)=LvR", "T(v)=LRvR^{-1}"};
        int nm = this.SO3mode ? 1 : 0;
        this.showStatus(modes[nm] + "; click for " + modes[1 - nm]);
    }
}

