/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.geometry.SphericalTriangle;
import egan.graphics.BgTiler;
import egan.graphics.GraphicsUtils;
import egan.util.Utils;
import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;
import java.util.BitSet;

public class Slice
extends Applet
implements Runnable,
MouseListener {
    private static final long serialVersionUID = 1L;
    static final BasicStroke str = new BasicStroke(0.75f, 0, 2);
    static final RenderingHints aaON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    GeneralPath rhomb = new GeneralPath(0, 5);
    long F = 0L;
    long pt = 0L;
    long tStep = 100L;
    private volatile Thread a;
    Image I;
    Graphics o;
    BgTiler bgt = null;
    int PTYPES = 6;
    String[] pNames = new String[]{"4-simplex", "cross-polytope", "hypercube", "24-cell", "600-cell", "120-cell"};
    boolean mouseIN = false;
    int ptype = 3;
    int dim = 4;
    int dm1 = this.dim - 1;
    double[] e1 = new double[3];
    double[] e2 = new double[3];
    int[] xx;
    int[] yy;
    int nshades = 4;
    Color[][] palette;
    double[] lum;
    int nvertices;
    double[][] vertices;
    int nedges;
    int[][] edges;
    boolean[][][] faceInCommon;
    int nhyperfaces;
    int[][] hyperfaces;
    int edgesPerHyperface;
    double[][] cutPoints;
    boolean[] isCut;
    int[][] pixCutPoints;
    int[][] faces;
    int[] faceSize;
    int[] faceHyperface;
    double[][] faceNormals;
    double[] faceBrightness;
    double[][] rotation;
    String statusString = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.addMouseListener(this);
        Thread thisThread = Thread.currentThread();
        while (this.a == thisThread) {
            long t = System.currentTimeMillis();
            Slice slice = this;
            synchronized (slice) {
                if (t - this.pt > this.tStep || t < this.pt) {
                    this.repaint();
                }
            }
            try {
                Thread.sleep(20L);
            }
            catch (Exception e) {
                break;
            }
        }
    }

    @Override
    public void start() {
        this.a = new Thread(this);
        this.a.start();
        this.a.setPriority(1);
    }

    @Override
    public void stop() {
        this.a = null;
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public synchronized void update(Graphics g) {
        long t = System.currentTimeMillis();
        if (t - this.pt >= this.tStep || t < this.pt) {
            this.pt = t;
            int w = this.getSize().width;
            int h = this.getSize().height;
            if (this.F == 0L) {
                int l;
                int ie;
                boolean dual600;
                this.I = this.createImage(w, h);
                this.o = this.I.getGraphics();
                this.ptype = this.ptype < 0 ? (int)(Math.random() * (double)this.PTYPES) : (this.ptype + 1) % this.PTYPES;
                this.faceInCommon = null;
                boolean cell600 = this.ptype == 4;
                boolean bl = dual600 = this.ptype == 5;
                if (this.ptype == 0) {
                    double[][] fsv = new double[][]{{0.9128709291752769, 0.0, -0.3227486121839514, -0.25}, {-0.45643546458763845, 0.7905694150420949, -0.3227486121839514, -0.25}, {-0.45643546458763845, -0.7905694150420949, -0.3227486121839514, -0.25}, {0.0, 0.0, 0.9682458365518543, -0.25}, {0.0, 0.0, 0.0, 1.0}};
                    this.vertices = fsv;
                    this.nvertices = 5;
                    this.nhyperfaces = 5;
                    this.edgesPerHyperface = 6;
                    this.hyperfaces = new int[this.nhyperfaces][this.edgesPerHyperface];
                    int[] edgecount = new int[this.nhyperfaces];
                    this.nedges = 10;
                    this.edges = new int[this.nedges][2];
                    ie = 0;
                    for (int i = 0; i < this.nvertices - 1; ++i) {
                        for (int j = i + 1; j < this.nvertices; ++j) {
                            this.edges[ie][0] = i;
                            this.edges[ie][1] = j;
                            for (int k = 0; k < this.nhyperfaces; ++k) {
                                if (i == k || j == k) continue;
                                int n = k;
                                int n2 = edgecount[n];
                                edgecount[n] = n2 + 1;
                                this.hyperfaces[k][n2] = ie;
                            }
                            ++ie;
                        }
                    }
                } else if (this.ptype == 1) {
                    this.nvertices = 2 * this.dim;
                    this.vertices = new double[this.nvertices][this.dim];
                    for (int i = 0; i < this.nvertices; ++i) {
                        for (int j = 0; j < this.dim; ++j) {
                            this.vertices[i][j] = j == i / 2 ? (double)(i % 2 == 0 ? 1 : -1) : 0.0;
                        }
                    }
                    this.nhyperfaces = 1 << this.dim;
                    this.edgesPerHyperface = this.dim * this.dm1 / 2;
                    this.hyperfaces = new int[this.nhyperfaces][this.edgesPerHyperface];
                    int[] edgecount = new int[this.nhyperfaces];
                    this.nedges = this.nvertices * this.dm1;
                    this.edges = new int[this.nedges][2];
                    ie = 0;
                    int twoDim2 = 1 << this.dim - 2;
                    for (int i = 0; i < this.nvertices - 1; ++i) {
                        int idim = i / 2;
                        int ibit = i % 2 << idim;
                        for (int j = i + 1; j < this.nvertices; ++j) {
                            int jdim = j / 2;
                            if (idim == jdim) continue;
                            this.edges[ie][0] = i;
                            this.edges[ie][1] = j;
                            int jbit = j % 2 << jdim;
                            for (int k = 0; k < twoDim2; ++k) {
                                int l2 = ibit | jbit;
                                int n = 0;
                                for (int m = 0; m < this.dim; ++m) {
                                    if (m == idim || m == jdim) continue;
                                    l2 |= (k >> n++ & 1) << m;
                                }
                                int n3 = l2;
                                int n4 = edgecount[n3];
                                edgecount[n3] = n4 + 1;
                                this.hyperfaces[l2][n4] = ie;
                            }
                            ++ie;
                        }
                    }
                } else if (this.ptype == 2) {
                    this.nvertices = 1 << this.dim;
                    this.vertices = new double[this.nvertices][this.dim];
                    double normalise = Math.sqrt(this.dim);
                    for (int i = 0; i < this.nvertices; ++i) {
                        for (int j = 0; j < this.dim; ++j) {
                            this.vertices[i][j] = (double)((i & 1 << j) == 0 ? 1 : -1) / normalise;
                        }
                    }
                    this.nhyperfaces = 2 * this.dim;
                    this.edgesPerHyperface = this.dm1 * (1 << this.dim - 2);
                    this.hyperfaces = new int[this.nhyperfaces][this.edgesPerHyperface];
                    int[] edgecount = new int[this.nhyperfaces];
                    this.nedges = this.dim * (1 << this.dm1);
                    this.edges = new int[this.nedges][2];
                    this.faceInCommon = new boolean[this.nhyperfaces][this.edgesPerHyperface][this.edgesPerHyperface];
                    ie = 0;
                    for (int i = 0; i < this.nvertices - 1; ++i) {
                        for (int m = 0; m < this.dim; ++m) {
                            int j = i ^ 1 << m;
                            if (j <= i) continue;
                            this.edges[ie][0] = i;
                            this.edges[ie][1] = j;
                            for (l = 0; l < this.dim; ++l) {
                                int n;
                                if (l == m) continue;
                                int n5 = n = 2 * l + (i >> l & 1);
                                int n6 = edgecount[n5];
                                edgecount[n5] = n6 + 1;
                                this.hyperfaces[n][n6] = ie;
                            }
                            ++ie;
                        }
                    }
                    for (int hf = 0; hf < this.nhyperfaces; ++hf) {
                        int[] hfe = this.hyperfaces[hf];
                        boolean[][] fic = this.faceInCommon[hf];
                        for (int i = 0; i < this.edgesPerHyperface - 1; ++i) {
                            int[] ehfei = this.edges[hfe[i]];
                            int p1 = ehfei[0];
                            int p2 = ehfei[1];
                            int di = p1 ^ p2;
                            for (int j = i + 1; j < this.edgesPerHyperface; ++j) {
                                int[] ehfej = this.edges[hfe[j]];
                                int q1 = ehfej[0];
                                int q2 = ehfej[1];
                                int dj = q1 ^ q2;
                                boolean ok = false;
                                if (di == dj) {
                                    int mask = ~di;
                                    int pz = p1 & mask;
                                    int qz = q1 & mask;
                                    for (int k = 0; k < this.dim; ++k) {
                                        if (pz != (qz ^ 1 << k)) continue;
                                        ok = true;
                                        break;
                                    }
                                } else if (p1 == q1 || p1 == q2 || p2 == q1 || p2 == q2) {
                                    ok = true;
                                }
                                boolean bl2 = ok;
                                fic[j][i] = bl2;
                                fic[i][j] = bl2;
                            }
                        }
                    }
                } else if (this.ptype == 3) {
                    int i;
                    int i2;
                    this.nvertices = 24;
                    this.vertices = new double[this.nvertices][this.dim];
                    for (i2 = 0; i2 < 8; ++i2) {
                        for (int j = 0; j < this.dim; ++j) {
                            this.vertices[i2][j] = j == i2 / 2 ? (double)(i2 % 2 == 0 ? 1 : -1) : 0.0;
                        }
                    }
                    for (i2 = 8; i2 < 24; ++i2) {
                        int i1 = i2 - 8;
                        for (int j = 0; j < this.dim; ++j) {
                            this.vertices[i2][j] = (i1 & 1 << j) == 0 ? 0.5 : -0.5;
                        }
                    }
                    this.nhyperfaces = 24;
                    this.edgesPerHyperface = 12;
                    this.hyperfaces = new int[this.nhyperfaces][this.edgesPerHyperface];
                    int[] edgecount = new int[this.nhyperfaces];
                    this.nedges = 96;
                    this.edges = new int[this.nedges][2];
                    ie = 0;
                    for (i = 0; i < 8; ++i) {
                        int idim = i / 2;
                        int ival = i % 2;
                        int ibit = ival << idim;
                        for (int k = 0; k < 8; ++k) {
                            l = ibit;
                            int n = 0;
                            for (int m = 0; m < 4; ++m) {
                                if (m == idim) continue;
                                l |= (k >> n++ & 1) << m;
                            }
                            int j = 8 + l;
                            this.edges[ie][0] = i;
                            this.edges[ie][1] = j;
                            for (int q = 0; q < 4; ++q) {
                                int z;
                                if (q == idim) continue;
                                int n7 = z = Slice.hf24(idim, ival, q, l >> q & 1);
                                int n8 = edgecount[n7];
                                edgecount[n7] = n8 + 1;
                                this.hyperfaces[z][n8] = ie;
                            }
                            ++ie;
                        }
                    }
                    for (i = 8; i < 23; ++i) {
                        int im8 = i - 8;
                        for (int b = 0; b < 4; ++b) {
                            int jm8 = im8 ^ 1 << b;
                            if (jm8 <= im8) continue;
                            int j = jm8 + 8;
                            this.edges[ie][0] = i;
                            this.edges[ie][1] = j;
                            for (int q = 0; q < 3; ++q) {
                                if (q == b) continue;
                                int im8q = im8 >> q & 1;
                                for (int r = q + 1; r < 4; ++r) {
                                    int z;
                                    if (r == b) continue;
                                    int n = z = Slice.hf24(q, im8q, r, im8 >> r & 1);
                                    int n9 = edgecount[n];
                                    edgecount[n] = n9 + 1;
                                    this.hyperfaces[z][n9] = ie;
                                }
                            }
                            ++ie;
                        }
                    }
                } else if (cell600 || dual600) {
                    int mf = 5;
                    int ns = 3;
                    int[][] vA = new int[][]{{1, mf}, {1, 2}, {1, ns}};
                    SphericalTriangle canonical = new SphericalTriangle((int[][])vA);
                    SphericalTriangle[] tiles = canonical.tiling(120);
                    this.nvertices = 120;
                    this.vertices = new double[this.nvertices][4];
                    int[] tindx = new int[this.nvertices];
                    int np = 0;
                    for (int i = 0; i < 120; ++i) {
                        SphericalTriangle ti = tiles[i];
                        if (ti.parity != 1) continue;
                        this.vertices[np] = Slice.quaternionFromRotation(ti.isometry);
                        double[] q = this.vertices[np];
                        double[] dArray = new double[4];
                        this.vertices[np + 60] = dArray;
                        double[] mq = dArray;
                        for (int j = 0; j < 4; ++j) {
                            mq[j] = -q[j];
                        }
                        tindx[np] = i;
                        ti.id = np++;
                    }
                    this.nhyperfaces = 600;
                    this.edgesPerHyperface = 6;
                    this.hyperfaces = new int[this.nhyperfaces][this.edgesPerHyperface];
                    this.nedges = 720;
                    this.edges = new int[this.nedges][2];
                    double csd = 2.0 * (1.0 - Math.cos(0.6283185307179586));
                    double eps = 0.001;
                    int[][] nearLinks = new int[12][];
                    int nlc = 0;
                    for (int j = 1; j < this.nvertices; ++j) {
                        if (!(Math.abs(Slice.dsq(this.vertices[0], this.vertices[j]) - csd) < eps)) continue;
                        nearLinks[nlc++] = tiles[tindx[j]].steps;
                        if (nlc == 12) break;
                    }
                    int[][] vv = new int[this.nvertices][12];
                    int[][] vvEdge = new int[this.nvertices][this.nvertices];
                    ie = 0;
                    for (int ii = 0; ii < 60; ++ii) {
                        for (int k = 0; k < 12; ++k) {
                            SphericalTriangle ti = tiles[tindx[ii]];
                            int[] steps = nearLinks[k];
                            int nsteps = steps.length;
                            for (int l3 = 0; l3 < nsteps; ++l3) {
                                ti = ti.links[steps[l3]];
                            }
                            int jj = ti.id;
                            if (Slice.dsq(this.vertices[ii], this.vertices[jj]) > csd + eps) {
                                jj += 60;
                            }
                            for (int offs = 0; offs <= 60; offs += 60) {
                                int j;
                                int i = ii + offs;
                                vv[i][k] = j = (jj + offs) % 120;
                                if (j <= i) continue;
                                this.edges[ie][0] = i;
                                this.edges[ie][1] = j;
                                int n = 1 + ie;
                                vvEdge[j][i] = n;
                                vvEdge[i][j] = n;
                                ++ie;
                            }
                        }
                    }
                    int nDualVertices = this.nhyperfaces;
                    double[][] dualVertices = null;
                    int nDualHyperfaces = this.nvertices;
                    int edgesPerDualHyperface = 30;
                    int[][] dualHyperfaces = null;
                    int nDualEdges = 1200;
                    int[][] dualEdges = null;
                    BitSet[][] dualEdgeFlags = null;
                    int[][][] dualEdgeFaces = null;
                    int[] hec = null;
                    int nde = 0;
                    if (dual600) {
                        dualVertices = new double[nDualVertices][4];
                        dualHyperfaces = new int[nDualHyperfaces][edgesPerDualHyperface];
                        dualEdges = new int[nDualEdges][2];
                        dualEdgeFlags = new BitSet[nDualHyperfaces][edgesPerDualHyperface];
                        dualEdgeFaces = new int[nDualHyperfaces][edgesPerDualHyperface][2];
                        hec = new int[nDualHyperfaces];
                    }
                    int ntet = 0;
                    int[] tvc = new int[this.nvertices];
                    BitSet[][] vtl = new BitSet[this.nvertices][20];
                    block37: for (int i = 0; i < this.nvertices; ++i) {
                        if (tvc[i] >= 20) continue;
                        int[] vvi = vv[i];
                        for (int j = 0; j < 10; ++j) {
                            int vj = vvi[j];
                            for (int k = j + 1; k < 11; ++k) {
                                int vk = vvi[k];
                                if (vvEdge[vj][vk] <= 0) continue;
                                for (int l4 = k + 1; l4 < 12; ++l4) {
                                    int m;
                                    int vl = vvi[l4];
                                    if (vvEdge[vj][vl] <= 0 || vvEdge[vk][vl] <= 0) continue;
                                    BitSet tetFlags = new BitSet(120);
                                    tetFlags.set(i);
                                    tetFlags.set(vj);
                                    tetFlags.set(vk);
                                    tetFlags.set(vl);
                                    int n = tvc[i];
                                    for (m = 0; m < n && !tetFlags.equals(vtl[i][m]); ++m) {
                                    }
                                    if (m != n) continue;
                                    int[] tet = this.hyperfaces[ntet];
                                    tet[0] = vvEdge[i][vj] - 1;
                                    tet[1] = vvEdge[i][vk] - 1;
                                    tet[2] = vvEdge[i][vl] - 1;
                                    tet[3] = vvEdge[vj][vk] - 1;
                                    tet[4] = vvEdge[vk][vl] - 1;
                                    tet[5] = vvEdge[vl][vj] - 1;
                                    int[] vtx = new int[]{i, vj, vk, vl};
                                    for (int z = 0; z < 4; ++z) {
                                        int y;
                                        int n10 = y = vtx[z];
                                        int n11 = tvc[n10];
                                        tvc[n10] = n11 + 1;
                                        vtl[y][n11] = tetFlags;
                                    }
                                    if (dual600) {
                                        int z;
                                        double[] dv = dualVertices[ntet];
                                        for (z = 0; z < 4; ++z) {
                                            double[] vtxz = this.vertices[vtx[z]];
                                            for (int q = 0; q < 4; ++q) {
                                                int n12 = q;
                                                dv[n12] = dv[n12] + vtxz[q] / 4.0;
                                            }
                                        }
                                        Utils.normalise((double[])dv);
                                        for (z = 0; z < 4; ++z) {
                                            BitSet def = (BitSet)tetFlags.clone();
                                            def.clear(vtx[z]);
                                            int y = (z + 1) % 4;
                                            int dh = vtx[y];
                                            n = hec[dh];
                                            for (m = 0; m < n && !def.equals(dualEdgeFlags[dh][m]); ++m) {
                                            }
                                            if (m == n) {
                                                for (y = 0; y < 4; ++y) {
                                                    if (y == z) continue;
                                                    dh = vtx[y];
                                                    n = hec[dh];
                                                    dualEdgeFlags[dh][n] = def;
                                                    dualHyperfaces[dh][n] = nde;
                                                    int count = 0;
                                                    for (int x = 0; x < 4; ++x) {
                                                        if (x == z || x == y) continue;
                                                        dualEdgeFaces[dh][n][count++] = vvEdge[dh][vtx[x]] - 1;
                                                    }
                                                    int n13 = dh;
                                                    hec[n13] = hec[n13] + 1;
                                                }
                                                dualEdges[nde][0] = ntet;
                                                ++nde;
                                                continue;
                                            }
                                            dualEdges[dualHyperfaces[dh][m]][1] = ntet;
                                        }
                                    }
                                    ++ntet;
                                    if (tvc[i] == 20) continue block37;
                                }
                            }
                        }
                    }
                    if (dual600) {
                        this.faceInCommon = new boolean[nDualHyperfaces][edgesPerDualHyperface][edgesPerDualHyperface];
                        for (int hf = 0; hf < nDualHyperfaces; ++hf) {
                            int[][] df = dualEdgeFaces[hf];
                            boolean[][] fic = this.faceInCommon[hf];
                            for (int i = 0; i < edgesPerDualHyperface - 1; ++i) {
                                int[] dfi = df[i];
                                int dfi0 = dfi[0];
                                int dfi1 = dfi[1];
                                for (int j = i + 1; j < edgesPerDualHyperface; ++j) {
                                    int[] dfj = df[j];
                                    int dfj0 = dfj[0];
                                    int dfj1 = dfj[1];
                                    if (dfi0 != dfj0 && dfi0 != dfj1 && dfi1 != dfj0 && dfi1 != dfj1) continue;
                                    fic[j][i] = true;
                                    fic[i][j] = true;
                                }
                            }
                        }
                        this.nvertices = nDualVertices;
                        this.vertices = dualVertices;
                        this.nhyperfaces = nDualHyperfaces;
                        this.edgesPerHyperface = edgesPerDualHyperface;
                        this.hyperfaces = dualHyperfaces;
                        this.nedges = nDualEdges;
                        this.edges = dualEdges;
                    }
                }
                if (this.faceInCommon == null) {
                    this.faceInCommon = new boolean[this.nhyperfaces][this.edgesPerHyperface][this.edgesPerHyperface];
                    for (int hf = 0; hf < this.nhyperfaces; ++hf) {
                        int[] hfe = this.hyperfaces[hf];
                        boolean[][] fic = this.faceInCommon[hf];
                        for (int i = 0; i < this.edgesPerHyperface - 2; ++i) {
                            int[] ehfei = this.edges[hfe[i]];
                            int p1 = ehfei[0];
                            int p2 = ehfei[1];
                            for (int j = i + 1; j < this.edgesPerHyperface - 1; ++j) {
                                int[] ehfej = this.edges[hfe[j]];
                                int q1 = ehfej[0];
                                int q2 = ehfej[1];
                                for (int k = j + 1; k < this.edgesPerHyperface; ++k) {
                                    int[] ehfek = this.edges[hfe[k]];
                                    int r1 = ehfek[0];
                                    int r2 = ehfek[1];
                                    int[] va = new int[]{p1, p2, q1, q2, r1, r2};
                                    boolean ok = true;
                                    for (int l5 = 0; l5 < 6 && ok; ++l5) {
                                        int count = 0;
                                        for (int m = 0; m < 6; ++m) {
                                            if (m == l5 || va[m] != va[l5]) continue;
                                            ++count;
                                        }
                                        ok = count == 1;
                                    }
                                    if (!ok) continue;
                                    fic[j][i] = true;
                                    fic[i][j] = true;
                                    fic[k][i] = true;
                                    fic[i][k] = true;
                                    fic[k][j] = true;
                                    fic[j][k] = true;
                                }
                            }
                        }
                    }
                }
                this.cutPoints = new double[this.nedges][this.dim];
                this.isCut = new boolean[this.nedges];
                this.pixCutPoints = new int[this.nedges][2];
                this.faces = new int[this.nhyperfaces][this.edgesPerHyperface];
                this.faceSize = new int[this.nhyperfaces];
                this.faceHyperface = new int[this.nhyperfaces];
                this.faceNormals = new double[this.nhyperfaces][3];
                this.faceBrightness = new double[this.nhyperfaces];
                this.xx = new int[this.edgesPerHyperface + 1];
                this.yy = new int[this.edgesPerHyperface + 1];
                double[][] prevR = null;
                double[][] newR = null;
                for (int d1 = 0; d1 < 3; ++d1) {
                    for (int d2 = d1 + 1; d2 < 4; ++d2) {
                        int j;
                        double angle = 0.01 * (2.0 + Math.random());
                        double[][] rm = new double[this.dim][this.dim];
                        for (j = 0; j < this.dim; ++j) {
                            rm[j][j] = 1.0;
                        }
                        double d = Math.cos(angle);
                        rm[d2][d2] = d;
                        rm[d1][d1] = d;
                        rm[d1][d2] = Math.sin(angle);
                        rm[d2][d1] = -rm[d1][d2];
                        if (prevR == null) {
                            prevR = rm;
                            continue;
                        }
                        if (newR == null) {
                            newR = new double[this.dim][this.dim];
                        }
                        for (j = 0; j < this.dim; ++j) {
                            for (int k = 0; k < this.dim; ++k) {
                                double s = 0.0;
                                for (int l6 = 0; l6 < this.dim; ++l6) {
                                    s += prevR[j][l6] * rm[l6][k];
                                }
                                newR[j][k] = s;
                            }
                        }
                        double[][] tmp = prevR;
                        prevR = newR;
                        newR = tmp;
                    }
                }
                this.rotation = prevR;
                this.palette = GraphicsUtils.randomPalette((int)this.nhyperfaces, (int)this.nshades, (int)0);
                this.lum = Utils.randomUnitVec(null, (boolean)false);
            }
            for (int i = 0; i < this.nvertices; ++i) {
                Utils.transform((double[][])this.rotation, (double[])this.vertices[i]);
            }
            if (this.bgt == null) {
                this.bgt = new BgTiler((Applet)this, w, h);
            }
            this.d(this.o, w, h, this.bgt.tile(this.o));
            g.drawImage(this.I, 0, 0, null);
            this.maybeShowStatus(g);
            ++this.F;
        }
    }

    public void d(Graphics g, int w, int h, boolean TB) {
        int i;
        int wc = w / 2;
        int hc = h / 2;
        int rad = Math.min(wc, hc) - 4;
        if (!TB) {
            g.setColor(Color.white);
            g.fillRect(0, 0, w, h);
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHints(aaON);
        g2.setStroke(str);
        double slice = 0.0;
        for (int i2 = 0; i2 < this.nedges; ++i2) {
            int[] ei = this.edges[i2];
            int p1 = ei[0];
            double t1 = this.vertices[p1][this.dm1];
            int p2 = ei[1];
            double t2 = this.vertices[p2][this.dm1];
            double s2 = slice - t2;
            if ((slice - t1) * s2 < 0.0) {
                double lambda = s2 / (t1 - t2);
                double oml = 1.0 - lambda;
                double[] c = this.cutPoints[i2];
                for (int l = 0; l < this.dm1; ++l) {
                    c[l] = lambda * this.vertices[p1][l] + oml * this.vertices[p2][l];
                }
                this.isCut[i2] = true;
                this.pixCutPoints[i2][0] = wc + (int)((double)rad * c[0]);
                this.pixCutPoints[i2][1] = hc - (int)((double)rad * c[1]);
                continue;
            }
            this.isCut[i2] = false;
        }
        int nfaces = 0;
        for (i = 0; i < this.nhyperfaces; ++i) {
            int[] hfi = this.hyperfaces[i];
            int nfv = 0;
            int[] fn = this.faces[nfaces];
            for (int j = 0; j < this.edgesPerHyperface; ++j) {
                if (!this.isCut[hfi[j]]) continue;
                fn[nfv++] = j;
            }
            if (nfv == 0) continue;
            this.faceSize[nfaces] = nfv;
            this.faceHyperface[nfaces] = i;
            boolean[][] fici = this.faceInCommon[i];
            if (nfv > 3 || this.edgesPerHyperface > 6) {
                int pe = fn[0];
                block4: for (int j = 1; j < nfv; ++j) {
                    for (int k = j; k < nfv; ++k) {
                        int e = fn[k];
                        if (!fici[pe][e]) continue;
                        pe = e;
                        fn[k] = fn[j];
                        fn[j] = e;
                        continue block4;
                    }
                }
            }
            for (int j = 0; j < nfv; ++j) {
                fn[j] = hfi[fn[j]];
            }
            ++nfaces;
        }
        for (i = 0; i < nfaces; ++i) {
            int[] fn = this.faces[i];
            double[] pt1 = this.cutPoints[fn[0]];
            double[] pt2 = this.cutPoints[fn[1]];
            double[] pt3 = this.cutPoints[fn[2]];
            for (int j = 0; j < 3; ++j) {
                this.e1[j] = pt2[j] - pt1[j];
                this.e2[j] = pt3[j] - pt2[j];
            }
            double[] cp = this.faceNormals[i];
            Utils.cross((double[])this.e1, (double[])this.e2, (double[])cp);
            Utils.normalise((double[])cp);
            double ndl = Utils.dot((double[])cp, (double[])this.lum);
            this.faceBrightness[i] = this.lum[2] - 2.0 * ndl * cp[2];
            if (!(Utils.dot((double[])cp, (double[])pt1) < 0.0)) continue;
            cp[2] = -cp[2];
        }
        for (int pass = 0; pass < 2; ++pass) {
            for (int i3 = 0; i3 < nfaces; ++i3) {
                if (this.faceNormals[i3][2] < 0.0) continue;
                int nfv = this.faceSize[i3];
                int[] fn = this.faces[i3];
                for (int j = 0; j < nfv + 1; ++j) {
                    int k = j % nfv;
                    int[] pcp = this.pixCutPoints[fn[k]];
                    this.xx[j] = pcp[0];
                    this.yy[j] = pcp[1];
                }
                double bri = this.faceBrightness[i3];
                int ns = this.faceHyperface[i3];
                if (pass == 0) {
                    g.setColor(this.palette[ns][1 + (bri < 0.1 ? 0 : (bri > 0.6 ? 2 : 1))]);
                    g.fillPolygon(this.xx, this.yy, nfv);
                    continue;
                }
                g.setColor(Color.black);
                g.drawPolygon(this.xx, this.yy, nfv + 1);
            }
        }
        if (this.F == 0L && this.mouseIN) {
            this.mouseEntered(null);
        }
    }

    private static double[] quaternionFromRotation(double[][] mat) {
        double ab = (mat[2][1] - mat[1][2]) / 4.0;
        double ac = (mat[0][2] - mat[2][0]) / 4.0;
        double ad = (mat[1][0] - mat[0][1]) / 4.0;
        double bc = (mat[0][1] + mat[1][0]) / 4.0;
        double bd = (mat[0][2] + mat[2][0]) / 4.0;
        double cd = (mat[2][1] + mat[1][2]) / 4.0;
        double a2 = (1.0 + mat[0][0] + mat[1][1] + mat[2][2]) / 4.0;
        double b2 = (1.0 + mat[0][0] - mat[1][1] - mat[2][2]) / 4.0;
        double c2 = (1.0 - mat[0][0] + mat[1][1] - mat[2][2]) / 4.0;
        double d2 = (1.0 - mat[0][0] - mat[1][1] + mat[2][2]) / 4.0;
        double a = Math.sqrt(Math.abs(a2));
        double b = Math.sqrt(Math.abs(b2));
        double c = Math.sqrt(Math.abs(c2));
        double d = Math.sqrt(Math.abs(d2));
        double eps = 1.0E-5;
        if (a > eps) {
            b = ab / a;
            c = ac / a;
            d = ad / a;
        } else if (b > eps) {
            if (b * ab < 0.0) {
                b = -b;
            }
            a = ab / b;
            c = bc / b;
            d = bd / b;
        } else if (c > eps) {
            if (c * ac < 0.0) {
                c = -c;
            }
            a = ac / c;
            b = bc / c;
            d = cd / c;
        } else if (d > eps) {
            if (d * ad < 0.0) {
                d = -d;
            }
            a = ad / d;
            b = bd / d;
            c = cd / d;
        }
        double[] q = new double[]{a, b, c, d};
        return q;
    }

    private static double dsq(double[] a, double[] b) {
        double s = 0.0;
        for (int i = 0; i < 4; ++i) {
            double delta = a[i] - b[i];
            s += delta * delta;
        }
        return s;
    }

    private static int hf24(int d1, int b1, int d2, int b2) {
        int kbit;
        int k;
        int jbit;
        int j;
        if (d1 < d2) {
            j = d1;
            jbit = b1;
            k = d2;
            kbit = b2;
        } else {
            j = d2;
            jbit = b2;
            k = d1;
            kbit = b1;
        }
        return 4 * ((j == 0 ? -1 : j) + k) + 2 * kbit + jbit;
    }

    @Override
    public void showStatus(String s) {
        super.showStatus(s);
        this.statusString = s;
    }

    void maybeShowStatus(Graphics g) {
        if (this.statusString.length() != 0) {
            GraphicsUtils.showStatus((String)this.statusString, (Graphics)g, (Component)this);
        }
    }

    @Override
    public synchronized void mouseEntered(MouseEvent e) {
        this.mouseIN = true;
        this.showStatus("Slice through " + this.pNames[this.ptype] + "; click for next.");
    }

    @Override
    public synchronized void mouseExited(MouseEvent e) {
        this.mouseIN = false;
        this.showStatus("");
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        this.F = 0L;
        this.mouseIN = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

