/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.geometry.Gon3D;
import egan.geometry.Polyhedron;
import egan.graphics.BgTiler;
import egan.graphics.GraphicsUtils;
import egan.util.Utils;
import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.Vector;

public class Solid
extends Applet
implements Runnable,
MouseListener {
    private static final long serialVersionUID = 1L;
    long F = 0L;
    long pt = 0L;
    long tStep = 100L;
    private volatile Thread a;
    Image I;
    Graphics o;
    BgTiler bgt = null;
    int pair = -1;
    static final int npoly = 2;
    Polyhedron[] ph = new Polyhedron[2];
    int[] CF = new int[2];
    int TF;
    int[] faceBri;
    boolean[] faceFront;
    Gon3D[] faceGons;
    double[][][] rotation = new double[2][3][3];
    static final BasicStroke str = new BasicStroke(0.75f, 0, 2);
    static final RenderingHints aaON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    Line2D.Double line = new Line2D.Double();
    GeneralPath path = new GeneralPath(0, 20);
    static final int nshades = 5;
    Color[][] palette;
    double[] lum;
    double[] xp = new double[20];
    double[] yp = new double[20];
    int wc;
    int hc;
    int rad;
    String statusString = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.addMouseListener(this);
        Thread thisThread = Thread.currentThread();
        while (this.a == thisThread) {
            long t = System.currentTimeMillis();
            Solid solid = this;
            synchronized (solid) {
                if (t - this.pt > this.tStep || t < this.pt) {
                    this.repaint();
                }
            }
            try {
                Thread.sleep(20L);
            }
            catch (Exception e) {
                break;
            }
        }
    }

    @Override
    public void start() {
        this.a = new Thread(this);
        this.a.start();
        this.a.setPriority(1);
    }

    @Override
    public void stop() {
        this.a = null;
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public synchronized void update(Graphics g) {
        long t = System.currentTimeMillis();
        if (t - this.pt >= this.tStep || t < this.pt) {
            this.pt = t;
            int w = this.getSize().width;
            int h = this.getSize().height;
            if (this.F == 0L) {
                int nf;
                Polyhedron phA;
                int ip;
                this.I = this.createImage(w, h);
                this.o = this.I.getGraphics();
                int[][] indexList = new int[][]{{0, 0}, {1, 1}, {2, 2}, {3, 3}, {4, 4}};
                int ni = indexList.length;
                this.pair = this.pair < 0 ? (int)((double)ni * Math.random()) : (this.pair + 1) % ni;
                int[] index = indexList[this.pair];
                this.TF = 0;
                for (ip = 0; ip < 2; ++ip) {
                    phA = this.ph[ip] = Polyhedron.regularPolyhedron((int)index[ip]);
                    nf = phA.NF;
                    this.CF[ip] = this.TF;
                    this.TF += nf;
                    Utils.setRotation((double[][])this.rotation[ip], (double)(0.03 * (2.0 + Math.random())), (double[])Utils.randomUnitVec(null, (boolean)false), (double)1.0);
                }
                this.faceBri = new int[this.TF];
                this.faceFront = new boolean[this.TF];
                for (ip = 1; ip < 2; ++ip) {
                    phA = this.ph[ip];
                    nf = phA.NF;
                    this.faceGons = new Gon3D[nf];
                    for (int kf = 0; kf < nf; ++kf) {
                        int jf = this.CF[ip] + kf;
                        this.faceGons[kf] = phA.faceToGon3D(kf);
                        phA.faceToGon3D(kf).surfaceID = jf;
                    }
                }
                this.lum = Utils.randomUnitVec(null, (boolean)true);
                this.palette = GraphicsUtils.randomPalette((int)((int)(2.0 + 8.0 * Math.random())), (int)5, (int)0);
                this.wc = w / 2;
                this.hc = h / 2;
                this.rad = Math.min(this.wc, this.hc) - 4;
            }
            for (int ip = 0; ip < 2; ++ip) {
                this.ph[ip].transform(this.rotation[ip], 1.0);
            }
            if (this.bgt == null) {
                this.bgt = new BgTiler((Applet)this, w, h);
            }
            this.d(this.o, w, h, this.bgt.tile(this.o));
            g.drawImage(this.I, 0, 0, null);
            this.maybeShowStatus(g);
            ++this.F;
        }
    }

    public void d(Graphics g, int w, int h, boolean TB) {
        double tolerance = 1.0E-6;
        if (!TB) {
            g.setColor(Color.white);
            g.fillRect(0, 0, w, h);
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHints(aaON);
        g2.setStroke(str);
        for (int ip = 0; ip < 2; ++ip) {
            Polyhedron phA = this.ph[ip];
            int nf = phA.NF;
            double[][] fcn = phA.faces;
            double[][] vertices = phA.vertices;
            int[][] fv = phA.face_vertices;
            for (int kf = 0; kf < nf; ++kf) {
                boolean front;
                int[] fvk = fv[kf];
                int jf = this.CF[ip] + kf;
                double[] norm = fcn[kf];
                this.faceFront[jf] = front = norm[2] > 0.0;
                double fb = 0.0;
                if (front) {
                    double ndl = 0.0;
                    for (int i = 0; i < 3; ++i) {
                        ndl += norm[i] * this.lum[i];
                    }
                    fb = this.lum[2] - 2.0 * ndl * norm[2];
                }
                this.faceBri[jf] = 2 + Math.max(0, (int)(2.999 * fb));
            }
        }
        Vector extParts = Polyhedron.faceIntersections((Polyhedron[])this.ph, (int)25);
        Vector<Gon3D> back = new Vector<Gon3D>(this.TF);
        Vector<Gon3D> front = new Vector<Gon3D>(this.TF);
        int offset = this.CF[1];
        for (int iep = 0; iep < extParts.size(); ++iep) {
            Gon3D gnd = (Gon3D)extParts.elementAt(iep);
            int sid = gnd.surfaceID;
            int bc = 0;
            int fc = 0;
            int splitFace = 0;
            int nv = gnd.nvert;
            int[] eid = gnd.edgeIDs;
            for (int i = 0; i < nv; ++i) {
                int ei = eid[i];
                if ((ei & 0x18000000) == 0 || (ei & 0x20000000) != 0) continue;
                if (this.faceFront[offset + (ei &= 0xFFFF)]) {
                    ++fc;
                    int i1 = (i + 1) % nv;
                    int i2 = (i + nv - 1) % nv;
                    int ei1 = eid[i1];
                    int ei2 = eid[i2];
                    if (((ei1 & 0x18000000) == 0 || (ei1 & 0x20000000) != 0 || this.faceFront[offset + (ei1 & 0xFFFF)]) && ((ei2 & 0x18000000) == 0 || (ei2 & 0x20000000) != 0 || this.faceFront[offset + (ei2 & 0xFFFF)])) continue;
                    splitFace = ei;
                    continue;
                }
                ++bc;
            }
            if (bc == 0) {
                front.addElement(gnd);
                continue;
            }
            if (fc == 0) {
                back.addElement(gnd);
                continue;
            }
            gnd.BSPsplit(this.ph[1].faces[splitFace], 0x20000000, null, 1.0E-6, null, extParts, extParts, front);
        }
        Gon3D[][] gAll = new Gon3D[3][];
        int[] ngons = new int[]{back.size(), this.ph[1].NF, front.size()};
        gAll[1] = this.faceGons;
        for (int i = 0; i < 3; i += 2) {
            gAll[i] = new Gon3D[ngons[i] + 1];
            Gon3D[] gList = gAll[i];
            Vector<Gon3D> vec = i == 0 ? back : front;
            int nc = ngons[i];
            for (int j = 0; j < nc; ++j) {
                gList[j] = (Gon3D)vec.elementAt(j);
            }
        }
        for (int reg = 0; reg < 3; ++reg) {
            int nc = ngons[reg];
            Gon3D[] gList = gAll[reg];
            for (int ic = 0; ic < nc; ++ic) {
                Gon3D gnd = gList[ic];
                int si = gnd.surfaceID;
                if (!this.faceFront[si]) continue;
                int nv = gnd.nvert;
                int mv = nv + 1;
                double[][] vtx = gnd.vertices;
                this.path.reset();
                for (int k = 0; k < mv; ++k) {
                    int j = k % nv;
                    double xp0 = (double)this.wc + (double)this.rad * vtx[j][0];
                    double yp0 = (double)this.hc + (double)this.rad * vtx[j][1];
                    this.xp[k] = xp0;
                    this.yp[k] = yp0;
                    if (k == 0) {
                        this.path.moveTo((float)xp0, (float)yp0);
                        continue;
                    }
                    if (k >= nv) continue;
                    this.path.lineTo((float)xp0, (float)yp0);
                }
                this.path.closePath();
                int ci = si >= offset ? 1 : 0;
                Color[] cols = this.palette[ci];
                Color faceCol = cols[this.faceBri[si]];
                Color edgeCol = cols[0];
                g2.setPaint(faceCol);
                g2.fill(this.path);
                if (ci == 1) {
                    g2.setPaint(edgeCol);
                    g2.draw(this.path);
                    continue;
                }
                int[] eid = gnd.edgeIDs;
                for (int ep = 0; ep < 2; ++ep) {
                    if (ep == 0) {
                        g2.setPaint(faceCol);
                    } else {
                        g2.setPaint(edgeCol);
                    }
                    for (int j = 0; j < nv; ++j) {
                        boolean fake;
                        boolean bl = fake = (eid[j] & 0x20000000) != 0;
                        if ((fake || ep != 1) && (!fake || ep != 0)) continue;
                        int k = (j + 1) % nv;
                        this.line.setLine(this.xp[j], this.yp[j], this.xp[k], this.yp[k]);
                        g2.draw(this.line);
                    }
                }
            }
        }
    }

    @Override
    public void showStatus(String s) {
        super.showStatus(s);
        this.statusString = s;
    }

    void maybeShowStatus(Graphics g) {
        if (this.statusString.length() != 0) {
            GraphicsUtils.showStatus((String)this.statusString, (Graphics)g, (Component)this);
        }
    }

    @Override
    public synchronized void mouseEntered(MouseEvent e) {
        this.showStatus("Click to redraw");
    }

    @Override
    public synchronized void mouseExited(MouseEvent e) {
        this.showStatus("");
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        this.F = 0L;
        this.mouseEntered(null);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

