/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.graphics.BgTiler;
import egan.graphics.GraphicsUtils;
import egan.physics.AngularMomentum;
import egan.util.Utils;
import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;

public class Spin
extends Applet
implements Runnable,
MouseListener {
    private static final long serialVersionUID = 1L;
    static final BasicStroke str = new BasicStroke(0.5f, 0, 2);
    static final RenderingHints aaON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    GeneralPath path = new GeneralPath(0, 5);
    Line2D.Double line = new Line2D.Double();
    String cplus = "\u2295";
    String ctimes = "\u2297";
    boolean mouseIN = false;
    long F = 0L;
    long pt = 0L;
    long tStep = 100L;
    private volatile Thread a;
    Image I;
    Graphics o;
    BgTiler bgt = null;
    double[] axis;
    double[][] basis = new double[6][3];
    final int nphase = 10;
    final int nbrightness = 25;
    final int ncols = 251;
    double[][][][] c;
    double[][][][] U;
    byte[][] pix;
    MemoryImageSource[] mis;
    Image[] im;
    final int sfactor = 2;
    int twoJ1;
    int twoJ2;
    int twoJlo;
    int twoJhi;
    String s1 = null;
    String s2 = null;
    String s12 = null;
    String sDS = null;
    int sw1;
    int sw2;
    int sw12;
    int swDS;
    int dim1;
    int dim2;
    int dim12;
    int nds;
    int margin;
    int fh;
    int fd;
    int elsq;
    String statusString = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.addMouseListener(this);
        Thread thisThread = Thread.currentThread();
        while (this.a == thisThread) {
            long t = System.currentTimeMillis();
            Spin spin = this;
            synchronized (spin) {
                if (t - this.pt > this.tStep || t < this.pt) {
                    this.repaint();
                }
            }
            try {
                Thread.sleep(20L);
            }
            catch (Exception e) {
                break;
            }
        }
    }

    @Override
    public void start() {
        this.a = new Thread(this);
        this.a.start();
        this.a.setPriority(1);
    }

    @Override
    public void stop() {
        this.a = null;
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public synchronized void update(Graphics g) {
        long t = System.currentTimeMillis();
        if (t - this.pt >= this.tStep || t < this.pt) {
            this.pt = t;
            int w = this.getSize().width;
            int h = this.getSize().height;
            if (this.F == 0L) {
                int i;
                String fontName = GraphicsUtils.getNiceFont((Component)this);
                this.setFont(new Font(fontName, 0, 18));
                byte[] palette = new byte[753];
                int k = 3;
                for (int i2 = 0; i2 < 25; ++i2) {
                    for (int j = 0; j < 10; ++j) {
                        Color col = new Color(Color.HSBtoRGB((float)j / 10.0f, 1.0f, (float)(i2 + 1) / 25.0f));
                        palette[k++] = (byte)col.getRed();
                        palette[k++] = (byte)col.getGreen();
                        palette[k++] = (byte)col.getBlue();
                    }
                }
                IndexColorModel icm = new IndexColorModel(8, 251, palette, 0, false, -1);
                this.I = this.createImage(w, h);
                this.o = this.I.getGraphics();
                this.o.setFont(this.getFont());
                this.axis = Utils.randomUnitVec(null, (boolean)false);
                this.twoJ1 = 1 + (int)(6.0 * Math.random());
                this.twoJ2 = 1 + (int)(6.0 * Math.random());
                this.twoJlo = Math.abs(this.twoJ1 - this.twoJ2);
                this.twoJhi = this.twoJ1 + this.twoJ2;
                this.nds = (this.twoJhi - this.twoJlo) / 2 + 1;
                this.dim1 = this.twoJ1 + 1;
                this.dim2 = this.twoJ2 + 1;
                this.dim12 = this.dim1 * this.dim2;
                FontMetrics fm = this.getFontMetrics(this.getFont());
                this.fh = fm.getHeight();
                this.fd = fm.getDescent();
                this.margin = this.fh;
                this.s1 = "spin " + this.spinString(this.twoJ1);
                this.s2 = "spin " + this.spinString(this.twoJ2);
                this.s12 = this.s1 + " " + this.ctimes + " " + this.s2;
                this.sDS = "spin " + this.spinString(this.twoJlo) + " " + this.cplus + " " + (this.twoJlo == this.twoJhi - 2 ? "" : "... " + this.cplus + " ") + "spin " + this.spinString(this.twoJhi);
                this.sw1 = fm.stringWidth(this.s1);
                this.sw2 = fm.stringWidth(this.s2);
                this.sw12 = fm.stringWidth(this.s12);
                this.swDS = fm.stringWidth(this.sDS);
                this.elsq = Math.min((w - this.margin) / (2 * this.dim12), (h - 2 * this.margin) / (2 * Math.max(this.dim1, this.dim2) + this.dim12));
                this.U = new double[this.nds + 3][][][];
                this.c = new double[this.nds + 3][][][];
                this.mis = new MemoryImageSource[this.nds + 3];
                this.im = new Image[this.nds + 3];
                this.pix = new byte[this.nds + 3][];
                for (i = 0; i < this.nds + 3; ++i) {
                    int dim;
                    int twoJ = this.twoJlo + 2 * (i - 3);
                    if (i == 0) {
                        twoJ = this.twoJ1;
                    } else if (i == 1) {
                        twoJ = this.twoJ2;
                    }
                    int n = dim = i == 2 ? this.dim12 : twoJ + 1;
                    if (i != 2) {
                        this.c[i] = AngularMomentum.spinJcoeffs((int)twoJ);
                    }
                    this.U[i] = new double[dim][dim][2];
                    int iw = dim * this.elsq * (i < 2 ? 2 : 1);
                    this.pix[i] = new byte[iw * iw];
                    this.mis[i] = new MemoryImageSource(iw, iw, (ColorModel)icm, this.pix[i], 0, iw);
                    this.mis[i].setAnimated(true);
                    this.im[i] = this.createImage(this.mis[i]);
                }
                for (i = 0; i < 3; ++i) {
                    this.basis[3 + i][i] = 1.0;
                }
            }
            if (this.bgt == null) {
                this.bgt = new BgTiler((Applet)this, w, h);
            }
            this.d(this.o, w, h, this.bgt.tile(this.o));
            g.drawImage(this.I, 0, 0, null);
            this.maybeShowStatus(g);
            ++this.F;
        }
    }

    public void d(Graphics g, int w, int h, boolean TB) {
        int wc = w / 2;
        if (!TB) {
            g.setColor(Color.white);
            g.fillRect(0, 0, w, h);
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHints(aaON);
        g2.setStroke(str);
        double theta = (double)this.F * Math.PI / 30.0;
        Utils.setRotation((double[][])this.basis, (double)theta, (double[])this.axis, (double)1.0);
        double[][][] U1 = this.U[0];
        double[][][] U2 = this.U[1];
        double[][][] U12 = this.U[2];
        double[][][] c1 = this.c[0];
        double[][][] c2 = this.c[1];
        AngularMomentum.spinJpolar((double[][][])U1, (int)this.twoJ1, (double[][][])c1, (double)theta, (double)this.axis[0], (double)this.axis[1], (double)this.axis[2]);
        AngularMomentum.spinJpolar((double[][][])U2, (int)this.twoJ2, (double[][][])c2, (double)theta, (double)this.axis[0], (double)this.axis[1], (double)this.axis[2]);
        for (int i = 0; i < this.dim12; ++i) {
            for (int j = 0; j < this.dim12; ++j) {
                double[] u1 = U1[i / this.dim2][j / this.dim2];
                double[] u2 = U2[i % this.dim2][j % this.dim2];
                U12[i][j][0] = u1[0] * u2[0];
                U12[i][j][1] = u1[1] + u2[1];
            }
        }
        int m2 = this.margin / 2;
        int elsqS = 2 * this.elsq;
        int w1 = this.dim1 * elsqS;
        int x1 = wc - m2 - w1 - Math.max(0, (this.sw1 - w1) / 2);
        int y1 = h - w1 - this.fh;
        int w2 = this.dim2 * elsqS;
        int x2 = wc + m2 + Math.max(0, (this.sw2 - w2) / 2);
        int y2 = h - w2 - this.fh;
        int w12 = this.dim12 * this.elsq;
        int x12 = wc - m2 - w12 - Math.max(0, (this.sw12 - w12) / 2);
        int y12 = 0;
        int xDS = wc + m2 + Math.max(0, (this.swDS - w12) / 2);
        int yDS = 0;
        this.paintMat(g, U1, x1, y1, elsqS, this.mis[0], this.im[0], this.pix[0]);
        this.paintMat(g, U2, x2, y2, elsqS, this.mis[1], this.im[1], this.pix[1]);
        this.paintMat(g, U12, x12, y12, this.elsq, this.mis[2], this.im[2], this.pix[2]);
        g2.setPaint(Color.black);
        g2.fill(new Rectangle(xDS, yDS, w12, w12));
        g2.drawString(this.s1, x1 + (w1 - this.sw1) / 2, h - this.fd);
        g2.drawString(this.s2, x2 + (w2 - this.sw2) / 2, h - this.fd);
        g2.drawString(this.s12, x12 + (w12 - this.sw12) / 2, y12 + w12 + this.fh - this.fd);
        g2.drawString(this.sDS, xDS + (w12 - this.swDS) / 2, yDS + w12 + this.fh - this.fd);
        int xc = w1 <= w2 ? x1 / 2 : (w + x2 + w2) / 2;
        int yc = (h + w12 + y12) / 2;
        int rad = (h - yc) / 2;
        double scale = 0.577 * (double)rad;
        g2.setPaint(Color.white);
        g2.fill(new Ellipse2D.Double(xc - rad, yc - rad, 2 * rad, 2 * rad));
        double[] uv = new double[3];
        double[] rv = new double[3];
        double[] xe = new double[2];
        double[] ye = new double[2];
        for (int r = 0; r < 2; ++r) {
            g2.setPaint(r == 0 ? Color.gray : Color.black);
            for (int d1 = 0; d1 < 3; ++d1) {
                for (int j = -1; j <= 1; j += 2) {
                    for (int k = -1; k <= 1; k += 2) {
                        uv[(d1 + 1) % 3] = j;
                        uv[(d1 + 2) % 3] = k;
                        for (int l = 0; l < 2; ++l) {
                            uv[d1] = 1 - 2 * l;
                            for (int i = 0; i < 3; ++i) {
                                rv[i] = 0.0;
                                for (int ii = 0; ii < 3; ++ii) {
                                    int n = i;
                                    rv[n] = rv[n] + this.basis[r == 0 ? 3 + i : i][ii] * uv[ii];
                                }
                            }
                            xe[l] = (double)xc + scale * (0.707 * (rv[1] - rv[0]));
                            ye[l] = (double)yc + scale * (0.408 * (rv[0] + rv[1] - 2.0 * rv[2]));
                        }
                        this.line.setLine(xe[0], ye[0], xe[1], ye[1]);
                        g2.draw(this.line);
                    }
                }
            }
        }
        int k = 3;
        int dxy = 0;
        for (int twoJ3 = this.twoJlo; twoJ3 <= this.twoJhi; twoJ3 += 2) {
            AngularMomentum.spinJpolar((double[][][])this.U[k], (int)twoJ3, (double[][][])this.c[k], (double)theta, (double)this.axis[0], (double)this.axis[1], (double)this.axis[2]);
            this.paintMat(g, this.U[k], xDS + dxy, yDS + dxy, this.elsq, this.mis[k], this.im[k], this.pix[k]);
            ++k;
            dxy += (twoJ3 + 1) * this.elsq;
        }
    }

    private void paintMat(Graphics g, double[][][] a, int x, int y, int ps, MemoryImageSource mis, Image im, byte[] pix) {
        int dim = a.length;
        int dps = dim * ps;
        for (int i = 0; i < dim; ++i) {
            double[][] ai = a[i];
            for (int j = 0; j < dim; ++j) {
                double[] aij = ai[j];
                int ib = (int)Math.round(aij[0] * 25.0);
                int ih = (int)((100000.0 + aij[1] / (Math.PI * 2)) % 1.0 * 10.0);
                byte ic = (byte)(ib == 0 ? 0 : 1 + 10 * (ib - 1) + ih);
                for (int k = 0; k < ps; ++k) {
                    for (int l = 0; l < ps; ++l) {
                        pix[(j * ps + l) * dps + i * ps + k] = ic;
                    }
                }
            }
        }
        mis.newPixels();
        g.drawImage(im, x, y, null);
    }

    private String spinString(int twoJ) {
        return twoJ % 2 == 0 ? "" + twoJ / 2 : "" + twoJ + "/2";
    }

    @Override
    public void showStatus(String s) {
        super.showStatus(s);
        this.statusString = s;
    }

    void maybeShowStatus(Graphics g) {
        if (this.statusString.length() != 0) {
            GraphicsUtils.showStatus((String)this.statusString, (Graphics)g, (Component)this);
        }
    }

    @Override
    public synchronized void mouseEntered(MouseEvent e) {
        this.mouseIN = true;
        this.showStatus("Click to redraw");
    }

    @Override
    public synchronized void mouseExited(MouseEvent e) {
        this.mouseIN = false;
        this.showStatus("");
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        this.F = 0L;
        this.mouseEntered(null);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

