/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.applets.ScrollingApplet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.util.Random;

public class Tuebingen
extends ScrollingApplet {
    private static final long serialVersionUID = 1L;
    int DI;
    boolean oddDim;
    float bfac0 = 0.2f;
    double[] bx;
    double[] by;
    double[] p;
    double[][] dx;
    double[][] dy;
    double[][] dp;
    double[] solAx;
    double[] solBx;
    double[] solCx;
    double[] solAy;
    double[] solBy;
    double[] solCy;
    int[][] tripCoords;
    int[][] mapCoords;
    int[][][] dpSpan;
    int ntrip;
    float[] Tshape;
    float[] Torient;
    double marg;
    float cfac;
    static final BasicStroke str = new BasicStroke(0.5f, 0, 2);
    static final RenderingHints aaON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    static final RenderingHints aaOFF = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);

    ScrollingApplet getNewApplet() {
        return new Tuebingen();
    }

    public void setup(long rseed, int dimA) {
        int tt;
        int k;
        int k2;
        Random r = new Random(rseed);
        int minD = 4;
        int maxD = 14;
        int numD = maxD - minD + 1;
        if (dimA > 0) {
            this.mainParameter = dimA;
        } else if (this.mainParameter < 0) {
            while (this.mainParameter == 5 || this.mainParameter < 0) {
                this.mainParameter = minD + (int)((double)numD * r.nextDouble());
            }
        }
        int dA = this.mainParameter;
        this.n1 = minD + (dA - minD + 1) % numD;
        this.n2 = minD + (dA - minD + numD - 1) % numD;
        int dI = this.DI = dA + 1;
        this.oddDim = dI % 2 != 0;
        r = new Random(rseed);
        this.bx = new double[dI];
        this.by = new double[dI];
        this.p = new double[dI];
        double phase = 6.0 * r.nextDouble();
        double sA = Math.PI / (double)dI;
        double hA = sA / 2.0;
        double theta = 2.0 * sA;
        double norm = Math.sqrt(2.0 / (double)dI);
        double sp = 0.0;
        for (k2 = 0; k2 < dI; ++k2) {
            this.bx[k2] = norm * Math.cos(phase + theta * (double)k2);
            this.by[k2] = norm * Math.sin(phase + theta * (double)k2);
            this.p[k2] = r.nextDouble();
            sp += this.p[k2];
        }
        sp /= (double)dI;
        k2 = 0;
        while (k2 < dI) {
            int n = k2++;
            this.p[n] = this.p[n] - sp;
        }
        this.marg = this.oddDim ? 0.5 * norm / Math.sin(hA) : norm / Math.sin(sA);
        this.dpSpan = new int[dA][][];
        this.dx = new double[dA][];
        this.dy = new double[dA][];
        this.dp = new double[dA][];
        for (int i = 0; i < dA; ++i) {
            int l = dA - i;
            this.dpSpan[i] = new int[l][2];
            this.dx[i] = new double[l];
            double[] dxi = this.dx[i];
            this.dy[i] = new double[l];
            double[] dyi = this.dy[i];
            this.dp[i] = new double[l];
            double[] dpi = this.dp[i];
            int j = i + 1;
            k = 0;
            while (j < dI) {
                dxi[k] = this.bx[i] - this.bx[j];
                dyi[k] = this.by[i] - this.by[j];
                dpi[k] = this.p[i] - this.p[j];
                ++j;
                ++k;
            }
        }
        this.ntrip = dI * dA * (dA - 1) / 6;
        this.tripCoords = new int[this.ntrip][dI];
        this.mapCoords = new int[this.ntrip][dI];
        this.solAx = new double[this.ntrip];
        this.solBx = new double[this.ntrip];
        this.solCx = new double[this.ntrip];
        this.solAy = new double[this.ntrip];
        this.solBy = new double[this.ntrip];
        this.solCy = new double[this.ntrip];
        int l = 0;
        for (int i = 0; i < dI - 2; ++i) {
            for (int j = i + 1; j < dA; ++j) {
                for (int k3 = j + 1; k3 < dI; ++k3) {
                    int[] tc = this.tripCoords[l];
                    int[] mc = this.mapCoords[l];
                    tc[0] = i;
                    tc[1] = j;
                    tc[2] = k3;
                    mc[i] = 0;
                    mc[j] = 1;
                    mc[k3] = 2;
                    int m = 3;
                    for (int ii = 0; ii < dI; ++ii) {
                        if (ii == i || ii == j || ii == k3) continue;
                        tc[m] = ii;
                        mc[ii] = m++;
                    }
                    double denom = this.bx[k3] * (this.by[i] - this.by[j]) + this.bx[i] * (this.by[j] - this.by[k3]) + this.bx[j] * (this.by[k3] - this.by[i]);
                    this.solAx[l] = (this.by[i] - this.by[k3]) / denom;
                    this.solBx[l] = (this.by[j] - this.by[i]) / denom;
                    this.solCx[l] = (this.by[k3] * (this.p[i] - this.p[j]) + this.by[i] * (this.p[j] - this.p[k3]) + this.by[j] * (this.p[k3] - this.p[i])) / denom;
                    this.solAy[l] = (this.bx[k3] - this.bx[i]) / denom;
                    this.solBy[l] = (this.bx[i] - this.bx[j]) / denom;
                    this.solCy[l] = (this.bx[k3] * (this.p[j] - this.p[i]) + this.bx[i] * (this.p[k3] - this.p[j]) + this.bx[j] * (this.p[i] - this.p[k3])) / denom;
                    ++l;
                }
            }
        }
        this.Tshape = new float[this.ntrip];
        this.Torient = new float[this.ntrip];
        this.cfac = r.nextFloat();
        float maxDet = 0.0f;
        for (tt = 0; tt < this.ntrip; ++tt) {
            float det;
            int[] tc = this.tripCoords[tt];
            int i = tc[0];
            int j = tc[1];
            k = tc[2];
            int ij = j - i - 1;
            int ik = k - i - 1;
            double xe = this.dx[i][ij];
            double ye = this.dy[i][ij];
            double xf = this.dx[i][ik];
            double yf = this.dy[i][ik];
            this.Tshape[tt] = det = (float)Math.sqrt(Math.abs(xf * ye - yf * xe));
            if (det > maxDet) {
                maxDet = det;
            }
            this.Torient[tt] = (float)Math.abs((Math.atan2(xf, yf) + Math.atan2(xe, ye)) / (Math.PI * 2));
        }
        tt = 0;
        while (tt < this.ntrip) {
            int n = tt++;
            this.Tshape[n] = this.Tshape[n] / maxDet;
        }
        if (this.mouseIN) {
            this.mouseEntered(null);
        }
    }

    public void d(Graphics g, int w, int y1, int y2, long yoffs, boolean init) {
        int wc = w / 2;
        int h2 = (y2 - y1) / 2;
        int hc = y1 + h2;
        GeneralPath tri = new GeneralPath(0, 4);
        Graphics2D g2 = (Graphics2D)g;
        g2.addRenderingHints(aaON);
        g2.setStroke(str);
        g.setColor(Color.black);
        g.fillRect(0, y1, w, y2 - y1);
        if (init) {
            this.thisSeed = new Random().nextLong();
            this.setup(this.thisSeed, -1);
        }
        int dA = this.mainParameter;
        int dI = this.DI;
        int[] uuu = new int[dA];
        int[][] vvv = new int[3][dI];
        double[] rp = new double[dI];
        double span0 = 10.0 / Math.sqrt((double)dI / 5.0);
        double inc = span0 / 300.0;
        double span = inc * (double)w;
        double xm1 = (double)wc * inc + this.marg;
        double xm0 = -xm1;
        double ym1 = (double)(yoffs + (long)h2) * inc + this.marg;
        double ym0 = (double)(yoffs - (long)h2) * inc - this.marg;
        double[] xm = new double[]{xm0, xm1};
        double[] ym = new double[]{ym0, ym1};
        double[] xep = new double[2];
        double[] yep = new double[2];
        for (int i = 0; i < dA; ++i) {
            double[] dxi = this.dx[i];
            double[] dyi = this.dy[i];
            double[] dpi = this.dp[i];
            int j = i + 1;
            int k = 0;
            while (j < dI) {
                int lc = Integer.MAX_VALUE;
                int uc = Integer.MIN_VALUE;
                for (int jj = 0; jj < 2; ++jj) {
                    for (int ii = 0; ii < 2; ++ii) {
                        int dot = (int)Math.ceil(dxi[k] * xm[ii] + dyi[k] * ym[jj] + dpi[k]);
                        if (dot < lc) {
                            lc = dot;
                        }
                        if (--dot <= uc) continue;
                        uc = dot;
                    }
                }
                this.dpSpan[i][k][0] = lc;
                this.dpSpan[i][k][1] = uc;
                ++j;
                ++k;
            }
        }
        for (int tt = 0; tt < this.ntrip; ++tt) {
            int[] tc = this.tripCoords[tt];
            int[] mc = this.mapCoords[tt];
            double sax = this.solAx[tt];
            double sbx = this.solBx[tt];
            double scx = this.solCx[tt];
            double say = this.solAy[tt];
            double sby = this.solBy[tt];
            double scy = this.solCy[tt];
            int i = tc[0];
            int j = tc[1];
            int k = tc[2];
            int ij = j - i - 1;
            int ik = k - i - 1;
            double[] dxi = this.dx[i];
            double[] dyi = this.dy[i];
            double[] dpi = this.dp[i];
            double xij = dxi[ij];
            double xik = dxi[ik];
            double yij = dyi[ij];
            double yik = dyi[ik];
            double pij = dpi[ij];
            double pik = dpi[ik];
            float tshape = this.Tshape[tt];
            float torient = this.Torient[tt];
            for (int ijD = this.dpSpan[i][ij][0]; ijD <= this.dpSpan[i][ij][1]; ++ijD) {
                double y;
                double x;
                double ae = (double)ijD - pij;
                int nn = 0;
                for (int ii = 0; ii < 2 && nn < 2; ++ii) {
                    x = xm[ii];
                    y = (ae - xij * x) / yij;
                    if (y >= ym0 && y <= ym1) {
                        xep[nn] = x;
                        yep[nn++] = y;
                        if (nn == 2) break;
                    }
                    if (!((x = (ae - yij * (y = ym[ii])) / xij) >= xm0) || !(x <= xm1)) continue;
                    xep[nn] = x;
                    yep[nn++] = y;
                }
                int lc0 = (int)Math.ceil(xik * xep[0] + yik * yep[0] + pik);
                int uc0 = (int)Math.floor(xik * xep[1] + yik * yep[1] + pik);
                if (uc0 < lc0) {
                    int tmp = lc0;
                    lc0 = uc0 + 1;
                    uc0 = tmp - 1;
                }
                double xp = sax * (double)ijD + scx;
                double yp = say * (double)ijD + scy;
                for (int ikD = lc0; ikD <= uc0; ++ikD) {
                    int q;
                    int m;
                    boolean neg;
                    x = xp + sbx * (double)ikD;
                    y = yp + sby * (double)ikD;
                    for (int m2 = 0; m2 < dI; ++m2) {
                        rp[m2] = this.p[m2] + x * this.bx[m2] + y * this.by[m2];
                    }
                    int sum = ijD + ikD;
                    uuu[0] = ijD;
                    uuu[1] = ikD;
                    double x0 = rp[i];
                    for (int m3 = 2; m3 < dA; ++m3) {
                        uuu[m3] = (int)Math.floor(x0 - rp[tc[m3 + 1]]);
                        sum += uuu[m3];
                    }
                    int msum = sum > 0 ? sum % dI : dI - -sum % dI;
                    boolean bl = neg = msum == 1;
                    if (!neg && msum != 2) continue;
                    if (neg) {
                        for (m = 0; m < dA; ++m) {
                            uuu[m] = -uuu[m] - 1;
                        }
                        q = -(sum - 1) / dI - 1;
                    } else {
                        uuu[0] = uuu[0] - 1;
                        uuu[1] = uuu[1] - 1;
                        q = (sum - 2) / dI;
                    }
                    for (m = 0; m < dI; ++m) {
                        int mcm = mc[m] - 1;
                        int n = mcm >= 0 ? q - uuu[mcm] : q;
                        vvv[1][m] = n;
                        vvv[0][m] = n;
                    }
                    int[] nArray = vvv[1];
                    int n = i;
                    nArray[n] = nArray[n] + 1;
                    for (m = 0; m < dI; ++m) {
                        vvv[2][m] = vvv[1][m];
                    }
                    int[] nArray2 = vvv[1];
                    int n2 = j;
                    nArray2[n2] = nArray2[n2] - 1;
                    int[] nArray3 = vvv[2];
                    int n3 = k;
                    nArray3[n3] = nArray3[n3] - 1;
                    int sign = neg ? -1 : 1;
                    tri.reset();
                    float yy = 0.0f;
                    for (int m4 = 0; m4 < 3; ++m4) {
                        x = 0.0;
                        y = 0.0;
                        for (int mm = 0; mm < dI; ++mm) {
                            double delta = (double)(sign * vvv[m4][mm]) - this.p[mm];
                            x += this.bx[mm] * delta;
                            y += this.by[mm] * delta;
                        }
                        float xc = (float)((double)wc + x / inc);
                        float yc = (float)((double)hc + y / inc - (double)yoffs);
                        if (m4 == 0) {
                            tri.moveTo(xc, yc);
                            yy = (float)y;
                            continue;
                        }
                        tri.lineTo(xc, yc);
                    }
                    tri.closePath();
                    float sfac1 = (float)(1.0 - Math.sin((double)yy / 171.0)) / 2.0f;
                    float bfac = this.bfac0 + (1.0f - this.bfac0) * sfac1;
                    g2.setPaint(new Color(Color.HSBtoRGB((this.cfac + tshape + yy / 111.0f) % 1.0f, 0.7f * sfac1 + 0.3f, bfac * torient + (1.0f - bfac))));
                    g2.fill(tri);
                    g2.setPaint(Color.black);
                    g2.draw(tri);
                }
            }
        }
    }
}

