/*
 * Decompiled with CFR 0.152.
 */
package egan.maths;

import egan.maths.LinearAlgebra;

public class LinearSystem {
    public int nVar;
    public int nEq;
    public double[][] a;
    public boolean inconsistent;
    public int nIndep;
    public int[] indep;
    public boolean[] indepFlags;
    public double[][] solution;
    public boolean[] mustBeDependent;
    public boolean[] mustBeIndependent;

    public LinearSystem(double[][] dArray, int n, int n2) {
        int n3;
        this.nVar = n;
        this.nEq = n2;
        if (this.nEq == 0) {
            return;
        }
        this.a = new double[this.nEq][this.nVar + 1];
        for (int i = 0; i < this.nEq; ++i) {
            double[] dArray2 = dArray[i];
            double[] dArray3 = this.a[i];
            for (int j = 0; j <= this.nVar; ++j) {
                dArray3[j] = dArray2[j];
            }
        }
        int[] nArray = new int[this.nVar + 1];
        this.nEq = LinearAlgebra.reduceMat(this.a, nArray);
        this.inconsistent = nArray[this.nVar] != -1;
        if (this.inconsistent) {
            return;
        }
        this.nIndep = 0;
        this.indep = new int[this.nVar];
        this.indepFlags = new boolean[this.nVar];
        this.mustBeDependent = new boolean[this.nVar];
        this.mustBeIndependent = new boolean[this.nVar];
        for (int i = 0; i < this.nVar; ++i) {
            int n4;
            int n5 = nArray[i];
            this.indepFlags[i] = n5 == -1;
            if (this.indepFlags[i]) {
                this.indep[this.nIndep++] = i;
                boolean bl = false;
                for (n4 = 0; n4 < this.nEq; ++n4) {
                    if (this.a[n4][i] == 0.0) continue;
                    bl = true;
                    break;
                }
                this.mustBeIndependent[i] = !bl;
                continue;
            }
            double[] dArray4 = this.a[n5];
            n4 = 0;
            for (n3 = i + 1; n3 < this.nVar; ++n3) {
                if (dArray4[n3] == 0.0) continue;
                n4 = 1;
                break;
            }
            this.mustBeDependent[i] = n4 == 0;
        }
        this.solution = new double[this.nIndep + 1][this.nVar];
        double[] dArray5 = this.solution[0];
        int n6 = 1;
        for (int i = 0; i < this.nVar; ++i) {
            if (this.indepFlags[i]) {
                this.solution[n6++][i] = 1.0;
                continue;
            }
            double[] dArray6 = this.a[nArray[i]];
            dArray5[i] = dArray6[this.nVar];
            for (n3 = 0; n3 < this.nIndep; ++n3) {
                this.solution[1 + n3][i] = -dArray6[this.indep[n3]];
            }
        }
    }

    public boolean setIndependent(boolean[] blArray) {
        return this.setOrCheckIndependent(blArray, true);
    }

    public boolean setOrCheckIndependent(boolean[] blArray, boolean bl) {
        double[] dArray;
        int n;
        int n2;
        int n3;
        if (this.inconsistent) {
            return false;
        }
        int n4 = 0;
        int n5 = 0;
        int[] nArray = new int[this.nVar];
        for (n3 = 0; n3 < this.nVar; ++n3) {
            if (!blArray[n3]) continue;
            if (this.mustBeDependent[n3]) {
                return false;
            }
            nArray[n5++] = n3;
            if (this.indepFlags[n3]) continue;
            ++n4;
        }
        if (n4 == 0) {
            return true;
        }
        if (n5 > this.nIndep) {
            return false;
        }
        n3 = n5;
        for (int i = 0; i < this.nVar; ++i) {
            if (blArray[i]) continue;
            nArray[n3++] = i;
        }
        double[][] dArray2 = new double[this.nIndep][this.nVar + this.nIndep];
        for (int i = 0; i < this.nIndep; ++i) {
            double[] dArray3 = dArray2[i];
            double[] dArray4 = this.solution[1 + i];
            for (n2 = 0; n2 < this.nVar; ++n2) {
                dArray3[n2] = dArray4[nArray[n2]];
            }
            dArray3[this.nVar + i] = 1.0;
        }
        int[] nArray2 = new int[this.nVar + this.nIndep];
        if (LinearAlgebra.reduceMat(dArray2, nArray2) != this.nIndep) {
            return false;
        }
        for (int i = 0; i < n5; ++i) {
            if (nArray2[i] == i) continue;
            return false;
        }
        if (!bl) {
            return true;
        }
        this.indepFlags = new boolean[this.nVar];
        int[] nArray3 = new int[this.nVar];
        for (n = 0; n < this.nVar; ++n) {
            if (nArray2[n] < 0) continue;
            n2 = nArray[n];
            this.indepFlags[n2] = true;
            nArray3[n2] = nArray2[n];
        }
        n = 0;
        int[] nArray4 = new int[this.nIndep];
        for (int i = 0; i < this.nVar; ++i) {
            if (!this.indepFlags[i]) continue;
            nArray4[n] = nArray3[i];
            this.indep[n++] = i;
        }
        double[][] dArray5 = new double[this.nIndep + 1][this.nVar];
        for (int i = 0; i < this.nIndep; ++i) {
            dArray = dArray5[1 + i];
            double[] dArray6 = dArray2[nArray4[i]];
            for (int j = 0; j < this.nVar; ++j) {
                double d = 0.0;
                for (int k = 0; k < this.nIndep; ++k) {
                    d += dArray6[this.nVar + k] * this.solution[1 + k][j];
                }
                dArray[j] = d;
            }
        }
        double[] dArray7 = dArray5[0];
        dArray = this.solution[0];
        for (int i = 0; i < this.nVar; ++i) {
            double d = dArray[i];
            for (int j = 0; j < this.nIndep; ++j) {
                d -= dArray[this.indep[j]] * dArray5[1 + j][i];
            }
            dArray7[i] = d;
        }
        this.solution = dArray5;
        return true;
    }

    public static LinearSystem mergeSystems(LinearSystem[] linearSystemArray, int n, boolean bl, int[] nArray) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            LinearSystem linearSystem = linearSystemArray[i];
            n3 += linearSystem.nEq;
            if (bl) {
                n2 = Math.max(n2, linearSystem.nVar);
                continue;
            }
            n2 += linearSystem.nVar;
        }
        if (n3 > 0) {
            double[][] dArray = new double[n3][n2 + 1];
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < n; ++i) {
                LinearSystem linearSystem = linearSystemArray[i];
                int n6 = linearSystem.nEq;
                int n7 = linearSystem.nVar;
                double[][] dArray2 = linearSystem.a;
                for (int j = 0; j < n6; ++j) {
                    double[] dArray3 = dArray[n5 + j];
                    double[] dArray4 = dArray2[j];
                    for (int k = 0; k < n7; ++k) {
                        dArray3[nArray == null ? n4 + k : nArray[n4 + k]] = dArray4[k];
                    }
                    dArray3[n2] = dArray4[n7];
                }
                if (!bl) {
                    n4 += n7;
                }
                n5 += n6;
            }
            return new LinearSystem(dArray, n2, n3);
        }
        return null;
    }

    public LinearSystem removeVariables(boolean[] blArray) {
        double[] dArray;
        Object object;
        int n;
        int n2;
        int n3;
        boolean[] blArray2 = new boolean[this.nEq];
        double[][] dArray2 = new double[this.nEq][this.nVar + 1];
        for (n3 = 0; n3 < this.nEq; ++n3) {
            double[] dArray3 = this.a[n3];
            double[] dArray4 = dArray2[n3];
            for (n2 = 0; n2 <= this.nVar; ++n2) {
                dArray4[n2] = dArray3[n2];
            }
        }
        n3 = 0;
        int n4 = 0;
        for (n = 0; n < this.nVar; ++n) {
            if (!blArray[n]) continue;
            ++n4;
            for (n2 = 0; n2 < this.nEq && (blArray2[n2] || dArray2[n2][n] == 0.0); ++n2) {
            }
            if (n2 == this.nEq) continue;
            blArray2[n2] = true;
            ++n3;
            object = dArray2[n2];
            double[] dArray5 = object[n];
            for (int i = n2 + 1; i < this.nEq; ++i) {
                if (blArray2[i] || dArray2[i][n] == 0.0) continue;
                dArray = dArray2[i];
                double d = dArray[n] / dArray5;
                for (int j = 0; j <= this.nVar; ++j) {
                    int n5 = j;
                    dArray[n5] = dArray[n5] - d * object[j];
                }
            }
        }
        n = this.nEq - n3;
        n2 = this.nVar - n4;
        if (n == 0 || n2 == 0) {
            return null;
        }
        object = new double[n][n2 + 1];
        int n6 = 0;
        for (int i = 0; i < this.nEq; ++i) {
            if (blArray2[i]) continue;
            double[] dArray6 = dArray2[i];
            dArray = object[n6++];
            int n7 = 0;
            for (int j = 0; j <= this.nVar; ++j) {
                if (j != this.nVar && blArray[j]) continue;
                dArray[n7++] = dArray6[j];
            }
        }
        return new LinearSystem((double[][])object, n2, n);
    }
}

