/*
 * Decompiled with CFR 0.152.
 */
package egan.maths;

import egan.geometry.GraphEdge;
import egan.geometry.GraphNode;
import egan.geometry.GraphNodeLink;
import egan.maths.LinearSystem;

public class Tensor {
    public static int maxSize = 0;
    public static int multiplications = 0;
    public static final int EXPLICIT = 0;
    public static final int PRODUCT = 1;
    public int type;
    public boolean complex;
    public int rank;
    public int[] dimensions;
    public int[] indexMap;
    public LinearSystem constraints;
    public Object components;
    public int arrayRank;
    public int nTensorList;
    public Tensor[] tensorList;
    int[] mappedIndices;
    static final double tolerance = 1.0E-8;
    static final double[] complexZero = new double[]{0.0, 0.0};

    public Tensor(double d) {
        this.type = 0;
        this.components = new Double(d);
    }

    public Tensor(Object object, int n, int[] nArray, boolean bl) {
        this(object, n, nArray, bl, n, null, null);
    }

    public Tensor(Object object, int n, int[] nArray, boolean bl, int n2, int[] nArray2, LinearSystem linearSystem) {
        this.type = 0;
        this.components = object;
        this.rank = n;
        this.dimensions = nArray;
        this.complex = bl;
        this.arrayRank = n2;
        this.indexMap = nArray2;
        this.constraints = linearSystem;
        if (nArray2 == null && n2 > 0) {
            this.indexMap = new int[n2];
            for (int i = 0; i < n2; ++i) {
                this.indexMap[i] = i;
            }
        }
    }

    public Tensor(Tensor[] tensorArray, int n) {
        this(tensorArray, n, null);
    }

    public Tensor(Tensor[] tensorArray, int n, int[] nArray) {
        int n2;
        this.type = 1;
        this.tensorList = tensorArray;
        this.nTensorList = n;
        this.indexMap = nArray;
        this.rank = 0;
        LinearSystem[] linearSystemArray = new LinearSystem[n];
        int n3 = 0;
        this.complex = false;
        for (n2 = 0; n2 < n; ++n2) {
            Tensor tensor = tensorArray[n2];
            this.rank += tensor.rank;
            if (tensor.complex) {
                this.complex = true;
            }
            if (tensor.constraints == null) continue;
            linearSystemArray[n2] = tensor.constraints;
            ++n3;
        }
        if (this.rank > 0) {
            this.dimensions = new int[this.rank];
            n2 = 0;
            for (int i = 0; i < n; ++i) {
                Tensor tensor = tensorArray[i];
                int n4 = tensor.rank;
                int[] nArray2 = tensor.dimensions;
                for (int j = 0; j < n4; ++j) {
                    this.dimensions[nArray == null ? n2 + j : nArray[n2 + j]] = nArray2[j];
                }
                n2 += n4;
            }
            this.mappedIndices = new int[this.rank];
        }
        if (n3 > 0) {
            if (n3 < n) {
                for (n2 = 0; n2 < n; ++n2) {
                    if (linearSystemArray[n2] != null) continue;
                    linearSystemArray[n2] = new LinearSystem(null, tensorArray[n2].rank, 0);
                }
            }
            this.constraints = LinearSystem.mergeSystems(linearSystemArray, n, false, nArray);
        }
    }

    public static Tensor basisTensor(int n, int[] nArray, int[] nArray2) {
        if (n == 0) {
            return new Tensor(1.0);
        }
        double[][] dArray = new double[n][n + 1];
        for (int i = 0; i < n; ++i) {
            dArray[i][i] = 1.0;
            dArray[i][n] = nArray2[i];
        }
        return new Tensor(new Double(1.0), n, nArray, false, 0, null, new LinearSystem(dArray, n, n));
    }

    public boolean fitsConstraints(int[] nArray) {
        return this.fitsConstraints(nArray, 0);
    }

    public boolean fitsConstraints(int[] nArray, int n) {
        if (this.constraints != null) {
            int n2 = this.constraints.nEq;
            double[][] dArray = this.constraints.a;
            for (int i = 0; i < n2; ++i) {
                double d = 0.0;
                double[] dArray2 = dArray[i];
                for (int j = 0; j < this.rank; ++j) {
                    d += (double)nArray[n + j] * dArray2[j];
                }
                if (!(Math.abs(d - dArray2[this.rank]) > 1.0E-8)) continue;
                return false;
            }
        }
        return true;
    }

    public int constrainedRank() {
        return this.rank - (this.constraints == null ? 0 : this.constraints.nEq);
    }

    public double realPart(int[] nArray) {
        return this.realPart(nArray, 0, true);
    }

    private double realPart(int[] nArray, int n, boolean bl) {
        if (this.complex) {
            return this.complexPair(nArray, n, bl)[0];
        }
        if (bl && !this.fitsConstraints(nArray, n)) {
            return 0.0;
        }
        if (this.type == 0) {
            if (this.arrayRank == 0) {
                return (Double)this.components;
            }
            Object object = this.components;
            for (int i = 0; i < this.arrayRank - 1; ++i) {
                object = ((Object[])object)[nArray[n + this.indexMap[i]]];
            }
            return ((double[])object)[nArray[n + this.indexMap[this.arrayRank - 1]]];
        }
        if (this.type == 1) {
            double d = 0.0;
            int n2 = 0;
            for (int i = 0; i < this.nTensorList; ++i) {
                double d2;
                Tensor tensor = this.tensorList[i];
                int n3 = tensor.rank;
                if (this.indexMap == null || n3 == 0) {
                    d2 = tensor.realPart(nArray, n + n2, bl);
                } else {
                    for (int j = 0; j < n3; ++j) {
                        this.mappedIndices[j] = nArray[n + this.indexMap[n2 + j]];
                    }
                    d2 = tensor.realPart(this.mappedIndices, 0, bl);
                }
                if (i == 0) {
                    d = d2;
                    if (d == 0.0) {
                        break;
                    }
                } else {
                    ++multiplications;
                    if ((d *= d2) == 0.0) break;
                }
                n2 += n3;
            }
            return d;
        }
        return 0.0;
    }

    public double imaginaryPart(int[] nArray) {
        return this.imaginaryPart(nArray, 0, true);
    }

    private double imaginaryPart(int[] nArray, int n, boolean bl) {
        if (this.complex) {
            return this.complexPair(nArray, n, bl)[1];
        }
        return 0.0;
    }

    public double[] complexPair(int[] nArray) {
        return this.complexPair(nArray, 0, true);
    }

    private double[] complexPair(int[] nArray, int n, boolean bl) {
        if (!this.complex) {
            double[] dArray = new double[]{this.realPart(nArray, n, bl), 0.0};
            return dArray;
        }
        if (bl && !this.fitsConstraints(nArray, n)) {
            return complexZero;
        }
        if (this.type == 0) {
            Object object = this.components;
            for (int i = 0; i < this.arrayRank; ++i) {
                object = ((Object[])object)[nArray[n + this.indexMap[i]]];
            }
            return (double[])object;
        }
        if (this.type == 1) {
            double d = 0.0;
            double d2 = 0.0;
            int n2 = 0;
            for (int i = 0; i < this.nTensorList; ++i) {
                double[] dArray;
                Tensor tensor = this.tensorList[i];
                int n3 = tensor.rank;
                if (this.indexMap == null || n3 == 0) {
                    dArray = tensor.complexPair(nArray, n + n2, bl);
                } else {
                    for (int j = 0; j < n3; ++j) {
                        this.mappedIndices[j] = nArray[n + this.indexMap[n2 + j]];
                    }
                    dArray = tensor.complexPair(this.mappedIndices, 0, bl);
                }
                double d3 = dArray[0];
                double d4 = dArray[1];
                if (i == 0) {
                    d = d3;
                    boolean bl2 = d == 0.0;
                    d2 = d4;
                    if (bl2 & d2 == 0.0) {
                        break;
                    }
                } else {
                    ++multiplications;
                    double d5 = d * d3 - d2 * d4;
                    if ((d2 = d * d4 + d2 * d3) == 0.0 & (d = d5) == 0.0) break;
                }
                n2 += n3;
            }
            double[] dArray = new double[]{d, d2};
            return dArray;
        }
        return null;
    }

    public void braid(int[] nArray) {
        int n;
        if (this.rank == 0) {
            return;
        }
        boolean[] blArray = new boolean[this.rank];
        boolean bl = false;
        for (int i = 0; i < this.rank; ++i) {
            n = nArray[i];
            if (n < 0 || n >= this.rank || blArray[n]) {
                throw new IllegalArgumentException("Invalid permutation of indices");
            }
            blArray[n] = true;
            if (n == i) continue;
            bl = true;
        }
        if (!bl) {
            return;
        }
        int[] nArray2 = new int[this.rank];
        for (n = 0; n < this.rank; ++n) {
            nArray2[nArray[n]] = this.dimensions[n];
        }
        this.dimensions = nArray2;
        if (this.indexMap == null) {
            this.indexMap = new int[this.rank];
            System.arraycopy(nArray, 0, this.indexMap, 0, this.rank);
        } else {
            n = this.indexMap.length;
            int[] nArray3 = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray3[i] = nArray[this.indexMap[i]];
            }
            this.indexMap = nArray3;
        }
        if (this.constraints != null) {
            LinearSystem[] linearSystemArray = new LinearSystem[]{this.constraints};
            this.constraints = LinearSystem.mergeSystems(linearSystemArray, 1, false, nArray);
        }
    }

    public Tensor contract(int[][] nArray, int n) {
        Object object;
        int[] nArray2;
        int[] nArray3;
        int n2;
        LinearSystem linearSystem;
        int n3;
        block40: {
            int n4;
            int n5;
            boolean bl;
            Object[] objectArray;
            int n6;
            int n7;
            int[] nArray4;
            if (n == 0) {
                return this;
            }
            boolean[] blArray = new boolean[this.rank];
            double[][] dArray = new double[n][this.rank + 1];
            for (n3 = 0; n3 < n; ++n3) {
                nArray4 = nArray[n3];
                n7 = nArray4[0];
                n6 = nArray4[1];
                if (n7 < 0 || n7 >= this.rank || n6 < 0 || n6 >= this.rank) {
                    throw new IllegalArgumentException("Index out of range");
                }
                if (blArray[n7] || blArray[n6]) {
                    throw new IllegalArgumentException("Index duplicated");
                }
                if (this.dimensions[n7] != this.dimensions[n6]) {
                    throw new IllegalArgumentException("Paired indices have mismatched dimensions");
                }
                blArray[n7] = true;
                blArray[n6] = true;
                objectArray = dArray[n3];
                objectArray[n7] = (LinearSystem)1.0;
                objectArray[n6] = (LinearSystem)-1.0;
            }
            n3 = this.rank - 2 * n;
            nArray4 = new int[this.rank];
            n7 = 0;
            for (n6 = 0; n6 < this.rank; ++n6) {
                if (blArray[n6]) continue;
                nArray4[n7++] = n6;
            }
            LinearSystem linearSystem2 = new LinearSystem(dArray, this.rank, n);
            if (this.constraints != null) {
                objectArray = new LinearSystem[]{this.constraints, linearSystem2};
                linearSystem2 = LinearSystem.mergeSystems(objectArray, 2, true, null);
            }
            boolean bl2 = linearSystem2.inconsistent;
            linearSystem = null;
            if (!bl2) {
                linearSystem = linearSystem2.removeVariables(blArray);
            } else if (this.constraints != null) {
                linearSystem = this.constraints.removeVariables(blArray);
            }
            boolean bl3 = bl = linearSystem != null;
            if (n3 > 0 && !bl2) {
                boolean[] blArray2 = new boolean[this.rank];
                for (n5 = 0; n5 < n3; ++n5) {
                    blArray2[nArray4[n5]] = bl ? linearSystem.indepFlags[n5] : true;
                }
                if (!linearSystem2.setIndependent(blArray2)) {
                    throw new IllegalArgumentException("Can't handle tensor constraints");
                }
            }
            n2 = bl ? linearSystem.nIndep : n3;
            n5 = n2 + (this.complex ? 1 : 0);
            nArray3 = n3 > 0 ? new int[n3] : null;
            int[] nArray5 = n5 > 0 ? new int[n5] : null;
            int[] nArray6 = new int[n];
            nArray2 = null;
            int[] nArray7 = null;
            int[] nArray8 = null;
            if (n2 > 0) {
                nArray2 = new int[n2];
                nArray7 = new int[n2];
                nArray8 = new int[n2];
            }
            int[] nArray9 = new int[n];
            int[] nArray10 = new int[n];
            int[] nArray11 = new int[this.rank];
            int n8 = 1;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            for (int i = 0; i < this.rank; ++i) {
                boolean bl4;
                int n13 = this.dimensions[i];
                boolean bl5 = bl4 = !bl2 && linearSystem2.indepFlags[i];
                if (blArray[i]) {
                    if (bl4) {
                        nArray6[n11] = n13;
                        nArray9[n11] = i;
                        nArray10[n11++] = n8;
                    }
                } else {
                    nArray3[n9] = n13;
                    if (!bl || linearSystem.indepFlags[n9]) {
                        nArray5[n10] = n13;
                        nArray7[n10] = i;
                        nArray2[n10] = n9;
                        nArray8[n10++] = n8;
                    }
                    ++n9;
                }
                if (bl4) {
                    ++n8;
                    continue;
                }
                nArray11[n12++] = i;
            }
            if (this.complex) {
                nArray5[n10] = 2;
            }
            object = Tensor.createArray(nArray5, n5, 0);
            if (bl2) break block40;
            double[][] dArray2 = linearSystem2.solution;
            double[] dArray3 = dArray2[0];
            double[] dArray4 = new double[this.rank];
            double[] dArray5 = new double[this.rank];
            int[] nArray12 = n2 > 0 ? new int[n2] : null;
            int[] nArray13 = new int[this.rank];
            int n14 = 0;
            block4: do {
                int n15;
                int n16;
                for (n16 = 0; n16 < n12; ++n16) {
                    n14 = nArray11[n16];
                    dArray4[n14] = dArray3[n14];
                }
                for (n16 = 0; n16 < n2; ++n16) {
                    int n17;
                    nArray13[nArray7[n16]] = n17 = nArray12[n16];
                    double[] dArray6 = dArray2[nArray8[n16]];
                    for (int i = 0; i < n12; ++i) {
                        int n18 = n14 = nArray11[i];
                        dArray4[n18] = dArray4[n18] + dArray6[n14] * (double)n17;
                    }
                }
                double d = 0.0;
                double d2 = 0.0;
                int[] nArray14 = n11 > 0 ? new int[n11] : null;
                block8: do {
                    for (n4 = 0; n4 < n12; ++n4) {
                        n14 = nArray11[n4];
                        dArray5[n14] = dArray4[n14];
                    }
                    for (n4 = 0; n4 < n11; ++n4) {
                        nArray13[nArray9[n4]] = n15 = nArray14[n4];
                        double[] dArray7 = dArray2[nArray10[n4]];
                        for (int i = 0; i < n12; ++i) {
                            int n19 = n14 = nArray11[i];
                            dArray5[n19] = dArray5[n19] + dArray7[n14] * (double)n15;
                        }
                    }
                    n4 = 0;
                    for (n15 = 0; n15 < n12; ++n15) {
                        n14 = nArray11[n15];
                        int n20 = (int)Math.round(dArray5[n14]);
                        if (n20 < 0 || n20 >= this.dimensions[n14]) {
                            n4 = 1;
                            break;
                        }
                        nArray13[n14] = n20;
                    }
                    if (n4 == 0) {
                        if (this.complex) {
                            double[] dArray8 = this.complexPair(nArray13, 0, false);
                            d += dArray8[0];
                            d2 += dArray8[1];
                        } else {
                            d += this.realPart(nArray13, 0, false);
                        }
                    }
                    n15 = 0;
                    while (n15 < n11) {
                        int n21 = n15;
                        nArray14[n21] = nArray14[n21] + 1;
                        if (nArray14[n21] != nArray6[n15]) continue block8;
                        nArray14[n15++] = 0;
                    }
                } while (n15 != n11);
                if (n5 == 0) {
                    object = new Double(d);
                } else if (this.complex) {
                    Tensor.setComplexValue(object, n2, nArray12, d, d2);
                } else {
                    Tensor.setValue(object, n2, nArray12, d);
                }
                n4 = 0;
                while (n4 < n2) {
                    int n22 = n4;
                    nArray12[n22] = nArray12[n22] + 1;
                    if (nArray12[n22] != nArray5[n4]) continue block4;
                    nArray12[n4++] = 0;
                }
            } while (n4 != n2);
        }
        return new Tensor(object, n3, nArray3, this.complex, n2, nArray2, linearSystem);
    }

    public Tensor matrixProduct(Tensor tensor) {
        int[][] nArrayArray = new int[][]{{this.rank - 1, this.rank}};
        Tensor[] tensorArray = new Tensor[]{this, tensor};
        return new Tensor(tensorArray, 2).contract(nArrayArray, 1);
    }

    public static Tensor stagedContraction(Tensor[] tensorArray, int n, int[][][] nArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        GraphNode graphNode;
        int n9;
        int n10;
        Object object;
        Object[] objectArray;
        int n11;
        GraphEdge[] graphEdgeArray;
        int[][] nArray2 = new int[n2][2];
        GraphNode[] graphNodeArray = new GraphNode[n];
        int n12 = 0;
        int n13 = 0;
        while (n13 < n) {
            graphEdgeArray = tensorArray[n13];
            n11 = graphEdgeArray.rank;
            graphNodeArray[n13] = new GraphNode(null, (Object)graphEdgeArray, false, n11);
            new GraphNode(null, (Object)graphEdgeArray, false, n11).ID = n13++;
            n12 += n11;
        }
        int n14 = n12 - 2 * n2;
        GraphNode graphNode2 = n14 > 0 ? new GraphNode(null, null, false, n14) : null;
        int[][] nArray3 = new int[n][n];
        graphEdgeArray = new GraphEdge[n2];
        for (n11 = 0; n11 < n2; ++n11) {
            int[][] nArray4 = nArray[n11];
            objectArray = nArray4[0];
            object = nArray4[1];
            n10 = objectArray[0];
            n9 = object[0];
            graphEdgeArray[n11] = new GraphEdge(graphNodeArray[n10], objectArray[1], graphNodeArray[n9], object[1], null);
            int[] nArray5 = nArray3[n10];
            int n15 = n9;
            nArray5[n15] = nArray5[n15] + 1;
            int[] nArray6 = nArray3[n9];
            int n16 = n10;
            nArray6[n16] = nArray6[n16] + 1;
        }
        if (n14 > 0) {
            n11 = 0;
            for (int i = 0; i < n; ++i) {
                graphNode = graphNodeArray[i];
                int n17 = graphNode.valence;
                object = graphNode.firstLink;
                for (n10 = 0; n10 < n17; ++n10) {
                    if (object.edgeLink == null) {
                        ++n11;
                        new GraphEdge(graphNode, n10, graphNode2, n11, null);
                    }
                    object = object.next;
                }
            }
            graphNode2.numberRing();
        }
        for (n11 = 0; n11 < n; ++n11) {
            if (nArray3[n11][n11] == 0) continue;
            graphNode = graphNodeArray[n11];
            graphNode.numberRing();
            int n18 = graphNode.valence;
            objectArray = new boolean[n18];
            object = graphNode.firstLink;
            n8 = 0;
            for (n10 = 0; n10 < n18; ++n10) {
                if (objectArray[n10] == 0 && object.edgeLink.node == graphNode) {
                    n9 = object.edgeLink.ringNumber;
                    nArray2[n8][0] = n10;
                    nArray2[n8++][1] = n9;
                    objectArray[n9] = 1;
                }
                object = object.next;
            }
            graphNode.extra = ((Tensor)graphNode.extra).contract(nArray2, n8);
            graphNode.destroyLinksWith(graphNode);
        }
        n11 = n;
        while (true) {
            GraphNode graphNode3;
            GraphNode graphNode4;
            n7 = Integer.MAX_VALUE;
            n6 = -1;
            n5 = -1;
            for (int i = 0; i < n; ++i) {
                n4 = (n3 + i) % n;
                graphNode4 = graphNodeArray[n4];
                if (graphNode4 == null) continue;
                int[] nArray7 = nArray3[n4];
                int n19 = ((Tensor)graphNode4.extra).constrainedRank();
                for (int j = 0; j < n; ++j) {
                    if (j == n4 || (graphNode3 = graphNodeArray[j]) == null || (n10 = nArray7[j]) <= 0 || (n9 = n19 + ((Tensor)graphNode3.extra).constrainedRank() - n10) >= n7) continue;
                    n7 = n9;
                    n6 = n4;
                    n5 = j;
                }
                if (n6 >= 0) break;
            }
            if (n6 == -1) break;
            graphNode4 = graphNodeArray[n6];
            graphNode3 = graphNodeArray[n5];
            Tensor tensor = (Tensor)graphNode4.extra;
            Tensor tensor2 = (Tensor)graphNode3.extra;
            graphNode3.numberRing();
            int n20 = tensor.rank;
            GraphNodeLink graphNodeLink = graphNode4.firstLink;
            n8 = 0;
            for (int i = 0; i < n20; ++i) {
                GraphNodeLink graphNodeLink2 = graphNodeLink.edgeLink;
                if (graphNodeLink2.node == graphNode3) {
                    nArray2[n8][0] = i;
                    nArray2[n8++][1] = n20 + graphNodeLink2.ringNumber;
                }
                graphNodeLink = graphNodeLink.next;
            }
            Tensor[] tensorArray2 = new Tensor[]{tensor, tensor2};
            graphNode3.extra = new Tensor(tensorArray2, 2).contract(nArray2, n8);
            graphNode3.mergeWith(graphNode4, true);
            graphNodeArray[n6] = null;
            --n11;
            int[] nArray8 = nArray3[n6];
            int[] nArray9 = nArray3[n5];
            for (int i = 0; i < n; ++i) {
                if (i == n5 || (n10 = nArray8[i]) <= 0) continue;
                int n21 = i;
                nArray9[n21] = nArray9[n21] + n10;
                int[] nArray10 = nArray3[i];
                int n22 = n6;
                nArray10[n22] = nArray10[n22] - n10;
                int[] nArray11 = nArray3[i];
                int n23 = n5;
                nArray11[n23] = nArray11[n23] + n10;
            }
            n3 = n5;
        }
        n7 = n11 > 1 ? 1 : 0;
        n6 = 0;
        n5 = 0;
        Tensor[] tensorArray3 = n7 != 0 ? new Tensor[n11] : null;
        int[] nArray12 = n14 > 0 ? new int[n14] : null;
        for (int i = 0; i < n; ++i) {
            graphNode = graphNodeArray[i];
            if (graphNode == null) continue;
            int n24 = graphNode.valence;
            GraphNodeLink graphNodeLink = graphNode.firstLink;
            for (n4 = 0; n4 < n24; ++n4) {
                nArray12[n5++] = graphNodeLink.edgeLink.ringNumber;
                graphNodeLink = graphNodeLink.next;
            }
            Tensor tensor = (Tensor)graphNodeArray[i].extra;
            if (n7 != 0) {
                tensorArray3[n6++] = tensor;
                continue;
            }
            tensor.braid(nArray12);
            return tensor;
        }
        return new Tensor(tensorArray3, n6, nArray12);
    }

    private static Object createArray(int[] nArray, int n, int n2) {
        int n3;
        int n4 = 1;
        for (n3 = 0; n3 < n; ++n3) {
            n4 *= nArray[n3];
        }
        maxSize = Math.max(maxSize, n4);
        if (n == 0) {
            return new Double(0.0);
        }
        if (n == 1) {
            return new double[nArray[n2]];
        }
        n3 = nArray[n2];
        Object[] objectArray = new Object[n3];
        for (int i = 0; i < n3; ++i) {
            objectArray[i] = Tensor.createArray(nArray, n - 1, n2 + 1);
        }
        return objectArray;
    }

    private static void setValue(Object object, int n, int[] nArray, double d) {
        Object object2 = object;
        for (int i = 0; i < n - 1; ++i) {
            object2 = ((Object[])object2)[nArray[i]];
        }
        ((double[])object2)[nArray[n - 1]] = d;
    }

    private static void setComplexValue(Object object, int n, int[] nArray, double d, double d2) {
        Object object2 = object;
        for (int i = 0; i < n; ++i) {
            object2 = ((Object[])object2)[nArray[i]];
        }
        double[] dArray = (double[])object2;
        dArray[0] = d;
        dArray[1] = d2;
    }
}

