/*
 * Decompiled with CFR 0.152.
 */
package egan.physics;

public class AngularMomentum {
    static double[] fList = null;
    static int topF = -1;
    static int sFlist = 0;
    static final int incFlist = 100;

    public static void spinJ(double[][][] dArray, int n, double d, double d2, double d3, double d4) {
        double d5;
        double d6 = d / 2.0;
        double d7 = Math.cos(d6);
        double d8 = Math.sin(d6);
        double d9 = d8 * d2;
        double d10 = d8 * d3;
        double d11 = d8 * d4;
        int n2 = n + 1;
        boolean bl = d == 0.0;
        boolean bl2 = d2 == 0.0 && d3 == 0.0;
        boolean bl3 = !bl && !bl2;
        double d12 = d7 * d7 + d11 * d11;
        double d13 = -(d9 * d9 + d10 * d10);
        double[] dArray2 = null;
        double[] dArray3 = null;
        double[] dArray4 = null;
        double[] dArray5 = null;
        double[] dArray6 = null;
        double[] dArray7 = null;
        double[] dArray8 = null;
        double[] dArray9 = null;
        double[] dArray10 = null;
        double[] dArray11 = null;
        if (bl3) {
            dArray2 = new double[n2];
            dArray3 = new double[n2];
            double d14 = 1.0;
            d5 = 1.0;
            for (int i = 0; i < n2; ++i) {
                dArray2[i] = d14;
                d14 *= d13;
                dArray3[i] = d5;
                d5 *= d12;
            }
            dArray4 = new double[n2];
            dArray5 = new double[n2];
            dArray6 = new double[n2];
            dArray7 = new double[n2];
            dArray8 = new double[n2];
            dArray9 = new double[n2];
            dArray10 = new double[n2];
            dArray11 = new double[n2];
            AngularMomentum.makePowers(n2, d7, -d11, dArray4, dArray5);
            AngularMomentum.makePowers(n2, d7, d11, dArray6, dArray7);
            AngularMomentum.makePowers(n2, d10, -d9, dArray8, dArray9);
            AngularMomentum.makePowers(n2, -d10, -d9, dArray10, dArray11);
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d15;
                double d16;
                int n3;
                double d17;
                double d18;
                int n4;
                if (bl) {
                    dArray[j][i][0] = i == j ? 1.0 : 0.0;
                    dArray[j][i][1] = 0.0;
                    continue;
                }
                if (bl2) {
                    if (i == j) {
                        d5 = d4 * d * ((double)i - (double)n / 2.0);
                        dArray[j][i][0] = Math.cos(d5);
                        dArray[j][i][1] = -Math.sin(d5);
                        continue;
                    }
                    dArray[j][i][0] = 0.0;
                    dArray[j][i][1] = 0.0;
                    continue;
                }
                int n5 = i - j;
                int n6 = n - i - j;
                if (n6 > 0) {
                    n4 = 0;
                    d18 = dArray6[n6];
                    d17 = dArray7[n6];
                } else {
                    n4 = -n6;
                    d18 = dArray4[n4];
                    d17 = dArray5[n4];
                }
                if (n5 < 0) {
                    n3 = i;
                    d16 = dArray10[-n5];
                    d15 = dArray11[-n5];
                } else {
                    n3 = j;
                    d16 = dArray8[n5];
                    d15 = dArray9[n5];
                }
                double d19 = Math.sqrt(AngularMomentum.factorial(j) * AngularMomentum.factorial(n - j) * AngularMomentum.factorial(i) * AngularMomentum.factorial(n - i));
                double d20 = 0.0;
                for (int k = n4; k <= n3; ++k) {
                    d20 += dArray3[k - n4] * dArray2[n3 - k] / (AngularMomentum.factorial(k) * AngularMomentum.factorial(j - k) * AngularMomentum.factorial(i - k) * AngularMomentum.factorial(n6 + k));
                }
                dArray[j][i][0] = (d20 *= d19) * (d18 * d16 - d17 * d15);
                dArray[j][i][1] = d20 * (d18 * d15 + d17 * d16);
            }
        }
    }

    public static double[][][] spinJcoeffs(int n) {
        int n2 = n + 1;
        double[][][] dArray = new double[n2][n2][];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = i - j;
                int n4 = n - i - j;
                int n5 = Math.max(0, -n4);
                int n6 = Math.min(i, j);
                int n7 = n6 - n5 + 1;
                double[] dArray2 = new double[n7];
                dArray[i][j] = dArray2;
                double[] dArray3 = dArray2;
                double d = Math.sqrt(AngularMomentum.factorial(j) * AngularMomentum.factorial(n - j) * AngularMomentum.factorial(i) * AngularMomentum.factorial(n - i));
                for (int k = n5; k <= n6; ++k) {
                    dArray3[k - n5] = (double)(1 - 2 * (k % 2)) * d / (AngularMomentum.factorial(k) * AngularMomentum.factorial(j - k) * AngularMomentum.factorial(i - k) * AngularMomentum.factorial(n4 + k));
                }
            }
        }
        return dArray;
    }

    public static void spinJpolar(double[][][] dArray, int n, double[][][] dArray2, double d, double d2, double d3, double d4) {
        int n2;
        double d5 = d / 2.0;
        double d6 = Math.cos(d5);
        double d7 = Math.sin(d5);
        double d8 = d7 * d2;
        double d9 = d7 * d3;
        double d10 = d7 * d4;
        int n3 = n + 1;
        boolean bl = d == 0.0;
        boolean bl2 = d2 == 0.0 && d3 == 0.0;
        boolean bl3 = !bl && !bl2;
        double d11 = Math.sqrt(d8 * d8 + d9 * d9);
        double d12 = Math.sqrt(1.0 - d11 * d11);
        double d13 = Math.atan2(-d10, d6);
        double d14 = Math.atan2(-d9, -d8);
        double[] dArray3 = null;
        double[] dArray4 = null;
        if (bl3) {
            dArray3 = new double[2 * n3];
            dArray4 = new double[2 * n3];
            double d15 = 1.0;
            double d16 = 1.0;
            for (n2 = 0; n2 < 2 * n3; ++n2) {
                dArray3[n2] = d15;
                d15 *= d11;
                dArray4[n2] = d16;
                d16 *= d12;
            }
        }
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n3; ++j) {
                if (bl) {
                    dArray[j][i][0] = i == j ? 1.0 : 0.0;
                    dArray[j][i][1] = 0.0;
                    continue;
                }
                if (bl2) {
                    if (i == j) {
                        dArray[j][i][0] = 1.0;
                        dArray[j][i][1] = d4 * d * ((double)n / 2.0 - (double)i);
                        continue;
                    }
                    dArray[j][i][0] = 0.0;
                    dArray[j][i][1] = 0.0;
                    continue;
                }
                int n4 = i - j;
                int n5 = n - i - j;
                n2 = i + j;
                int n6 = Math.max(0, -n5);
                int n7 = Math.min(i, j);
                int n8 = n7 - n6 + 1;
                double d17 = 0.0;
                double[] dArray5 = dArray2[i][j];
                for (int k = n6; k <= n7; ++k) {
                    int n9 = 2 * k;
                    d17 += dArray4[n5 + n9] * dArray3[n2 - n9] * dArray5[k - n6];
                }
                if (d17 < 0.0) {
                    d17 = -d17;
                    n2 += 2;
                }
                dArray[j][i][0] = d17;
                dArray[j][i][1] = (double)(-n5) * d13 + (double)n4 * d14 + 1.5707963267948966 * (double)n2;
            }
        }
    }

    private static void makePowers(int n, double d, double d2, double[] dArray, double[] dArray2) {
        double d3 = 1.0;
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            dArray[i] = d3;
            dArray2[i] = d4;
            double d5 = d3 * d - d4 * d2;
            d4 = d3 * d2 + d * d4;
            d3 = d5;
        }
    }

    public static double[][] ClebschGordan(int n, int n2, int n3) {
        int n4 = n + n2 - n3;
        if (n < 0 || n2 < 0 || n3 < 0 || n3 < Math.abs(n - n2) || n4 < 0 || n4 % 2 != 0) {
            throw new IllegalArgumentException("Illegal spin values");
        }
        int n5 = n + 1;
        int n6 = n2 + 1;
        int n7 = n3 + 1;
        double[][] dArray = new double[n5][n6];
        int n8 = (-n + n2 + n3) / 2;
        int n9 = (n - n2 + n3) / 2;
        int n10 = n4 / 2;
        double d = Math.sqrt((double)n7 * AngularMomentum.factorial(n8) * AngularMomentum.factorial(n9) * AngularMomentum.factorial(n10) / AngularMomentum.factorial(n8 + n9 + n10 + 1));
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n6; ++j) {
                int n11 = i + j - n10;
                if (n11 < 0 || n11 >= n7) continue;
                int n12 = n - i;
                int n13 = n2 - j;
                int n14 = n3 - n11;
                double d2 = Math.sqrt(AngularMomentum.factorial(i) * AngularMomentum.factorial(n12) * AngularMomentum.factorial(j) * AngularMomentum.factorial(n13) * AngularMomentum.factorial(n11) * AngularMomentum.factorial(n14));
                double d3 = 0.0;
                int n15 = Math.max(0, Math.max(n10 - n12, n10 - j));
                int n16 = Math.min(n10, Math.min(i, n13));
                int n17 = (n10 - n15) % 2 == 0 ? 1 : -1;
                for (int k = n15; k <= n16; ++k) {
                    d3 += (double)n17 / (AngularMomentum.factorial(i - k) * AngularMomentum.factorial(n9 - i + k) * AngularMomentum.factorial(n8 - n13 + k) * AngularMomentum.factorial(n13 - k) * AngularMomentum.factorial(k) * AngularMomentum.factorial(n10 - k));
                    n17 = -n17;
                }
                dArray[i][j] = d * d2 * d3;
            }
        }
        return dArray;
    }

    public static double factorial(int n) {
        if (n > topF) {
            double d;
            if (n >= sFlist) {
                int n2 = 1 + (n + 1 - sFlist) / 100;
                int n3 = sFlist + n2 * 100;
                double[] dArray = new double[n3];
                if (fList != null) {
                    for (int i = 0; i < sFlist; ++i) {
                        dArray[i] = fList[i];
                    }
                }
                fList = dArray;
                sFlist = n3;
            }
            if (topF < 0) {
                AngularMomentum.fList[0] = 1.0;
                d = 1.0;
                topF = 0;
            } else {
                d = fList[topF];
            }
            while (topF < n) {
                d = AngularMomentum.fList[AngularMomentum.topF] = (double)(++topF) * d;
            }
            return d;
        }
        return fList[n];
    }
}

